/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.masters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.LicenseSubCategoryDetails;
import org.egov.tl.entity.enums.RateTypeEnum;
import org.egov.tl.service.FeeMatrixService;
import org.egov.tl.service.FeeTypeService;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.egov.tl.service.masters.LicenseSubCategoryService;
import org.egov.tl.service.masters.UnitOfMeasurementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/*
 * Exception performing whole class analysis ignored.
 */
@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="licenseSubCategory-new.jsp"), @Result(name={"search"}, location="licenseSubCategory-search.jsp"), @Result(name={"edit"}, location="licenseSubCategory-edit.jsp")})
public class LicenseSubCategoryAction
extends BaseFormAction {
    private static final long serialVersionUID = 6242612156153747913L;
    private LicenseSubCategory subCategory = new LicenseSubCategory();
    private Long id;
    private Long categoryId;
    public static final String SEARCH = "search";
    public static final String VIEW = "view";
    private Map<Long, String> licenseCategoryMap;
    private Map<Long, String> licenseSubCategoryMap;
    @Autowired
    @Qualifier(value="licenseSubCategoryService")
    private LicenseSubCategoryService licenseSubCategoryService;
    @Autowired
    @Qualifier(value="licenseCategoryService")
    private LicenseCategoryService licenseCategoryService;
    @Autowired
    @Qualifier(value="feeTypeService")
    private FeeTypeService feeTypeService;
    @Autowired
    @Qualifier(value="unitOfMeasurementService")
    private UnitOfMeasurementService unitOfMeasurementService;
    @Autowired
    @Qualifier(value="feeMatrixService")
    private FeeMatrixService feeMatrixService;
    private boolean feeExists;
    private static final Logger LOGGER = Logger.getLogger(LicenseSubCategoryAction.class);
    private List<LicenseSubCategoryDetails> subCategoryMappingDetails = new ArrayList();
    private String userMode;
    private String licenseFee;

    public Object getModel() {
        return this.subCategory;
    }

    public void prepare() {
        this.licenseFee = "License Fee";
        this.setLicenseCategoryMap(LicenseSubCategoryAction.getFormattedCategoryMap((List)this.licenseCategoryService.findAll()));
        this.addDropdownData("feeTypeList", this.feeTypeService.findAll());
        this.addDropdownData("rateTypeList", Arrays.asList(RateTypeEnum.values()));
        this.addDropdownData("uomList", this.unitOfMeasurementService.findAllActiveUOM());
        if (this.userMode != null && !this.userMode.isEmpty() && (this.userMode.equalsIgnoreCase("edit") || this.userMode.equalsIgnoreCase("view"))) {
            this.setLicenseSubCategoryMap(Collections.EMPTY_MAP);
        }
        if (this.getId() != null) {
            this.subCategory = this.licenseSubCategoryService.findById(this.getId());
            this.setCategoryId(this.subCategory.getCategory().getId());
            if (this.userMode != null && !this.userMode.isEmpty() && this.userMode.equalsIgnoreCase("edit")) {
                List feeMatrixList = this.feeMatrixService.findBySubCategory(this.subCategory);
                this.feeExists = feeMatrixList != null && !feeMatrixList.isEmpty() && feeMatrixList.size() > 0;
            }
        }
    }

    public static Map<Long, String> getFormattedCategoryMap(List<LicenseCategory> licenseCategoryList) {
        TreeMap<Long, String> categoryMap = new TreeMap<Long, String>();
        for (LicenseCategory licenseCategory : licenseCategoryList) {
            categoryMap.put(licenseCategory.getId(), licenseCategory.getName().concat(" ~ ").concat(licenseCategory.getCode()));
        }
        return categoryMap;
    }

    public static Map<Long, String> getFormattedSubCategoryMap(List<LicenseSubCategory> licenseSubCategoryList) {
        TreeMap<Long, String> subCategoryMap = new TreeMap<Long, String>();
        for (LicenseSubCategory licenseSubCategory : licenseSubCategoryList) {
            subCategoryMap.put(licenseSubCategory.getId(), licenseSubCategory.getName().concat(" ~ ").concat(licenseSubCategory.getCode()));
        }
        return subCategoryMap;
    }

    @Action(value="/masters/licenseSubCategory-newform")
    public String newform() {
        if (this.userMode != null && !this.userMode.isEmpty()) {
            if (this.userMode.equalsIgnoreCase("view")) {
                this.userMode = "view";
            } else if (this.userMode.equalsIgnoreCase("edit")) {
                this.userMode = "edit";
            }
        } else {
            this.userMode = "new";
        }
        return "new";
    }

    @Action(value="/masters/licenseSubCategory-edit")
    public String edit() {
        if (this.userMode.equalsIgnoreCase("edit")) {
            this.userMode = "edit";
        } else if (this.userMode.equalsIgnoreCase("view")) {
            this.userMode = "view";
        }
        return "search";
    }

    @ValidationErrorPage(value="edit")
    @Action(value="/masters/licenseSubCategory-save")
    public String save() throws NumberFormatException, ApplicationException {
        try {
            this.subCategory = this.licenseSubCategoryService.create(this.subCategory, this.subCategoryMappingDetails, this.categoryId);
        }
        catch (ValidationException valEx) {
            LOGGER.error((Object)("Exception found while persisting License category: " + valEx.getErrors()));
            throw new ValidationException(valEx.getErrors());
        }
        if (this.userMode.equalsIgnoreCase("new")) {
            this.addActionMessage(this.subCategory.getName() + " " + this.getText("license.subcategory.save.success"));
        } else if (this.userMode.equalsIgnoreCase("edit")) {
            this.addActionMessage(this.subCategory.getName() + " " + this.getText("license.subcategory.edit.success"));
        }
        this.userMode = "success";
        return "new";
    }

    public String getUserMode() {
        return this.userMode;
    }

    public void setUserMode(String userMode) {
        this.userMode = userMode;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public Map<Long, String> getLicenseCategoryMap() {
        return this.licenseCategoryMap;
    }

    public void setLicenseCategoryMap(Map<Long, String> licenseCategoryMap) {
        this.licenseCategoryMap = licenseCategoryMap;
    }

    public Map<Long, String> getLicenseSubCategoryMap() {
        return this.licenseSubCategoryMap;
    }

    public void setLicenseSubCategoryMap(Map<Long, String> licenseSubCategoryMap) {
        this.licenseSubCategoryMap = licenseSubCategoryMap;
    }

    public LicenseSubCategory getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(LicenseSubCategory subCategory) {
        this.subCategory = subCategory;
    }

    public String getLicenseFee() {
        return this.licenseFee;
    }

    public void setLicenseFee(String licenseFee) {
        this.licenseFee = licenseFee;
    }

    public List<LicenseSubCategoryDetails> getSubCategoryMappingDetails() {
        return this.subCategoryMappingDetails;
    }

    public void setSubCategoryMappingDetails(List<LicenseSubCategoryDetails> subCategoryMappingDetails) {
        this.subCategoryMappingDetails = subCategoryMappingDetails;
    }

    public boolean isFeeExists() {
        return this.feeExists;
    }

    public void setFeeExists(boolean feeExists) {
        this.feeExists = feeExists;
    }
}

