/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import java.util.List;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.dto.PenaltyForm;
import org.egov.tl.service.PenaltyRatesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/penaltyRates"})
public class PenaltyRatesController {
    @Autowired
    private PenaltyRatesService penaltyRatesService;

    @ModelAttribute(value="licenseAppTypes")
    public List<LicenseAppType> licenseAppTypes() {
        return this.penaltyRatesService.findAllLicenseAppType();
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String penaltyRatesForm(@ModelAttribute PenaltyForm penaltyForm, Model model) {
        return "penaltyRates-create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String penaltyRatesCreate(@ModelAttribute PenaltyForm penaltyForm, BindingResult bindingResult, RedirectAttributes redirectAttributes, Model model) {
        if (bindingResult.hasErrors()) {
            return "penaltyRates-result";
        }
        this.penaltyRatesService.create(penaltyForm.getPenaltyRates());
        redirectAttributes.addFlashAttribute("message", (Object)"msg.penaltyRate.created");
        return "penaltyRates-view";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(@ModelAttribute PenaltyForm penaltyForm, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            return "penaltyRates-result";
        }
        penaltyForm.setPenaltyRatesList(this.penaltyRatesService.search(penaltyForm.getLicenseAppType().getId()));
        model.addAttribute("penaltyForm", (Object)penaltyForm);
        return "penaltyRates-result";
    }
}

