/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.subcategory;

import javax.validation.Valid;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.service.FeeTypeService;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.egov.tl.service.masters.LicenseSubCategoryService;
import org.egov.tl.service.masters.UnitOfMeasurementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/licensesubcategory"})
public class UpdateSubCategoryController {
    private final LicenseSubCategoryService licenseSubCategoryService;
    @Autowired
    private LicenseCategoryService licenseCategoryService;
    @Autowired
    private UnitOfMeasurementService unitOfMeasurementService;
    @Autowired
    private FeeTypeService feeTypeService;

    @Autowired
    public UpdateSubCategoryController(LicenseSubCategoryService licenseSubCategoryService) {
        this.licenseSubCategoryService = licenseSubCategoryService;
    }

    @ModelAttribute
    public LicenseSubCategory licenseSubCategoryModel(@PathVariable String code) {
        return this.licenseSubCategoryService.findSubCategoryByCode(code);
    }

    @RequestMapping(value={"/update/{code}"}, method={RequestMethod.GET})
    public String subCategoryUpdateForm(@ModelAttribute @Valid LicenseSubCategory licenseSubCategory, Model model) {
        this.populateDropdownData(model);
        return "subcategory-update";
    }

    @RequestMapping(value={"/update/{code}"}, method={RequestMethod.POST})
    public String updateSubCategory(@ModelAttribute @Valid LicenseSubCategory licenseSubCategory, BindingResult errors, RedirectAttributes additionalAttr, Model model) {
        if (errors.hasErrors()) {
            this.populateDropdownData(model);
            return "subcategory-update";
        }
        this.licenseSubCategoryService.updateLicenseSubCategory(licenseSubCategory);
        additionalAttr.addFlashAttribute("message", (Object)"msg.success.subcategory.update");
        return "redirect:/licensesubcategory/view/" + licenseSubCategory.getCode();
    }

    private void populateDropdownData(Model model) {
        model.addAttribute("licenseCategories", (Object)this.licenseCategoryService.findAll());
        model.addAttribute("licenseFeeTypes", (Object)this.feeTypeService.findAll());
        model.addAttribute("licenseUomTypes", (Object)this.unitOfMeasurementService.findAll());
    }
}

