/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.category;

import javax.validation.Valid;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/licensecategory"})
public class CreateCategoryController {
    private final LicenseCategoryService licenseCategoryService;

    @Autowired
    public CreateCategoryController(LicenseCategoryService licenseCategoryService) {
        this.licenseCategoryService = licenseCategoryService;
    }

    @ModelAttribute
    public LicenseCategory licenseCategoryModel() {
        return new LicenseCategory();
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String createCategoryForm(Model model) {
        return "licensecategory-create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String createCategory(@ModelAttribute @Valid LicenseCategory licenseCategory, BindingResult errors, RedirectAttributes additionalAttr) {
        if (errors.hasErrors()) {
            return "licensecategory-create";
        }
        this.licenseCategoryService.persistCategory(licenseCategory);
        additionalAttr.addFlashAttribute("message", (Object)"msg.create.category.success");
        return "redirect:/licensecategory/view/" + licenseCategory.getCode();
    }
}

