/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import java.util.Collection;
import javax.validation.Valid;
import org.egov.infra.web.utils.WebUtils;
import org.egov.tl.entity.Validity;
import org.egov.tl.service.NatureOfBusinessService;
import org.egov.tl.service.ValidityService;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.egov.tl.web.response.adaptor.ValidityResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/validity"})
public class ValidityController {
    private static final String VALIDITY_NEW = "validity-new";
    private static final String VALIDITY_RESULT = "validity-result";
    private static final String VALIDITY_EDIT = "validity-edit";
    private static final String VALIDITY_VIEW = "validity-view";
    private static final String VALIDITY_SEARCH = "validity-search";
    private static final String VALIDITY_MODEL_ATTRIB_NAME = "validity";
    @Autowired
    private ValidityService validityService;
    @Autowired
    private NatureOfBusinessService natureOfBusinessService;
    @Autowired
    private LicenseCategoryService licenseCategoryService;

    private void prepareNewForm(Model model) {
        model.addAttribute("natureOfBusinesss", (Object)this.natureOfBusinessService.findAll());
        model.addAttribute("licenseCategorys", (Object)this.licenseCategoryService.findAll());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(@ModelAttribute Validity validity, Model model) {
        this.prepareNewForm(model);
        return VALIDITY_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Validity validity, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (!validity.hasValidValues()) {
            errors.rejectValue("basedOnFinancialYear", "validity.value.notset");
        }
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return VALIDITY_NEW;
        }
        this.validityService.create(validity);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.validity.success");
        return "redirect:/validity/result/" + validity.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        Validity validity = this.validityService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute(VALIDITY_MODEL_ATTRIB_NAME, (Object)validity);
        return VALIDITY_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Validity validity, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (!validity.hasValidValues()) {
            errors.rejectValue("basedOnFinancialYear", "validity.value.notset");
        }
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return VALIDITY_EDIT;
        }
        this.validityService.update(validity);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.validity.success");
        return "redirect:/validity/result/" + validity.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        Validity validity = this.validityService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute(VALIDITY_MODEL_ATTRIB_NAME, (Object)validity);
        return VALIDITY_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        Validity validity = this.validityService.findOne(id);
        model.addAttribute(VALIDITY_MODEL_ATTRIB_NAME, (Object)validity);
        return VALIDITY_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        Validity validity = new Validity();
        this.prepareNewForm(model);
        model.addAttribute(VALIDITY_MODEL_ATTRIB_NAME, (Object)validity);
        return VALIDITY_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, @RequestParam(required=false) Long natureOfBusiness, @RequestParam(required=false) Long licenseCategory) {
        return "{ \"data\":" + WebUtils.toJSON((Collection)this.validityService.search(natureOfBusiness, licenseCategory), Validity.class, ValidityResponseAdaptor.class) + "}";
    }
}

