/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.tl.entity.DemandGenerationLog;
import org.egov.tl.service.DemandGenerationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/demand-generation"})
public class DemandGenerationController {
    @Autowired
    private DemandGenerationService demandGenerationService;

    @ModelAttribute(value="financialYearList")
    public List<CFinancialYear> financialYearList() {
        return this.demandGenerationService.financialYearList();
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String newForm(@ModelAttribute DemandGenerationLog demandGenerationLog) {
        return "demand-generate";
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String demandGeneration(@ModelAttribute DemandGenerationLog demandGenerationLog, RedirectAttributes redirectAttributes) {
        demandGenerationLog = this.demandGenerationService.bulkDemandGeneration(demandGenerationLog);
        redirectAttributes.addFlashAttribute("demandGenerationLog", (Object)demandGenerationLog);
        redirectAttributes.addFlashAttribute("message", (Object)("msg.demand.generation." + demandGenerationLog.getDemandGenerationStatus()));
        return "redirect:/demand-generation/create";
    }

    @RequestMapping(value={"/regenerate"}, method={RequestMethod.POST})
    public String demandRegeneration(@ModelAttribute DemandGenerationLog demandGenerationLog, RedirectAttributes redirectAttributes) {
        demandGenerationLog = this.demandGenerationService.demandRegeneration(demandGenerationLog);
        redirectAttributes.addFlashAttribute("demandGenerationLog", (Object)demandGenerationLog);
        redirectAttributes.addFlashAttribute("message", (Object)("msg.demand.generation." + demandGenerationLog.getDemandGenerationStatus()));
        return "redirect:/demand-generation/create";
    }
}

