/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.viewtradelicense;

import java.io.IOException;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Actions;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.annotation.ValidationErrorPageExt;
import org.egov.tl.entity.License;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.web.actions.BaseLicenseAction;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Result(name={"report"}, location="viewTradeLicense-report.jsp")
public class ViewTradeLicenseAction
extends BaseLicenseAction<TradeLicense> {
    private static final long serialVersionUID = 1L;
    protected TradeLicense tradeLicense = new TradeLicense();
    protected String reportId;
    private String applicationNo;
    @Autowired
    private ReportService reportService;
    @Autowired
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public TradeLicense getModel() {
        return this.tradeLicense;
    }

    @Action(value="/viewtradelicense/viewTradeLicense-showForApproval")
    public String showForApproval() throws IOException {
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        return super.showForApproval();
    }

    @Actions(value={@Action(value="/viewtradelicense/viewTradeLicense-view"), @Action(value="/public/viewtradelicense/viewTradeLicense-view")})
    public String view() {
        if (this.license() != null && this.license().getId() != null) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        } else if (this.applicationNo != null && !this.applicationNo.isEmpty()) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseByApplicationNumber(this.applicationNo);
        }
        return "view";
    }

    @Action(value="/viewtradelicense/viewTradeLicense-generateCertificate")
    public String generateCertificate() {
        this.setLicenseIdIfServletRedirect();
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.reportService.createReport(this.tradeLicenseService.prepareReportInputData((License)this.license())));
        return "report";
    }

    private void setLicenseIdIfServletRedirect() {
        if (this.tradeLicense.getId() == null && this.getSession().get("model.id") != null) {
            this.tradeLicense.setId(Long.valueOf((Long)this.getSession().get("model.id")));
            this.getSession().remove("model.id");
        }
    }

    @SkipValidation
    @Action(value="/viewtradelicense/viewTradeLicense-generateRejCertificate")
    public String generateRejCertificate() {
        this.setLicenseIdIfServletRedirect();
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        return "rejCertificate";
    }

    @SkipValidation
    @Action(value="/viewtradelicense/viewTradeLicense-certificateForRej")
    public String certificateForRej() {
        this.getSession().get("model.id");
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        return "certificateForRej";
    }

    @Action(value="/viewtradelicense/viewTradeLicense-duplicateCertificate")
    public String duplicateCertificate() {
        return "duplicate";
    }

    protected TradeLicense license() {
        return this.tradeLicense;
    }

    @SkipValidation
    @ValidationErrorPageExt(action="approve", makeCall=true, toMethod="setupWorkflowDetails")
    public String approve() {
        this.setRoleName(this.securityUtils.getCurrentUser().getRoles().toString());
        return super.approve();
    }

    @SkipValidation
    @ValidationErrorPageExt(action="approveRenew", makeCall=true, toMethod="setupWorkflowDetails")
    public String approveRenew() {
        this.setRoleName(this.securityUtils.getCurrentUser().getRoles().toString());
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        return super.approveRenew();
    }

    protected AbstractLicenseService<TradeLicense> licenseService() {
        return this.tradeLicenseService;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    public String getApplicationNo() {
        return this.applicationNo;
    }

    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public String getReportId() {
        return this.reportId;
    }
}

