/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.newtradelicense;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.web.struts.annotation.ValidationErrorPageExt;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.Licensee;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.entity.enums.ApplicationType;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.FeeMatrixService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.utils.Constants;
import org.egov.tl.web.actions.BaseLicenseAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"edit"}, location="editTradeLicense-edit.jsp"), @Result(name={"new"}, location="newTradeLicense-new.jsp"), @Result(name={"message"}, location="editTradeLicense-message.jsp")})
public class EditTradeLicenseAction
extends BaseLicenseAction {
    private static final long serialVersionUID = 1L;
    private TradeLicense tradeLicense = new TradeLicense();
    private boolean isOldLicense;
    private List<LicenseDocumentType> documentTypes = new ArrayList();
    private String mode;
    private Map<String, String> ownerShipTypeMap;
    private Long id;
    @Autowired
    @Qualifier(value="tradeLicenseService")
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private FeeMatrixService feeMatrixService;

    public EditTradeLicenseAction() {
        this.tradeLicense.setLicensee(new Licensee());
    }

    public License getModel() {
        return this.tradeLicense;
    }

    public void setModel(TradeLicense tradeLicense) {
        this.tradeLicense = tradeLicense;
    }

    public void prepareBeforeEdit() {
        Boundary licenseboundary;
        this.prepareNewForm();
        this.setDocumentTypes(this.tradeLicenseService.getDocumentTypesByApplicationType(ApplicationType.NEW));
        Long id = null;
        if (this.tradeLicense.getId() == null) {
            if (this.getSession().get("model.id") != null) {
                id = (Long)this.getSession().get("model.id");
                this.getSession().remove("model.id");
            } else {
                id = this.tradeLicense.getId();
            }
        } else {
            id = this.tradeLicense.getId();
        }
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(id);
        if (this.tradeLicense.getOldLicenseNumber() != null) {
            this.isOldLicense = StringUtils.isNotBlank((String)this.tradeLicense.getOldLicenseNumber());
        }
        if ((licenseboundary = this.boundaryService.getBoundaryById(this.tradeLicense.getBoundary().getId())).getName().contains("Zone")) {
            this.addDropdownData("divisionListLicense", Collections.EMPTY_LIST);
        }
        this.setRoleName(this.securityUtils.getCurrentUser().getRoles().toString());
        this.setOwnerShipTypeMap(Constants.OWNERSHIP_TYPE);
        List localityList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
        this.addDropdownData("localityList", localityList);
        this.addDropdownData("tradeTypeList", this.tradeLicenseService.getAllNatureOfBusinesses());
        this.addDropdownData("categoryList", this.licenseCategoryService.findAll());
        this.addDropdownData("uomList", this.unitOfMeasurementService.findAllActiveUOM());
        this.addDropdownData("subCategoryList", this.tradeLicense.getCategory() == null ? Collections.emptyList() : this.licenseSubCategoryService.findAllSubCategoryByCategory(this.tradeLicense.getCategory().getId()));
    }

    @SkipValidation
    @Action(value="/newtradelicense/editTradeLicense-beforeEdit")
    public String beforeEdit() {
        this.mode = "edit";
        return "new";
    }

    public void setupBeforeEdit() {
        this.prepareBeforeEdit();
        this.setupWorkflowDetails();
    }

    public void prepare() {
        if (this.id != null) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.id);
        }
    }

    @ValidationErrorPageExt(action="edit", makeCall=true, toMethod="setupBeforeEdit")
    @Action(value="/newtradelicense/editTradeLicense-edit")
    public String edit() {
        if (this.tradeLicense.getState() == null && !this.isOldLicense) {
            this.tradeLicenseService.transitionWorkFlow((License)this.tradeLicense, this.workflowBean);
        }
        if (!this.isOldLicense) {
            this.processWorkflow("new");
        }
        this.tradeLicenseService.processAndStoreDocument(this.tradeLicense.getDocuments(), (License)this.tradeLicense);
        LicenseAppType newAppType = (LicenseAppType)this.persistenceService.find("from  LicenseAppType where name='New' ");
        this.tradeLicense.setLicenseAppType(newAppType);
        this.tradeLicense = (TradeLicense)this.persistenceService.update((Object)this.tradeLicense);
        return "message";
    }

    public boolean acceptableParameterName(String paramName) {
        List<String> nonAcceptable = Arrays.asList("licensee.boundary.parent", "boundary.parent", "tradeName.name");
        boolean retValue = super.acceptableParameterName(paramName);
        return retValue ? !nonAcceptable.contains(paramName) : retValue;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    protected License license() {
        return this.tradeLicense;
    }

    protected AbstractLicenseService licenseService() {
        return this.tradeLicenseService;
    }

    public boolean getIsOldLicense() {
        return this.isOldLicense;
    }

    public void setIsOldLicense(boolean isOldLicense) {
        this.isOldLicense = isOldLicense;
    }

    public List<LicenseDocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public void setDocumentTypes(List<LicenseDocumentType> documentTypes) {
        this.documentTypes = documentTypes;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Map<String, String> getOwnerShipTypeMap() {
        return this.ownerShipTypeMap;
    }

    public void setOwnerShipTypeMap(Map<String, String> ownerShipTypeMap) {
        this.ownerShipTypeMap = ownerShipTypeMap;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

