/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.integration;

import java.io.IOException;
import java.net.URLEncoder;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.egov.demand.interfaces.Billable;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.tl.entity.License;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.service.integration.LicenseBill;
import org.egov.tl.service.integration.LicenseBillService;
import org.egov.tl.utils.LicenseNumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
public class LicenseBillCollectAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private Long licenseId;
    private LicenseBill licenseBill;
    private String collectXML;
    @Autowired
    private LicenseBillService licenseBillService;
    @Autowired
    private LicenseNumberUtils licenseNumberUtils;
    @Autowired
    @Qualifier(value="tradeLicenseService")
    private TradeLicenseService tradeLicenseService;

    public String execute() throws IOException {
        License license = this.tradeLicenseService.getLicenseById(this.licenseId);
        if (license.isPaid()) {
            ServletActionContext.getResponse().setContentType("text/html");
            ServletActionContext.getResponse().getWriter().write("<center style='color:red;font-weight:bolder'>License Fee already collected !</center>");
            return null;
        }
        this.licenseBill.setLicense(license);
        this.licenseBill.setReferenceNumber(this.licenseNumberUtils.generateBillNumber());
        this.licenseBillService.setLicense(license);
        this.collectXML = URLEncoder.encode(this.licenseBillService.getBillXML((Billable)this.licenseBill), "UTF-8");
        return "success";
    }

    public String renew() throws IOException {
        if (this.getSession().get("model.id") != null) {
            this.licenseId = (long)((Long)this.getSession().get("model.id"));
            this.getSession().remove("model.id");
        }
        License license = this.tradeLicenseService.getLicenseById(this.licenseId);
        this.licenseBill.setLicense(license);
        this.licenseBillService.setLicense(license);
        this.collectXML = URLEncoder.encode(this.licenseBillService.getBillXML((Billable)this.licenseBill), "UTF-8");
        return "success";
    }

    public Object getModel() {
        return null;
    }

    public String getCollectXML() {
        return this.collectXML;
    }

    public Long getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(Long licenseId) {
        this.licenseId = licenseId;
    }

    public void setLicenseBill(LicenseBill licenseBill) {
        this.licenseBill = licenseBill;
    }
}

