/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.entertradelicense;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.struts.annotation.ValidationErrorPageExt;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.Licensee;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.enums.ApplicationType;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.utils.Constants;
import org.egov.tl.web.actions.BaseLicenseAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="enterTradeLicense-new.jsp"), @Result(name={"update"}, location="enterTradeLicense-update.jsp"), @Result(name={"viewlicense"}, type="redirectAction", location="viewTradeLicense-view", params={"namespace", "/viewtradelicense", "model.id", "${model.id}"})})
public class EnterTradeLicenseAction
extends BaseLicenseAction<TradeLicense> {
    private static final long serialVersionUID = 1L;
    private TradeLicense tradeLicense = new TradeLicense();
    private List<LicenseDocumentType> documentTypes = new ArrayList();
    private Map<String, String> ownerShipTypeMap = new HashMap();
    private Map<Integer, Integer> legacyInstallmentwiseFees = new TreeMap();
    private Map<Integer, Boolean> legacyFeePayStatus = new TreeMap();
    private String licenseNumber;
    @Autowired
    @Qualifier(value="tradeLicenseService")
    private TradeLicenseService tradeLicenseService;

    public EnterTradeLicenseAction() {
        this.tradeLicense.setLicensee(new Licensee());
    }

    @SkipValidation
    @Action(value="/entertradelicense/enterTradeLicense-enterExistingForm")
    public String enterExistingForm() {
        this.tradeLicense.setApplicationDate(new Date());
        for (Installment installment : this.tradeLicenseService.getLastFiveYearInstallmentsForLicense()) {
            this.legacyInstallmentwiseFees.put(installment.getInstallmentNumber(), 0);
            this.legacyFeePayStatus.put(installment.getInstallmentNumber(), false);
        }
        return super.newForm();
    }

    @ValidationErrorPage(value="new")
    @Action(value="/entertradelicense/enterTradeLicense-enterExisting")
    public String create() {
        return super.enterExisting((License)this.tradeLicense, this.legacyInstallmentwiseFees, this.legacyFeePayStatus);
    }

    @SkipValidation
    @Action(value="/entertradelicense/update-form")
    public String showLegacyUpdateForm() {
        if (!this.license().isNew()) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        }
        if (this.tradeLicense != null && this.tradeLicense.isLegacy() && this.tradeLicense.isPaid()) {
            throw new ValidationException("legacy.license.modify.excp", "You can't modify this license", new String[0]);
        }
        this.prepareFeeDetails();
        return "update";
    }

    @Action(value="/entertradelicense/update")
    @ValidationErrorPageExt(action="update", makeCall=true, toMethod="prepareFeeDetails")
    public String update() {
        this.tradeLicenseService.updateLegacyLicense((License)this.tradeLicense, this.legacyInstallmentwiseFees, this.legacyFeePayStatus);
        return "viewlicense";
    }

    public void prepareUpdate() {
        this.commonFormPrepare();
    }

    public void prepareFeeDetails() {
        this.prepareUpdate();
        for (Installment installment : this.tradeLicenseService.getLastFiveYearInstallmentsForLicense()) {
            this.legacyInstallmentwiseFees.put(installment.getInstallmentNumber(), 0);
            this.legacyFeePayStatus.put(installment.getInstallmentNumber(), false);
        }
        for (EgDemandDetails demandDetail : this.license().getCurrentDemand().getEgDemandDetails()) {
            this.legacyInstallmentwiseFees.put(demandDetail.getEgDemandReason().getEgInstallmentMaster().getInstallmentNumber(), demandDetail.getAmount().intValue());
            this.legacyFeePayStatus.put(demandDetail.getEgDemandReason().getEgInstallmentMaster().getInstallmentNumber(), demandDetail.getAmtCollected().compareTo(BigDecimal.ZERO) != 0 && demandDetail.getAmtCollected().compareTo(demandDetail.getAmount()) == 0);
        }
    }

    public void prepareNewForm() {
        this.commonFormPrepare();
    }

    public void commonFormPrepare() {
        if (StringUtils.isNotBlank((CharSequence)this.licenseNumber)) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseByLicenseNumber(this.licenseNumber);
        } else if (!this.license().isNew()) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        }
        super.prepareNewForm();
        this.setDocumentTypes(this.tradeLicenseService.getDocumentTypesByApplicationType(ApplicationType.NEW));
        this.setOwnerShipTypeMap(Constants.OWNERSHIP_TYPE);
        this.addDropdownData("localityList", this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION"));
        this.addDropdownData("tradeTypeList", this.tradeLicenseService.getAllNatureOfBusinesses());
        this.addDropdownData("categoryList", this.licenseCategoryService.findAll());
        this.addDropdownData("subCategoryList", this.tradeLicense.getCategory() == null ? Collections.emptyList() : this.licenseSubCategoryService.findAllSubCategoryByCategory(this.tradeLicense.getCategory().getId()));
        if (this.license().getAgreementDate() != null) {
            this.setShowAgreementDtl(true);
        }
    }

    public TradeLicense getModel() {
        return this.tradeLicense;
    }

    protected TradeLicense license() {
        return this.tradeLicense;
    }

    protected AbstractLicenseService<TradeLicense> licenseService() {
        return this.tradeLicenseService;
    }

    public List<LicenseDocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public void setDocumentTypes(List<LicenseDocumentType> documentTypes) {
        this.documentTypes = documentTypes;
    }

    public Map<String, String> getOwnerShipTypeMap() {
        return this.ownerShipTypeMap;
    }

    public void setOwnerShipTypeMap(Map<String, String> ownerShipTypeMap) {
        this.ownerShipTypeMap = ownerShipTypeMap;
    }

    public Map<Integer, Integer> getLegacyInstallmentwiseFees() {
        return this.legacyInstallmentwiseFees;
    }

    public void setLegacyInstallmentwiseFees(Map<Integer, Integer> legacyInstallmentwiseFees) {
        this.legacyInstallmentwiseFees = legacyInstallmentwiseFees;
    }

    public Map<Integer, Boolean> getLegacyFeePayStatus() {
        return this.legacyFeePayStatus;
    }

    public void setLegacyFeePayStatus(Map<Integer, Boolean> legacyFeePayStatus) {
        this.legacyFeePayStatus = legacyFeePayStatus;
    }

    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }
}

