/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.PositionMasterService;
import org.egov.eis.web.actions.workflow.GenericWorkFlowAction;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.NumberToWord;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.LicenseDemand;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.FeeTypeService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.service.TradeLicenseSmsAndEmailService;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.egov.tl.service.masters.LicenseSubCategoryService;
import org.egov.tl.service.masters.UnitOfMeasurementService;
import org.egov.tl.utils.LicenseUtils;
import org.egov.tl.web.actions.domain.CommonAjaxAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"collection"}, type="redirectAction", location="licenseBillCollect", params={"namespace", "/integration", "method", "renew"}), @Result(name={"tl_editlicense"}, type="redirectAction", location="editTradeLicense-beforeEdit", params={"namespace", "/newtradelicense"}), @Result(name={"tl_approve"}, type="redirectAction", location="viewTradeLicense", params={"namespace", "/viewtradelicense", "method", "showForApproval"}), @Result(name={"tl_generateRejCertificate"}, type="redirectAction", location="viewTradeLicense", params={"namespace", "/viewtradelicense", "method", "generateRejCertificate"}), @Result(name={"tl_generateCertificate"}, type="redirectAction", location="viewTradeLicense", params={"namespace", "/viewtradelicense", "method", "generateCertificate"}), @Result(name={"approve"}, location="newTradeLicense-new.jsp"), @Result(name={"report"}, location="newTradeLicense-report.jsp"), @Result(name={"digitalSignatureRedirection"}, location="newTradeLicense-digitalSignatureRedirection.jsp")})
public abstract class BaseLicenseAction<T extends License>
extends GenericWorkFlowAction {
    private static final long serialVersionUID = 1L;
    protected WorkflowBean workflowBean = new WorkflowBean();
    protected List<String> buildingTypeList;
    protected String roleName;
    protected String reportId;
    private Long feeTypeId;
    protected boolean showAgreementDtl;
    private String fileStoreIds;
    private String ulbCode;
    private String signedFileStoreId;
    private TradeLicenseSmsAndEmailService tradeLicenseSmsAndEmailService;
    @Autowired
    protected LicenseUtils licenseUtils;
    @Autowired
    protected PositionMasterService positionMasterService;
    @Autowired
    protected SecurityUtils securityUtils;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    protected BoundaryService boundaryService;
    @Autowired
    protected DesignationService designationService;
    @Autowired
    protected EisCommonService eisCommonService;
    @Autowired
    protected UserService userService;
    @Autowired
    @Qualifier(value="licenseCategoryService")
    protected LicenseCategoryService licenseCategoryService;
    @Autowired
    private TradeLicenseService tradeLicenseService;
    @Autowired
    @Qualifier(value="licenseSubCategoryService")
    protected LicenseSubCategoryService licenseSubCategoryService;
    @Autowired
    @Qualifier(value="unitOfMeasurementService")
    protected UnitOfMeasurementService unitOfMeasurementService;
    @Autowired
    private ReportService reportService;
    @Autowired
    @Qualifier(value="feeTypeService")
    private FeeTypeService feeTypeService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public BaseLicenseAction() {
        this.addRelatedEntity("boundary", Boundary.class);
        this.addRelatedEntity("parentBoundary", Boundary.class);
        this.addRelatedEntity("licensee.boundary", Boundary.class);
        this.addRelatedEntity("natureOfBusiness", NatureOfBusiness.class);
        this.addRelatedEntity("category", LicenseCategory.class);
        this.addRelatedEntity("tradeName", LicenseSubCategory.class);
    }

    protected abstract T license();

    protected abstract AbstractLicenseService<T> licenseService();

    @ValidationErrorPage(value="new")
    public String create(T license) {
        this.populateWorkflowBean();
        this.licenseService().create(license, this.workflowBean);
        this.addActionMessage(this.getText("license.submission.succesful") + this.license().getApplicationNumber());
        return "acknowledgement";
    }

    @ValidationErrorPage(value="new")
    public String enterExisting(T license, Map<Integer, Integer> legacyInstallmentwiseFees, Map<Integer, Boolean> legacyFeePayStatus) {
        this.licenseService().createLegacyLicense(license, legacyInstallmentwiseFees, legacyFeePayStatus);
        this.addActionMessage(this.getText("license.entry.succesful") + "  " + this.license().getLicenseNumber());
        return "viewlicense";
    }

    public String approve() {
        if (this.workFlowAction.equals("Preview")) {
            return this.redirectToPrintCertificate();
        }
        if (this.workFlowAction.equals("Sign")) {
            return this.digitalSignRedirection();
        }
        this.tradeLicenseService.updateStatusInWorkFlowProgress((TradeLicense)this.license(), this.workFlowAction);
        this.processWorkflow("new");
        this.tradeLicenseService.updateTradeLicense((TradeLicense)this.license(), this.workflowBean);
        if ("Generate Certificate".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            return this.redirectToPrintCertificate();
        }
        return "message";
    }

    private String redirectToPrintCertificate() {
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.reportService.createReport(this.tradeLicenseService.prepareReportInputData(this.license())));
        return "report";
    }

    private String digitalSignRedirection() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String cityMunicipalityName = (String)request.getSession().getAttribute("citymunicipalityname");
        String districtName = (String)request.getSession().getAttribute("districtName");
        ReportOutput reportOutput = this.tradeLicenseService.prepareReportInputDataForDig(this.license(), districtName, cityMunicipalityName);
        if (reportOutput != null) {
            String fileName = "SN/" + this.license().getApplicationNumber() + ".pdf";
            ByteArrayInputStream fileStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
            FileStoreMapper fileStore = this.fileStoreService.store((InputStream)fileStream, fileName, "application/pdf", "TL");
            this.license().setDigiSignedCertFileStoreId(fileStore.getFileStoreId());
            this.licenseService().save(this.license());
            this.setFileStoreIds(fileStore.getFileStoreId());
            this.setUlbCode(ApplicationThreadLocals.getCityCode());
        }
        return "digitalSignatureRedirection";
    }

    @SkipValidation
    public String approveRenew() {
        this.processWorkflow("Renew");
        return "message";
    }

    protected void populateWorkflowBean() {
        this.workflowBean.setApproverPositionId(this.approverPositionId);
        this.workflowBean.setApproverComments(this.approverComments);
        this.workflowBean.setWorkFlowAction(this.workFlowAction);
        this.workflowBean.setCurrentState(this.currentState);
        this.workflowBean.setAdditionaRule(this.additionalRule);
    }

    @SkipValidation
    public String beforeRenew() throws IOException {
        return "beforeRenew";
    }

    @SkipValidation
    public String renew() {
        this.populateWorkflowBean();
        this.licenseService().renew(this.license(), this.workflowBean);
        this.addActionMessage(this.getText("license.renew.submission.succesful") + this.license().getLicenseNumber());
        return "acknowledgement_renew";
    }

    @SkipValidation
    public String enterExistingForm() {
        return "new";
    }

    public void prepareEnterExistingForm() {
        this.prepareNewForm();
    }

    public void initiateWorkFlowForLicense() {
        Position position = this.positionMasterService.getCurrentPositionForUser(ApplicationThreadLocals.getUserId());
        if (position != null) {
            this.addActionMessage(this.getText("license.saved.in.inbox"));
        }
    }

    public List<String> getBuildingTypeList() {
        return this.buildingTypeList;
    }

    public void setBuildingTypeList(List<String> buildingTypeList) {
        this.buildingTypeList = buildingTypeList;
    }

    public StateAware getModel() {
        return this.license();
    }

    @SkipValidation
    public String newForm() {
        return "new";
    }

    public void prepareCreate() {
        this.prepareNewForm();
    }

    public void prepareNewForm() {
        this.prepare();
        this.buildingTypeList = new ArrayList();
        this.buildingTypeList.add("Own Building");
        this.buildingTypeList.add("Rental");
        this.addDropdownData("areaListLicense", Collections.emptyList());
        this.addDropdownData("areaListLicense", Collections.emptyList());
        this.addDropdownData("divisionListLicense", Collections.emptyList());
        this.addDropdownData("divisionListLicensee", Collections.emptyList());
        if (this.getModel().getClass().getSimpleName().equalsIgnoreCase("electricalcontractorlicense")) {
            this.addDropdownData("tradeNameList", Collections.emptyList());
        } else {
            this.addDropdownData("tradeNameList", this.licenseUtils.getAllTradeNames(this.getModel().getClass().getSimpleName()));
        }
        this.setupWorkflowDetails();
        this.feeTypeId = this.feeTypeService.findByName("License Fee").getId();
    }

    public void prepareShowForApproval() {
        this.prepareNewForm();
    }

    public void processWorkflow(String processType) {
        this.populateWorkflowBean();
        if (processType.equalsIgnoreCase("new") && !"Submit".equals(this.workFlowAction)) {
            this.licenseService().transitionWorkFlow(this.license(), this.workflowBean);
        }
        User user = null;
        Long createrPosition = null;
        for (StateHistory state : this.license().getState().getHistory()) {
            if (state == null || state.getCreatedBy() == null || !state.getValue().contains("NEW")) continue;
            user = state.getCreatedBy();
            createrPosition = state.getOwnerPosition().getId();
            break;
        }
        if (user == null) {
            user = this.license().getCreatedBy();
        }
        if (createrPosition == null) {
            createrPosition = this.license().getState().getOwnerPosition().getId();
        }
        String nextDesgn = "";
        Assignment assignObj = this.assignmentService.getPrimaryAssignmentForPositon(this.workflowBean.getApproverPositionId());
        if (assignObj != null) {
            nextDesgn = assignObj.getDesignation().getName();
        }
        if (this.workflowBean.getWorkFlowAction().equalsIgnoreCase("Approve")) {
            this.addActionMessage(this.getText("license.approved.success"));
        } else if (this.workflowBean.getWorkFlowAction().equalsIgnoreCase("Forward")) {
            String userName = this.assignmentService.getPrimaryAssignmentForPositon(this.workflowBean.getApproverPositionId()).getEmployee().getName();
            this.addActionMessage(this.getText("license.sent") + " " + nextDesgn + " - " + userName);
        } else if (this.workflowBean.getWorkFlowAction().equalsIgnoreCase("Reject")) {
            String creatorDesgn = this.assignmentService.getPrimaryAssignmentForPositon(createrPosition).getDesignation().getName();
            if (this.license().getState().getValue().contains("Rejected")) {
                this.addActionMessage(this.getText("license.rejectedfirst") + (creatorDesgn != null ? creatorDesgn + " - " : "") + " " + user.getName());
            } else {
                this.addActionMessage(this.getText("license.rejected") + this.license().getApplicationNumber());
            }
        } else if (this.workflowBean.getWorkFlowAction().equalsIgnoreCase("GeneratedCertificate")) {
            this.addActionMessage(this.getText("license.certifiacte.print.complete.recorded"));
        } else if (this.workflowBean.getWorkFlowAction().equalsIgnoreCase("PrintCompleted")) {
            this.addActionMessage(this.getText("license.rejection.certifiacte.print.complete.recorded"));
        }
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @SkipValidation
    public String showForApproval() throws IOException {
        this.getSession().put("model.id", this.license().getId());
        String result = "approve";
        this.setRoleName(this.securityUtils.getCurrentUser().getRoles().toString());
        if (this.license().getLicenseAppType().getName().equals("New")) {
            result = this.license().getState().getValue().contains("Generate Certificate") ? "tl_generateCertificate" : (this.license().getState().getValue().contains("Rejected") ? "approve" : (this.license().getState().getValue().contains("Generate Rejection Certificate") ? "tl_generateRejCertificate" : (this.license().getState().getValue().contains("Generate NOC") ? "tl_generateNoc" : "approve")));
        } else if (this.license().getState().getValue().contains("Renew License:")) {
            result = this.license().getState().getValue().contains("Generate Certificate") ? "tl_generateCertificate" : (this.license().getState().getValue().contains("Rejected") ? "approveRenew" : (this.license().getState().getValue().contains("Generate Rejection Certificate") ? "tl_generateRejCertificate" : "approveRenew"));
        } else if (this.license().getState().getValue().contains("Transfer License:")) {
            result = this.license().getState().getValue().contains("Generate Certificate") ? "tl_generateCertificate" : (this.license().getState().getValue().contains("Rejected") ? "transfertl_editlicense" : "transfertl_approve");
        }
        return result;
    }

    public void loadAjaxedDropDowns() {
        CommonAjaxAction commonAjaxAction = new CommonAjaxAction();
        commonAjaxAction.setLicenseUtils(this.licenseUtils);
        commonAjaxAction.setBoundaryService(this.boundaryService);
        commonAjaxAction.setEisCommonService(this.eisCommonService);
        commonAjaxAction.setDesignationService(this.designationService);
        if (this.workflowBean.getDepartmentId() != null) {
            commonAjaxAction.setDepartmentId(this.workflowBean.getDepartmentId());
            commonAjaxAction.ajaxPopulateDesignationsByDept();
            this.workflowBean.setDesignationList(commonAjaxAction.getDesignationList());
        }
        if (this.workflowBean.getDesignationId() != null) {
            commonAjaxAction.setDesignationId(this.workflowBean.getDesignationId());
            commonAjaxAction.ajaxPopulateUsersByDesignation();
            this.workflowBean.setAppoverUserList(commonAjaxAction.getAllActiveUsersByGivenDesg());
        }
    }

    public void setupWorkflowDetails() {
        this.workflowBean.setDepartmentList(this.licenseUtils.getAllDepartments());
        this.workflowBean.setDesignationList(Collections.emptyList());
        this.workflowBean.setAppoverUserList(Collections.emptyList());
    }

    public LicenseDemand getCurrentYearDemand() {
        return this.license().getLicenseDemand();
    }

    public String getPayableAmountInWords() {
        return NumberToWord.amountInWords((Double)this.license().getTotalBalance().doubleValue());
    }

    public String getCollectedDemandAmountInWords() {
        return NumberToWord.amountInWords((Double)this.license().getLicenseDemand().getAmtCollected().doubleValue());
    }

    public boolean isCurrent(EgDemandDetails dd) {
        boolean isCurrent = false;
        Installment currInstallment = this.licenseUtils.getCurrInstallment(dd.getEgDemandReason().getEgDemandReasonMaster().getEgModule());
        if (currInstallment.getId().intValue() == dd.getEgDemandReason().getEgInstallmentMaster().getId().intValue()) {
            isCurrent = true;
        }
        return isCurrent;
    }

    public Map<String, Map<String, BigDecimal>> getOutstandingFee() {
        return this.licenseService().getOutstandingFee(this.license());
    }

    public boolean isCitizen() {
        return this.securityUtils.currentUserType().equals((Object)UserType.CITIZEN);
    }

    public String getReportId() {
        return this.reportId;
    }

    public Long getFeeTypeId() {
        return this.feeTypeId;
    }

    public void setFeeTypeId(Long feeTypeId) {
        this.feeTypeId = feeTypeId;
    }

    public boolean isShowAgreementDtl() {
        return this.showAgreementDtl;
    }

    public void setShowAgreementDtl(boolean showAgreementDtl) {
        this.showAgreementDtl = showAgreementDtl;
    }

    public String getFileStoreIds() {
        return this.fileStoreIds;
    }

    public void setFileStoreIds(String fileStoreIds) {
        this.fileStoreIds = fileStoreIds;
    }

    public String getUlbCode() {
        return this.ulbCode;
    }

    public void setUlbCode(String ulbCode) {
        this.ulbCode = ulbCode;
    }

    public String getSignedFileStoreId() {
        return this.signedFileStoreId;
    }

    public void setSignedFileStoreId(String signedFileStoreId) {
        this.signedFileStoreId = signedFileStoreId;
    }

    public TradeLicenseSmsAndEmailService getTradeLicenseSmsAndEmailService() {
        return this.tradeLicenseSmsAndEmailService;
    }

    public void setTradeLicenseSmsAndEmailService(TradeLicenseSmsAndEmailService tradeLicenseSmsAndEmailService) {
        this.tradeLicenseSmsAndEmailService = tradeLicenseSmsAndEmailService;
    }
}

