/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infstr.services.PersistenceService;
import org.egov.tl.entity.FeeMatrix;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.service.FeeMatrixDetailService;
import org.egov.tl.service.FeeMatrixService;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.egov.tl.web.adaptor.FeeMatrixAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/feematrix/"})
public class FeeMatrixController {
    private static final String FEEMATRIX_NEW = "feematrix-new";
    private static final String FEEMATRIX_RESULT = "feematrix-result";
    private static final String FEEMATRIX_EDIT = "feematrix-edit";
    private static final String FEEMATRIX_VIEW = "feematrix-view";
    @Autowired
    private FeeMatrixService feeMatrixService;
    @Autowired
    private FeeMatrixDetailService feeMatrixDetailService;
    @Autowired
    @Qualifier(value="persistenceService")
    public PersistenceService persistenceService;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private AppConfigValueService appConfigValueService;
    @Autowired
    private LicenseCategoryService licenseCategoryService;

    private void prepareForNewForm(Model model, String fee) {
        List newRenewAppconfigList;
        new ArrayList();
        new ArrayList();
        model.addAttribute("licenseCategorys", (Object)this.licenseCategoryService.findAllOrderByName());
        model.addAttribute("natureOfBusinesss", (Object)this.persistenceService.findAllBy("select n from org.egov.tl.entity.NatureOfBusiness n order by name asc", new Object[0]));
        model.addAttribute("financialYears", (Object)this.financialYearDAO.getAllActiveFinancialYearList());
        List permTempAppconfigList = this.appConfigValueService.getConfigValuesByModuleAndKey("Trade License", "Is Fee For Permanent and Temporary Same");
        if (((AppConfigValues)permTempAppconfigList.get(0)).getValue().equals("Y")) {
            model.addAttribute("hideTemporary", (Object)true);
        }
        if (((AppConfigValues)(newRenewAppconfigList = this.appConfigValueService.getConfigValuesByModuleAndKey("Trade License", "Is Fee For New and Renew Same")).get(0)).getValue().equals("Y")) {
            model.addAttribute("hideRenew", (Object)true);
        }
        model.addAttribute("feeMatrix", (Object)new FeeMatrix());
        model.addAttribute("subCategorys", (Object)Collections.EMPTY_LIST);
        model.addAttribute("feeTypes", (Object)Collections.EMPTY_LIST);
        model.addAttribute("unitOfMeasurements", (Object)Collections.EMPTY_LIST);
        model.addAttribute("licenseAppTypes", (Object)this.persistenceService.findAllBy("select a from LicenseAppType a order by name asc", new Object[0]));
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String newForm(Model model, @RequestParam(required=false) String fee) {
        this.prepareForNewForm(model, fee);
        return FEEMATRIX_NEW;
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute FeeMatrix feeMatrix, BindingResult errors, Model model, HttpServletRequest request) {
        if (errors.hasErrors()) {
            return FEEMATRIX_RESULT;
        }
        this.feeMatrixService.create(feeMatrix);
        model.addAttribute("feeMatrix", (Object)feeMatrix);
        return FEEMATRIX_RESULT;
    }

    @RequestMapping(value={"search"}, method={RequestMethod.GET})
    public String search(@ModelAttribute FeeMatrix feeMatrix, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            return FEEMATRIX_RESULT;
        }
        FeeMatrix searchfeeMatrix = this.feeMatrixService.search(feeMatrix);
        if (searchfeeMatrix == null) {
            searchfeeMatrix = new FeeMatrix();
        }
        model.addAttribute("feeMatrix", (Object)searchfeeMatrix);
        return FEEMATRIX_RESULT;
    }

    @RequestMapping(value={"edit/{id}"}, method={RequestMethod.POST})
    public String edit(@PathVariable(value="id") String id) {
        return FEEMATRIX_EDIT;
    }

    @RequestMapping(value={"update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute FeeMatrix feeMatrix, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            return FEEMATRIX_RESULT;
        }
        this.feeMatrixService.update(feeMatrix);
        return FEEMATRIX_RESULT;
    }

    @RequestMapping(value={"view/{id}"}, method={RequestMethod.POST})
    public String view(@PathVariable(value="id") String id) {
        return FEEMATRIX_VIEW;
    }

    @RequestMapping(value={"view-feematrix"}, method={RequestMethod.GET})
    public String viewForm(Model model, @RequestParam(required=false) String fee) {
        model.addAttribute("feeMatrix", (Object)new FeeMatrix());
        model.addAttribute("financialYears", (Object)this.financialYearDAO.getAllActiveFinancialYearList());
        model.addAttribute("licenseCategorys", (Object)this.licenseCategoryService.findAllOrderByName());
        model.addAttribute("subCategorys", (Object)Collections.EMPTY_LIST);
        return FEEMATRIX_VIEW;
    }

    @RequestMapping(value={"viewresult"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String viewresult(@RequestParam(required=false) Long category, @RequestParam(required=false) Long subCategory, @RequestParam(required=false) Long finyear) throws IOException, ParseException {
        List feeMatrixDetails = this.feeMatrixDetailService.searchFeeMatrix(category, subCategory, finyear);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)feeMatrixDetails) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(FeeMatrixDetail.class, (Object)new FeeMatrixAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

