/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.tl.web.controller.DCBReportHelperAdaptor;
import org.egov.tl.web.controller.DCBReportResult;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tlreports"})
public class DCBReportController {
    public static final String PROPERTY = "property";
    @PersistenceContext
    EntityManager entityManager;
    @Autowired
    private BoundaryService boundaryService;
    private final DCBReportResult dCBReportResult = new DCBReportResult();

    @ModelAttribute(value="dCBReportResult")
    public DCBReportResult dCBReportResultModel() {
        return this.dCBReportResult;
    }

    @ModelAttribute(value="zones")
    public List<Boundary> zones() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
    }

    @ModelAttribute(value="wards")
    public List<Boundary> wards() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @ModelAttribute(value="blocks")
    public List<Boundary> blocks() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Block", "REVENUE");
    }

    @ModelAttribute(value="localitys")
    public List<Boundary> localitys() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
    }

    @RequestMapping(value={"/dCBReport/zoneWise"}, method={RequestMethod.GET})
    public String zoneWisesearch(Model model) {
        model.addAttribute("mode", (Object)"zone");
        model.addAttribute("reportType", (Object)"zoneWise");
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReport/wardWise"}, method={RequestMethod.GET})
    public String wardWisesearch(Model model) {
        model.addAttribute("mode", (Object)"ward");
        model.addAttribute("reportType", (Object)"wardWise");
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReport/blockWise"}, method={RequestMethod.GET})
    public String blockWisesearch(Model model) {
        model.addAttribute("mode", (Object)"block");
        model.addAttribute("reportType", (Object)"blockWise");
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReport/localityWise"}, method={RequestMethod.GET})
    public String localityWisesearch(Model model) {
        model.addAttribute("mode", (Object)"locality");
        model.addAttribute("reportType", (Object)"locality");
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReport/licenseNumberWise"}, method={RequestMethod.GET})
    public String licenseNumberWisesearch(Model model) {
        model.addAttribute("mode", (Object)PROPERTY);
        model.addAttribute("reportType", (Object)PROPERTY);
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReportList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void search(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
        List resultList = new ArrayList();
        String licensenumber = "";
        String mode = "";
        String reportType = "";
        String[] boundaryId = null;
        StringBuilder zones = new StringBuilder();
        if (request.getParameter("boundaryId[]") != null && !"".equals(request.getParameter("boundaryId[]"))) {
            boundaryId = request.getParameterValues("boundaryId[]");
        } else if (request.getParameter("boundaryId") != null && !"".equals(request.getParameter("boundaryId"))) {
            boundaryId = request.getParameterValues("boundaryId");
        }
        if (boundaryId != null) {
            for (String n : boundaryId) {
                if (zones.length() > 0) {
                    zones.append(',');
                }
                zones.append(n);
            }
        }
        if (request.getParameter("mode") != null && !"".equals(request.getParameter("mode"))) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("reportType") != null && !"".equals(request.getParameter("reportType"))) {
            reportType = request.getParameter("reportType");
        }
        if (request.getParameter("licensenumber") != null && !"".equals(request.getParameter("licensenumber"))) {
            licensenumber = request.getParameter("licensenumber");
        }
        SQLQuery query = this.prepareQuery(zones.toString(), licensenumber, mode, reportType);
        resultList = query.list();
        String result = null;
        result = "{ \"data\":" + this.toJSON(resultList) + "}";
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    private SQLQuery prepareQuery(String paramList, String licensenumber, String mode, String reportType) {
        StringBuilder query = new StringBuilder();
        StringBuilder selectQry1 = new StringBuilder();
        StringBuilder selectQry2 = new StringBuilder();
        StringBuilder fromQry = new StringBuilder();
        StringBuilder whereQry = new StringBuilder();
        StringBuilder groupByQry = new StringBuilder();
        selectQry2.append("  cast(SUM(arr_demand) as bigint) AS arr_demand,cast(SUM(curr_demand) as bigint) AS curr_demand,cast(SUM(arr_coll) as bigint) AS arr_coll,cast(SUM(curr_coll) as bigint) AS curr_coll,cast(SUM(arr_balance) as bigint) AS arr_balance,cast(SUM(curr_balance) as bigint) AS curr_balance ");
        fromQry = new StringBuilder(" from egtl_mv_dcb_view dcbinfo,eg_boundary boundary ");
        if (mode.equalsIgnoreCase(PROPERTY)) {
            selectQry1.append("select distinct dcbinfo.licenseNumber as licenseNumber ,cast(dcbinfo.licenseId as integer) as licenseid,dcbinfo.username as \"username\", ");
            fromQry = new StringBuilder(" from egtl_mv_dcb_view dcbinfo ");
            if (licensenumber != null && !"".equals(licensenumber)) {
                whereQry = whereQry.append(" where  dcbinfo.licenseNumber = '" + licensenumber.toUpperCase() + "'");
            }
            groupByQry.append("group by dcbinfo.licenseNumber,dcbinfo.licenseId,dcbinfo.username ");
            if (licensenumber != null && !"".equals(licensenumber)) {
                whereQry.append(" and ");
            } else {
                whereQry.append(" where ");
            }
            whereQry.append(" dcbinfo.licenseNumber is not null  ");
            if (paramList != null && !paramList.equalsIgnoreCase("") && reportType.equalsIgnoreCase("localityWise")) {
                whereQry = whereQry.append(" and dcbinfo.locality in (" + paramList + ")");
            }
        }
        query = selectQry1.append((CharSequence)selectQry2).append((CharSequence)fromQry).append((CharSequence)whereQry).append((CharSequence)groupByQry);
        SQLQuery finalQuery = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(query.toString());
        finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DCBReportResult.class));
        return finalQuery;
    }

    private Object toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(DCBReportResult.class, (Object)new DCBReportHelperAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

