/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.newtradelicense;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.Licensee;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.utils.Constants;
import org.egov.tl.web.actions.BaseLicenseAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name="new", location="newTradeLicense-new.jsp"), @Result(name="acknowledgement", location="newTradeLicense-acknowledgement.jsp"), @Result(name="message", location="newTradeLicense-message.jsp"), @Result(name="beforeRenew", location="newTradeLicense-beforeRenew.jsp"), @Result(name="acknowledgement_renew", location="newTradeLicense-acknowledgement_renew.jsp")})
public class NewTradeLicenseAction
extends BaseLicenseAction<TradeLicense> {
    private static final long serialVersionUID = 1L;
    private TradeLicense tradeLicense = new TradeLicense();
    private List<LicenseDocumentType> documentTypes = new ArrayList();
    private Map<String, String> ownerShipTypeMap;
    private String mode;
    private String message;
    private String renewAppType;
    @Autowired
    @Qualifier(value="tradeLicenseService")
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private PositionMasterService positionMasterService;

    public NewTradeLicenseAction() {
        this.tradeLicense.setLicensee(new Licensee());
    }

    @SkipValidation
    @Action(value="/newtradelicense/newTradeLicense-newForm")
    public String newForm() {
        this.tradeLicense.setApplicationDate(new Date());
        return super.newForm();
    }

    @ValidationErrorPage(value="new")
    @Action(value="/newtradelicense/newTradeLicense-create")
    public String create() {
        return super.create((License)this.tradeLicense);
    }

    @Action(value="/newtradelicense/newTradeLicense-showForApproval")
    @SkipValidation
    public String showForApproval() throws IOException {
        if (this.license().getStatus().getName().equals("Acknowledged") || this.license().getStatus().getName().equals("UnderWorkflow")) {
            this.mode = "view";
        }
        if (this.license().getState().getValue().contains("Rejected")) {
            this.mode = "editForReject";
        }
        if (this.license().getState().getValue().contains("Sanitary inspector Approve pending")) {
            this.mode = "editForApproval";
        }
        if (this.license().getState().getValue().contains("Collection Done") || this.license().getState().getValue().contains("Sanitary inspector Approved") || this.license().getState().getValue().contains("Commissioner Approved")) {
            this.mode = "disableApprover";
        }
        if (this.license().getState().getValue().contains("Commissioner Approved")) {
            this.message = "Pending for Collection";
        }
        if (!this.license().getState().getOwnerPosition().equals((Object)this.positionMasterService.getPositionByUserId(this.securityUtils.getCurrentUser().getId()))) {
            ServletActionContext.getResponse().setContentType("text/html");
            ServletActionContext.getResponse().getWriter().write("<center style='color:red;font-weight:bolder'>Workflow item is in " + this.license().getCurrentState().getOwnerPosition().getName() + " inbox !</center>");
            return null;
        }
        return super.showForApproval();
    }

    @ValidationErrorPage(value="new")
    @Action(value="/newtradelicense/newTradeLicense-approve")
    public String approve() {
        BigDecimal newTradeAreWt = this.tradeLicense.getTradeArea_weight();
        this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById((Long)this.getSession().get("model.id"));
        if (null != this.license().getState() && this.license().getState().getValue().contains("Sanitary inspector Approve pending")) {
            this.tradeLicense.setTradeArea_weight(newTradeAreWt);
        }
        if ("Submit".equals(this.workFlowAction) && this.mode.equalsIgnoreCase("view") && this.tradeLicense.getState().getValue().contains("Commissioner Approved") && this.tradeLicense != null && !this.tradeLicense.isPaid() && !this.workFlowAction.equalsIgnoreCase("Reject")) {
            this.prepareNewForm();
            ValidationError vr = new ValidationError("license.fee.notcollected", "license.fee.notcollected");
            throw new ValidationException(Arrays.asList(vr));
        }
        return super.approve();
    }

    @SkipValidation
    @Action(value="/newtradelicense/newTradeLicense-beforeRenew")
    public String beforeRenew() throws IOException {
        this.prepareNewForm();
        if (this.tradeLicense.getEgwStatus() != null && !this.tradeLicense.getEgwStatus().getCode().equalsIgnoreCase("COLLECTIONPENDING") && this.tradeLicense.getLicenseAppType() != null && this.tradeLicense.getLicenseAppType().getName().equals("Renew")) {
            ServletActionContext.getResponse().setContentType("text/html");
            ServletActionContext.getResponse().getWriter().write("<center style='color:red;font-weight:bolder'>Renewal workflow is in progress !</center>");
            return null;
        }
        if (!this.tradeLicense.hasState() || this.tradeLicense.getCurrentState().getValue().equals("Closed")) {
            this.currentState = "";
        }
        this.renewAppType = "Renew";
        return super.beforeRenew();
    }

    @ValidationErrorPage(value="beforeRenew")
    @Action(value="/newtradelicense/newTradeLicense-renewal")
    public String renew() {
        return super.renew();
    }

    public void prepareRenew() {
        this.prepareNewForm();
    }

    public void prepareNewForm() {
        super.prepareNewForm();
        if (this.license() != null && this.license().getId() != null) {
            this.tradeLicense = (TradeLicense)this.tradeLicenseService.getLicenseById(this.license().getId());
        }
        this.setDocumentTypes(this.tradeLicenseService.getDocumentTypesByTransaction("Create License"));
        this.setOwnerShipTypeMap(Constants.OWNERSHIP_TYPE);
        List localityList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
        this.addDropdownData("localityList", localityList);
        this.addDropdownData("tradeTypeList", this.tradeLicenseService.getAllNatureOfBusinesses());
        this.addDropdownData("categoryList", this.licenseCategoryService.findAll());
        this.addDropdownData("uomList", this.unitOfMeasurementService.findAllActiveUOM());
        this.addDropdownData("subCategoryList", this.tradeLicense.getCategory() == null ? Collections.emptyList() : this.licenseSubCategoryService.findAllSubCategoryByCategory(this.tradeLicense.getCategory().getId()));
        if (this.license() != null && this.license().getAgreementDate() != null) {
            this.setShowAgreementDtl(true);
        }
    }

    public License getModel() {
        return this.tradeLicense;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    protected TradeLicense license() {
        return this.tradeLicense;
    }

    protected AbstractLicenseService<TradeLicense> licenseService() {
        return this.tradeLicenseService;
    }

    public List<LicenseDocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public void setDocumentTypes(List<LicenseDocumentType> documentTypes) {
        this.documentTypes = documentTypes;
    }

    public Map<String, String> getOwnerShipTypeMap() {
        return this.ownerShipTypeMap;
    }

    public void setOwnerShipTypeMap(Map<String, String> ownerShipTypeMap) {
        this.ownerShipTypeMap = ownerShipTypeMap;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getAdditionalRule() {
        if (this.renewAppType != null && this.renewAppType.equals("Renew") || this.tradeLicense != null && this.tradeLicense.getLicenseAppType() != null && this.tradeLicense.getLicenseAppType().getName().equals("Renew")) {
            return "RENEWALTRADE";
        }
        return "NEWTRADE";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

