/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.masters;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/*
 * Exception performing whole class analysis ignored.
 */
@ParentPackage(value="egov")
@Results(value={@Result(name="new", location="licenseCategory-new.jsp"), @Result(name="search", location="licenseCategory-search.jsp"), @Result(name="edit", location="licenseCategory-edit.jsp")})
public class LicenseCategoryAction
extends BaseFormAction {
    private static final long serialVersionUID = 6242612156153747913L;
    private LicenseCategory licenseCategory = new LicenseCategory();
    private Long id;
    public static final String SEARCH = "search";
    public static final String VIEW = "view";
    private Map<Long, String> licenseCategoryMap;
    @Autowired
    @Qualifier(value="licenseCategoryService")
    private LicenseCategoryService licenseCategoryService;
    private static final Logger LOGGER = Logger.getLogger(LicenseCategoryAction.class);
    private String userMode;

    public Object getModel() {
        return this.licenseCategory;
    }

    public void prepare() {
        if (this.userMode != null && !this.userMode.isEmpty() && (this.userMode.equalsIgnoreCase("edit") || this.userMode.equalsIgnoreCase("view"))) {
            this.setLicenseCategoryMap(LicenseCategoryAction.getFormattedCategoryMap((List)this.licenseCategoryService.findAll()));
        }
        if (this.getId() != null) {
            this.licenseCategory = this.licenseCategoryService.findById(this.getId());
        }
    }

    public static Map<Long, String> getFormattedCategoryMap(List<LicenseCategory> licenseCategoryList) {
        TreeMap<Long, String> categoryMap = new TreeMap<Long, String>();
        for (LicenseCategory licenseCategory : licenseCategoryList) {
            categoryMap.put(licenseCategory.getId(), licenseCategory.getName().concat(" ~ ").concat(licenseCategory.getCode()));
        }
        return categoryMap;
    }

    @Action(value="/masters/licenseCategory-newform")
    public String newform() {
        if (this.userMode != null && !this.userMode.isEmpty()) {
            if (this.userMode.equalsIgnoreCase("view")) {
                this.userMode = "view";
            } else if (this.userMode.equalsIgnoreCase("edit")) {
                this.userMode = "edit";
            }
        } else {
            this.userMode = "new";
        }
        return "new";
    }

    @Action(value="/masters/licenseCategory-edit")
    public String edit() {
        if (this.userMode.equalsIgnoreCase("edit")) {
            this.userMode = "edit";
        } else if (this.userMode.equalsIgnoreCase("view")) {
            this.userMode = "view";
        }
        return "search";
    }

    @ValidationErrorPage(value="edit")
    @Action(value="/masters/licenseCategory-save")
    public String save() throws NumberFormatException, ApplicationException {
        try {
            this.licenseCategory = this.licenseCategoryService.create(this.licenseCategory);
        }
        catch (ValidationException valEx) {
            LOGGER.error((Object)("Exception found while persisting License category: " + valEx.getErrors()));
            throw new ValidationException(valEx.getErrors());
        }
        if (this.userMode.equalsIgnoreCase("new")) {
            this.addActionMessage("'" + this.licenseCategory.getCode() + "' " + this.getText("license.category.save.success"));
        } else if (this.userMode.equalsIgnoreCase("edit")) {
            this.addActionMessage("'" + this.licenseCategory.getCode() + "' " + this.getText("license.category.edit.success"));
        }
        this.userMode = "success";
        return "new";
    }

    public LicenseCategory getLicenseCategory() {
        return this.licenseCategory;
    }

    public void setLicenseCategory(LicenseCategory licenseCategory) {
        this.licenseCategory = licenseCategory;
    }

    public String getUserMode() {
        return this.userMode;
    }

    public void setUserMode(String userMode) {
        this.userMode = userMode;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Map<Long, String> getLicenseCategoryMap() {
        return this.licenseCategoryMap;
    }

    public void setLicenseCategoryMap(Map<Long, String> licenseCategoryMap) {
        this.licenseCategoryMap = licenseCategoryMap;
    }
}

