/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.integration;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.interfaces.Billable;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.tl.entity.License;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.service.integration.LicenseBill;
import org.egov.tl.service.integration.LicenseBillService;
import org.egov.tl.utils.LicenseNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
public class LicenseBillCollectAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private Long licenseId;
    private LicenseBill licenseBill;
    private String collectXML;
    @Autowired
    private LicenseBillService licenseBillService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private LicenseNumberGenerator licenseNumberGenerator;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    @Qualifier(value="tradeLicenseService")
    private TradeLicenseService tradeLicenseService;

    public String execute() throws IOException {
        License license = (License)this.tradeLicenseService.licensePersitenceService().findById((Serializable)this.licenseId, false);
        if (license.isPaid()) {
            ServletActionContext.getResponse().setContentType("text/html");
            ServletActionContext.getResponse().getWriter().write("<center style='color:red;font-weight:bolder'>License Fee already collected !</center>");
            return null;
        }
        SimpleDateFormat formatYear = new SimpleDateFormat("yyyy");
        String currentInstallmentYear = formatYear.format(this.installmentDao.getInsatllmentByModuleForGivenDate(this.moduleService.getModuleByName("Trade License"), new Date()).getInstallmentYear());
        this.licenseBill.setLicense(license);
        this.licenseBill.setReferenceNumber(this.licenseNumberGenerator.generateBillNumber(currentInstallmentYear));
        this.licenseBillService.setLicense(license);
        this.collectXML = URLEncoder.encode(this.licenseBillService.getBillXML((Billable)this.licenseBill), "UTF-8");
        return "success";
    }

    public String renew() throws IOException {
        if (this.getSession().get("model.id") != null) {
            this.licenseId = (long)((Long)this.getSession().get("model.id"));
            this.getSession().remove("model.id");
        }
        License license = (License)this.tradeLicenseService.licensePersitenceService().findById((Serializable)this.licenseId, false);
        this.licenseBill.setLicense(license);
        this.licenseBillService.setLicense(license);
        this.collectXML = URLEncoder.encode(this.licenseBillService.getBillXML((Billable)this.licenseBill), "UTF-8");
        return "success";
    }

    public Object getModel() {
        return null;
    }

    public String getCollectXML() {
        return this.collectXML;
    }

    public Long getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(Long licenseId) {
        this.licenseId = licenseId;
    }

    public void setLicenseBill(LicenseBill licenseBill) {
        this.licenseBill = licenseBill;
    }
}

