/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service.es;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.egov.commons.entity.Source;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.entity.enums.ApprovalStatus;
import org.egov.infra.elasticsearch.entity.enums.ClosureStatus;
import org.egov.infra.elasticsearch.service.ApplicationIndexService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.License;
import org.egov.tl.utils.LicenseUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseApplicationIndexService {
    private static final String APPLICATION_VIEW_URL = "/tl/viewtradelicense/viewTradeLicense-view.action?applicationNo=%s";
    @Autowired
    private ApplicationIndexService applicationIndexService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private LicenseUtils licenseUtils;

    public void createOrUpdateLicenseApplicationIndex(License license) {
        ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(license.getApplicationNumber());
        if (applicationIndex != null) {
            this.updateLicenseApplicationIndex(license, applicationIndex);
        } else {
            this.createLicenseApplicationIndex(license);
        }
    }

    private void createLicenseApplicationIndex(License license) {
        Optional<User> user = this.getApplicationCurrentOwner(license);
        if (license.getApplicationDate() == null) {
            license.setApplicationDate(new Date());
        }
        Integer slaConfig = this.licenseUtils.getSlaForAppType(license.getLicenseAppType());
        this.applicationIndexService.createApplicationIndex(ApplicationIndex.builder().withModuleName("Trade License").withApplicationNumber(license.getApplicationNumber()).withApplicationDate(license.getApplicationDate()).withApplicationType(license.getLicenseAppType().getName()).withApplicantName(license.getLicensee().getApplicantName()).withStatus(license.getEgwStatus() != null ? license.getEgwStatus().getDescription() : license.getCurrentState().getValue()).withUrl(String.format(APPLICATION_VIEW_URL, license.getApplicationNumber())).withApplicantAddress(license.getAddress()).withOwnername(user.isPresent() ? user.get().getUsername() + "::" + user.get().getName() : "N/A").withChannel(this.getChannel()).withMobileNumber(license.getLicensee().getMobilePhoneNumber()).withAadharNumber(license.getLicensee().getUid()).withClosed(ClosureStatus.NO).withApproved(ApprovalStatus.INPROGRESS).withSla(Integer.valueOf(slaConfig != null ? slaConfig : 0)).build());
    }

    private String getChannel() {
        return this.securityUtils.currentUserIsEmployee() ? Source.SYSTEM.toString() : (this.securityUtils.getCurrentUser().hasRole("CSC Operator") ? Source.CSC.toString() : "ONLINE");
    }

    private void updateLicenseApplicationIndex(License license, ApplicationIndex applicationIndex) {
        Optional<User> user = this.getApplicationCurrentOwner(license);
        applicationIndex.setStatus(license.getEgwStatus() != null ? license.getEgwStatus().getDescription() : license.getCurrentState().getValue());
        applicationIndex.setApplicantAddress(license.getAddress());
        applicationIndex.setOwnerName(user.isPresent() ? user.get().getUsername() + "::" + user.get().getName() : "");
        applicationIndex.setConsumerCode(license.getLicenseNumber());
        applicationIndex.setClosed(ClosureStatus.NO);
        applicationIndex.setApproved(ApprovalStatus.INPROGRESS);
        if (license.getIsActive() || license.getEgwStatus() != null && license.getEgwStatus().getCode().equals("CERTIFICATEGENERATED")) {
            applicationIndex.setClosed(ClosureStatus.YES);
            applicationIndex.setApproved(ApprovalStatus.APPROVED);
        }
        if (license.getStatus().getStatusCode().equals("CAN")) {
            applicationIndex.setApproved(ApprovalStatus.REJECTED);
            applicationIndex.setClosed(ClosureStatus.YES);
        }
        this.applicationIndexService.updateApplicationIndex(applicationIndex);
    }

    private Optional<User> getApplicationCurrentOwner(License license) {
        User user = null;
        if (license.hasState() && license.getState().getOwnerPosition() != null) {
            Assignment assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(((Position)license.getState().getOwnerPosition()).getId(), new Date());
            if (assignment == null) {
                List assignments = this.assignmentService.getAssignmentsForPosition(((Position)license.getState().getOwnerPosition()).getId(), new Date());
                if (!assignments.isEmpty()) {
                    user = ((Assignment)assignments.get(0)).getEmployee();
                }
            } else {
                user = assignment.getEmployee();
            }
        } else {
            user = this.securityUtils.getCurrentUser();
        }
        return Optional.ofNullable(user);
    }
}

