/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.tl.entity.License;
import org.egov.tl.entity.Validity;
import org.egov.tl.repository.ValidityRepository;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ValidityService {
    @Autowired
    private ValidityRepository validityRepository;

    @Transactional
    public Validity create(Validity validity) {
        return (Validity)((Object)this.validityRepository.save((Object)validity));
    }

    @Transactional
    public Validity update(Validity validity) {
        return (Validity)((Object)this.validityRepository.save((Object)validity));
    }

    public List<Validity> findAll() {
        return this.validityRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Validity findOne(Long id) {
        return (Validity)((Object)this.validityRepository.findOne(id));
    }

    @ReadOnly
    public List<Validity> search(Long natureOfBusiness, Long licenseCategory) {
        if (natureOfBusiness != null && licenseCategory != null) {
            Validity validity = this.validityRepository.findByNatureOfBusinessIdAndLicenseCategoryId(natureOfBusiness, licenseCategory);
            return validity != null ? Arrays.asList(validity) : Collections.emptyList();
        }
        if (natureOfBusiness != null) {
            return this.validityRepository.findByNatureOfBusinessId(natureOfBusiness);
        }
        if (licenseCategory != null) {
            return this.validityRepository.findByLicenseCategoryId(licenseCategory);
        }
        return this.validityRepository.findAll();
    }

    public Validity getApplicableLicenseValidity(License license) {
        return Optional.ofNullable(this.validityRepository.findByNatureOfBusinessIdAndLicenseCategoryId(license.getNatureOfBusiness().getId(), license.getCategory().getId())).orElse(this.validityRepository.findByNatureOfBusinessIdAndLicenseCategoryIsNull(license.getNatureOfBusiness().getId()));
    }

    public void applyLicenseValidity(License license) {
        Validity validity = this.getApplicableLicenseValidity(license);
        if (validity == null) {
            throw new ValidationException("TL-010", "License validity not defined.", new String[0]);
        }
        if (license.isLegacy()) {
            this.applyValidityToLegacyLicense(license, validity);
        } else {
            this.applyValidityToLicense(license, validity);
        }
    }

    private void applyValidityToLicense(License license, Validity validity) {
        if (validity.isBasedOnFinancialYear()) {
            license.setDateOfExpiry(license.getCurrentDemand().getEgInstallmentMaster().getToDate());
        } else {
            this.applyLicenseValidityBasedOnCustomValidity(license, validity);
        }
    }

    private void applyValidityToLegacyLicense(License license, Validity validity) {
        license.getCurrentDemand().getEgDemandDetails().stream().filter(demandDetail -> demandDetail.getAmount().subtract(demandDetail.getAmtCollected()).doubleValue() <= 0.0).max(Comparator.comparing(EgDemandDetails::getInstallmentEndDate)).ifPresent(demandDetail -> {
            if (validity.isBasedOnFinancialYear()) {
                license.setDateOfExpiry(demandDetail.getInstallmentEndDate());
            } else {
                this.applyLicenseValidityBasedOnCustomValidity(license, validity);
            }
        });
    }

    private void applyLicenseValidityBasedOnCustomValidity(License license, Validity validity) {
        LocalDate nextExpiryDate = new LocalDate((Object)(license.isNewApplication() ? license.getCommencementDate() : license.getCurrentDemand().getEgInstallmentMaster().getFromDate()));
        if (validity.getYear() != null && validity.getYear() > 0) {
            nextExpiryDate = nextExpiryDate.plusYears(validity.getYear().intValue());
        }
        if (validity.getMonth() != null && validity.getMonth() > 0) {
            nextExpiryDate = nextExpiryDate.plusMonths(validity.getMonth().intValue());
        }
        if (validity.getWeek() != null && validity.getWeek() > 0) {
            nextExpiryDate = nextExpiryDate.plusWeeks(validity.getWeek().intValue());
        }
        if (validity.getDay() != null && validity.getDay() > 0) {
            nextExpiryDate = nextExpiryDate.plusDays(validity.getDay().intValue());
        }
        license.setDateOfExpiry(nextExpiryDate.toDate());
    }
}

