/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.math.BigDecimal;
import java.util.Locale;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.notification.service.NotificationService;
import org.egov.tl.entity.License;
import org.egov.tl.utils.LicenseUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class TradeLicenseSmsAndEmailService {
    private static final String MSG_LICENSE_CREATE_SMS = "msg.%s.license.creator.sms";
    private static final String MSG_LICENSE_CREATE_SUBJECT = "msg.%s.license.create.email.subject";
    private static final String MSG_LICENSE_CREATE_BODY = "msg.%s.license.create.email.body";
    private static final String MSG_LICENSE_APPROVAL_BODY = "msg.%s.licenseapproval.email.body";
    private static final String MSG_LICENSE_APPROVALAMT_BODY = "msg.%s.license.approvalAmt.email.body";
    private static final String MSG_LICENSE_CANCEL_BODY = "msg.%s.license.cancelled.email.body";
    private static final String MSG_LICENSE_FIRSTLEVEL_SMS = "msg.%s.license.firstcollection.sms";
    private static final String MSG_LICENSE_FIRSTLEVEL_SUBJECT = "msg.%s.license.firstcollection.email.subject";
    private static final String MSG_LICENSE_FIRSTLEVEL_BODY = "msg.%s.license.firstcollection.email.body";
    private static final String MSG_LICENSE_SECONDLEVEL_SMS = "msg.%s.license.second.level.sms";
    private static final String MSG_LICENSE_SECONDLEVEL_BODY = "msg.%s.license.second.level.email.body";
    private static final String MSG_LICENSE_DIGI_APPROVAL_BODY = "msg.%s.licenseapproval.digienabled.email.body";
    private static final String MSG_LICENSE_DIGI_APPROVALAMT_BODY = "msg.%s.license.digienabled.approvalAmt.email.body";
    @Autowired
    private NotificationService notificationService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource licenseMessageSource;
    @Autowired
    private LicenseUtils licenseUtils;

    public void sendSMSOnLicense(String mobileNumber, String smsBody) {
        this.notificationService.sendSMS(mobileNumber, smsBody);
    }

    public void sendEmailOnLicense(String email, String emailBody, String emailSubject) {
        this.notificationService.sendEmail(email, emailSubject, emailBody);
    }

    public String getMunicipalityName() {
        return ApplicationThreadLocals.getMunicipalityName();
    }

    public void sendSmsAndEmail(License license, String workFlowAction) {
        String smsMsg = null;
        String emailBody = "";
        String emailSubject = "";
        Locale locale = Locale.getDefault();
        String[] strarr = this.getMunicipalityName().split(" ");
        String cityname = strarr[0];
        if (license.getState().getHistory().isEmpty() && license.isAcknowledged()) {
            smsMsg = this.licenseMessageSource.getMessage(String.format(MSG_LICENSE_CREATE_SMS, license.getLicenseAppType().getName().toLowerCase()), (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), this.getMunicipalityName()}, locale);
            emailBody = this.licenseMessageSource.getMessage(String.format(MSG_LICENSE_CREATE_BODY, license.getLicenseAppType().getName().toLowerCase()), (Object[])new String[]{license.getLicensee().getApplicantName(), license.getNameOfEstablishment(), license.getApplicationNumber(), this.getMunicipalityName()}, locale);
            emailSubject = this.licenseMessageSource.getMessage(String.format(MSG_LICENSE_CREATE_SUBJECT, license.getLicenseAppType().getName().toLowerCase()), (Object[])new String[]{this.getMunicipalityName()}, locale);
        } else if (workFlowAction.equals("Approve") && "UWF".equalsIgnoreCase(license.getStatus().getStatusCode())) {
            BigDecimal demAmt = BigDecimal.ZERO;
            for (EgDemandDetails dmdDtls : license.getCurrentDemand().getEgDemandDetails()) {
                demAmt = demAmt.add(dmdDtls.getAmount().subtract(dmdDtls.getAmtCollected()));
            }
            if (this.licenseUtils.isDigitalSignEnabled().booleanValue() && demAmt.compareTo(BigDecimal.ZERO) == 0) {
                String emailCode = String.format(MSG_LICENSE_DIGI_APPROVAL_BODY, license.getLicenseAppType().getName().toLowerCase());
                emailBody = this.licenseMessageSource.getMessage(emailCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), license.getNameOfEstablishment(), license.getLicenseNumber(), this.getMunicipalityName()}, locale);
                String smsCode = "msg.digi.enabled.newTradeLicenseapproval.sms";
                smsMsg = this.licenseMessageSource.getMessage(smsCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), license.getNameOfEstablishment(), license.getLicenseNumber(), this.getMunicipalityName()}, locale);
            } else if (!this.licenseUtils.isDigitalSignEnabled().booleanValue() && demAmt.compareTo(BigDecimal.ZERO) == 0) {
                String emailCode = String.format(MSG_LICENSE_APPROVAL_BODY, license.getLicenseAppType().getName().toLowerCase());
                emailBody = this.licenseMessageSource.getMessage(emailCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), license.getNameOfEstablishment(), license.getLicenseNumber(), this.getMunicipalityName()}, locale);
                String smsCode = "msg.newTradeLicenseapproval.sms";
                smsMsg = this.licenseMessageSource.getMessage(smsCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), license.getNameOfEstablishment(), license.getLicenseNumber(), this.getMunicipalityName()}, locale);
            } else if (demAmt.compareTo(BigDecimal.ZERO) > 0 && this.licenseUtils.isDigitalSignEnabled().booleanValue()) {
                String emailCode = String.format(MSG_LICENSE_DIGI_APPROVALAMT_BODY, license.getLicenseAppType().getName().toLowerCase());
                emailBody = this.licenseMessageSource.getMessage(emailCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), license.getNameOfEstablishment(), license.getLicenseNumber(), license.getTotalBalance().toString(), ApplicationThreadLocals.getDomainURL(), this.getMunicipalityName()}, locale);
                String smsCode = "msg.digi.enabled.newTradeLicenseapprovalAmt.sms";
                smsMsg = this.licenseMessageSource.getMessage(smsCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), license.getNameOfEstablishment(), license.getLicenseNumber(), license.getTotalBalance().toString(), ApplicationThreadLocals.getDomainURL(), this.getMunicipalityName()}, locale);
            } else if (demAmt.compareTo(BigDecimal.ZERO) > 0 && !this.licenseUtils.isDigitalSignEnabled().booleanValue()) {
                String emailCode = String.format(MSG_LICENSE_APPROVALAMT_BODY, license.getLicenseAppType().getName().toLowerCase());
                emailBody = this.licenseMessageSource.getMessage(emailCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), license.getNameOfEstablishment(), license.getLicenseNumber(), license.getTotalBalance().toString(), ApplicationThreadLocals.getDomainURL(), this.getMunicipalityName()}, locale);
                String smsCode = "msg.newTradeLicenseapprovalAmt.sms";
                smsMsg = this.licenseMessageSource.getMessage(smsCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), license.getNameOfEstablishment(), license.getTotalBalance().toString(), ApplicationThreadLocals.getDomainURL(), this.getMunicipalityName()}, locale);
            }
            emailSubject = this.licenseMessageSource.getMessage("msg.newTradeLicenseApproval.email.subject", (Object[])new String[]{license.getNameOfEstablishment()}, locale);
        } else if ("CAN".equalsIgnoreCase(license.getStatus().getStatusCode())) {
            smsMsg = this.licenseMessageSource.getMessage("msg.newTradeLicensecancelled.sms", (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), cityname, this.getMunicipalityName()}, locale);
            emailBody = this.licenseMessageSource.getMessage(String.format(MSG_LICENSE_CANCEL_BODY, license.getLicenseAppType().getName().toLowerCase()), (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), license.getNameOfEstablishment(), this.getMunicipalityName()}, locale);
            emailSubject = this.licenseMessageSource.getMessage("msg.newTradeLicensecancelled.email.subject", (Object[])new String[]{license.getNameOfEstablishment()}, locale);
        }
        this.sendSMSOnLicense(license.getLicensee().getMobilePhoneNumber(), smsMsg);
        this.sendEmailOnLicense(license.getLicensee().getEmailId(), emailBody, emailSubject);
    }

    public void sendSMsAndEmailOnCollection(License license, BigDecimal demandAmount) {
        String emailBody;
        String emailSubject;
        String smsMsg;
        Locale locale = Locale.getDefault();
        if ("First Level Fee Collected".equals(license.getState().getValue()) || license.getEgwStatus() != null && "FIRSTLVLCOLLECTIONDONE".equals(license.getEgwStatus().getCode())) {
            smsMsg = this.licenseMessageSource.getMessage(String.format(MSG_LICENSE_FIRSTLEVEL_SMS, license.getLicenseAppType().getName().toLowerCase()), (Object[])new String[]{license.getLicensee().getApplicantName(), demandAmount.toString(), license.getNameOfEstablishment(), license.getApplicationNumber(), ApplicationThreadLocals.getMunicipalityName()}, locale);
            emailSubject = this.licenseMessageSource.getMessage(String.format(MSG_LICENSE_FIRSTLEVEL_SUBJECT, license.getLicenseAppType().getName().toLowerCase()), (Object[])new String[]{license.getLicenseAppType().getName()}, locale);
            emailBody = this.licenseMessageSource.getMessage(String.format(MSG_LICENSE_FIRSTLEVEL_BODY, license.getLicenseAppType().getName().toLowerCase()), (Object[])new String[]{license.getLicensee().getApplicantName(), demandAmount.toString(), license.getNameOfEstablishment(), license.getApplicationNumber(), ApplicationThreadLocals.getMunicipalityName()}, locale);
        } else {
            smsMsg = this.licenseMessageSource.getMessage(String.format(MSG_LICENSE_SECONDLEVEL_SMS, license.getLicenseAppType().getName().toLowerCase()), (Object[])new String[]{license.getLicensee().getApplicantName(), demandAmount.toString(), license.getNameOfEstablishment(), license.getLicenseNumber(), ApplicationThreadLocals.getMunicipalityName()}, locale);
            emailSubject = this.licenseMessageSource.getMessage("msg.newTradeLicensecollection.email.subject", (Object[])new String[]{license.getLicenseNumber()}, locale);
            emailBody = this.licenseMessageSource.getMessage(String.format(MSG_LICENSE_SECONDLEVEL_BODY, license.getLicenseAppType().getName().toLowerCase()), (Object[])new String[]{license.getLicensee().getApplicantName(), demandAmount.toString(), license.getNameOfEstablishment(), license.getLicenseNumber(), ApplicationThreadLocals.getMunicipalityName()}, locale);
        }
        this.sendSMSOnLicense(license.getLicensee().getMobilePhoneNumber(), smsMsg);
        this.sendEmailOnLicense(license.getLicensee().getEmailId(), emailBody, emailSubject);
    }

    public void sendSMsAndEmailOnClosure(License license, String workflowAction) {
        String smsMsg = null;
        String emailBody = "";
        String emailSubject = "";
        Locale locale = Locale.getDefault();
        if (license.getLicenseNumber() != null && "Forward".equals(workflowAction)) {
            smsMsg = this.licenseMessageSource.getMessage("msg.newTradeLicenseclosure.sms", (Object[])new String[]{license.getLicensee().getApplicantName(), license.getNameOfEstablishment(), license.getLicenseNumber(), this.getMunicipalityName()}, locale);
            emailBody = this.licenseMessageSource.getMessage("msg.newTradeLicenseclosure.email.body", (Object[])new String[]{license.getLicensee().getApplicantName(), license.getNameOfEstablishment(), license.getLicenseNumber(), this.getMunicipalityName()}, locale);
            emailSubject = this.licenseMessageSource.getMessage("msg.newTradeLicenseclosure.email.subject", (Object[])new String[]{license.getNameOfEstablishment()}, locale);
        } else if (license.getLicenseNumber() != null && "Approve".equals(workflowAction)) {
            smsMsg = this.licenseMessageSource.getMessage("msg.newTradeLicenseclosureapproval.sms", (Object[])new String[]{license.getLicensee().getApplicantName(), license.getNameOfEstablishment(), license.getLicenseNumber(), this.getMunicipalityName()}, locale);
            emailBody = this.licenseMessageSource.getMessage("msg.newTradeLicenseclosureapproval.email.body", (Object[])new String[]{license.getLicensee().getApplicantName(), license.getNameOfEstablishment(), license.getLicenseNumber(), this.getMunicipalityName()}, locale);
            emailSubject = this.licenseMessageSource.getMessage("msg.newTradeLicenseclosureapproval.email.subject", (Object[])new String[]{license.getNameOfEstablishment()}, locale);
        }
        this.sendSMSOnLicense(license.getLicensee().getMobilePhoneNumber(), smsMsg);
        this.sendEmailOnLicense(license.getLicensee().getEmailId(), emailBody, emailSubject);
    }

    public void sendSMsAndEmailOnDigitalSign(License license) {
        Locale locale = Locale.getDefault();
        String smsCode = "msg.digi.sign.no.collection";
        String smsMsg = this.licenseMessageSource.getMessage(smsCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), license.getNameOfEstablishment(), license.getLicenseNumber(), ApplicationThreadLocals.getDomainURL(), license.getDigiSignedCertFileStoreId(), this.getMunicipalityName()}, locale);
        String emailSubject = this.licenseMessageSource.getMessage("msg.Licensedigisign.email.subject", (Object[])new String[]{license.getNameOfEstablishment()}, locale);
        String emailBody = this.licenseMessageSource.getMessage("msg.digi.sign.no.collection", (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), license.getNameOfEstablishment(), license.getLicenseNumber(), ApplicationThreadLocals.getDomainURL(), license.getDigiSignedCertFileStoreId(), this.getMunicipalityName()}, locale);
        this.sendSMSOnLicense(license.getLicensee().getMobilePhoneNumber(), smsMsg);
        this.sendEmailOnLicense(license.getLicensee().getEmailId(), emailBody, emailSubject);
    }
}

