/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.service.CFinancialYearService;
import org.egov.demand.model.BillReceipt;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.core.LocalizationSettings;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecureCodeUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.FileUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseDemand;
import org.egov.tl.entity.LicenseDocument;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.entity.contracts.DemandNoticeForm;
import org.egov.tl.entity.contracts.OnlineSearchForm;
import org.egov.tl.entity.contracts.SearchForm;
import org.egov.tl.repository.SearchTradeRepository;
import org.egov.tl.repository.specs.SearchTradeSpec;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.TradeLicenseSmsAndEmailService;
import org.egov.tl.utils.LicenseUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class TradeLicenseService
extends AbstractLicenseService<TradeLicense> {
    @Autowired
    private TradeLicenseSmsAndEmailService tradeLicenseSmsAndEmailService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private LicenseUtils licenseUtils;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private SearchTradeRepository searchTradeRepository;
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private CityService cityService;
    @Autowired
    private EisCommonService eisCommonService;

    @Override
    protected NatureOfBusiness getNatureOfBusiness() {
        return this.natureOfBusinessService.getNatureOfBusinessByName("Permanent");
    }

    @Override
    protected Module getModuleName() {
        return this.moduleService.getModuleByName("Trade License");
    }

    @Override
    protected void sendEmailAndSMS(TradeLicense license, String currentAction) {
        this.tradeLicenseSmsAndEmailService.sendSmsAndEmail(license, currentAction);
    }

    @Override
    protected LicenseAppType getLicenseApplicationTypeForRenew() {
        return this.licenseAppTypeService.getLicenseAppTypeByName("Renew");
    }

    @Override
    protected LicenseAppType getLicenseApplicationType() {
        return this.licenseAppTypeService.getLicenseAppTypeByName("New");
    }

    @Override
    protected LicenseAppType getClosureLicenseApplicationType() {
        return this.licenseAppTypeService.getLicenseAppTypeByName("Closure");
    }

    @Transactional
    public void updateTradeLicense(TradeLicense license, WorkflowBean workflowBean) {
        this.processAndStoreDocument(license);
        this.licenseRepository.save((Object)license);
        this.tradeLicenseSmsAndEmailService.sendSmsAndEmail(license, workflowBean.getWorkFlowAction());
        this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex(license);
    }

    public void updateStatusInWorkFlowProgress(TradeLicense license, String workFlowAction) {
        List userPositions = this.positionMasterService.getPositionsForEmployee(this.securityUtils.getCurrentUser().getId());
        if ("Approve".equals(workFlowAction)) {
            if (StringUtils.isEmpty((CharSequence)license.getLicenseNumber()) && license.isNewApplication()) {
                license.setLicenseNumber(this.licenseNumberUtils.generateLicenseNumber());
            }
            if (license.getCurrentDemand().getBaseDemand().compareTo(license.getCurrentDemand().getAmtCollected()) <= 0) {
                this.licenseUtils.applicationStatusChange(license, "APPROVED");
            } else {
                this.licenseUtils.applicationStatusChange(license, "SECONDLVLCOLLECTIONPENDING");
            }
        }
        if ("Approve".equals(workFlowAction) || "Forward".equals(workFlowAction)) {
            license.setStatus(this.licenseStatusService.getLicenseStatusByCode("UWF"));
            if (license.getState().getValue().equals("Revenue clerk approved")) {
                this.licenseUtils.applicationStatusChange(license, "INSPECTIONDONE");
            }
            if (license.getState().getValue().equals("Rejected")) {
                this.licenseUtils.applicationStatusChange(license, "CREATED");
            }
        }
        if ("Generate Certificate".equals(workFlowAction)) {
            license.setActive(true);
            license.setStatus(this.licenseStatusService.getLicenseStatusByCode("ACT"));
            license.setLegacy(false);
            this.validityService.applyLicenseValidity(license);
            this.licenseUtils.applicationStatusChange(license, "CERTIFICATEGENERATED");
        }
        if ("Reject".equals(workFlowAction)) {
            if (license.getLicenseAppType() != null && userPositions.contains(license.getCurrentState().getInitiatorPosition()) && "Rejected".equals(license.getState().getValue()) || "License Created".equals(license.getState().getValue())) {
                license.setStatus(this.licenseStatusService.getLicenseStatusByCode("CAN"));
                this.licenseUtils.applicationStatusChange(license, "CANCELLED");
                if (license.isNewApplication()) {
                    license.setActive(false);
                }
            } else {
                license.setStatus(this.licenseStatusService.getLicenseStatusByCode("REJ"));
                this.licenseUtils.applicationStatusChange(license, "REJECTED");
            }
        }
        if (license.hasState() && license.getState().getValue().contains("Revenue clerk approved")) {
            BigDecimal currentDemandAmount = this.recalculateLicenseFee(license.getCurrentDemand());
            BigDecimal recalDemandAmount = this.calculateFeeAmount(license);
            if (recalDemandAmount.compareTo(currentDemandAmount) >= 0) {
                this.updateDemandForChangeTradeArea(license);
            }
        }
    }

    @ReadOnly
    public ReportOutput generateLicenseCertificate(License license, boolean isProvisional) {
        if ("Corp".equals(this.cityService.getCityGrade())) {
            return this.reportService.createReport(new ReportRequest("tl_licenseCertificateForCorp", (Object)license, this.getReportParamsForCertificate(license, isProvisional)));
        }
        return this.reportService.createReport(new ReportRequest("tl_licenseCertificate", (Object)license, this.getReportParamsForCertificate(license, isProvisional)));
    }

    private Map<String, Object> getReportParamsForCertificate(License license, boolean isProvisional) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        reportParams.put("applicationnumber", license.getApplicationNumber());
        reportParams.put("applicantName", license.getLicensee().getApplicantName());
        reportParams.put("licencenumber", license.getLicenseNumber());
        reportParams.put("wardName", license.getBoundary().getName());
        reportParams.put("cscNumber", "");
        reportParams.put("nameOfEstablishment", license.getNameOfEstablishment());
        reportParams.put("licenceAddress", StringEscapeUtils.escapeXml((String)license.getAddress()));
        reportParams.put("municipality", this.cityService.getMunicipalityName());
        reportParams.put("district", this.cityService.getDistrictName());
        reportParams.put("category", license.getCategory().getName());
        reportParams.put("subCategory", license.getTradeName().getName());
        reportParams.put("appType", license.isNewApplication() ? "New Trade" : "Renewal");
        reportParams.put("currentDate", DateUtils.currentDateToDefaultDateFormat());
        reportParams.put("carporationulbType", ApplicationThreadLocals.getMunicipalityName().contains("Corporation"));
        Optional<EgDemandDetails> demandDetails = license.getCurrentDemand().getEgDemandDetails().stream().sorted(Comparator.comparing(EgDemandDetails::getInstallmentEndDate).reversed()).filter(demandDetail -> demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().equals("License Fee")).filter(demandDetail -> demandDetail.getAmtCollected().doubleValue() > 0.0).findFirst();
        if (!demandDetails.isPresent()) {
            throw new ValidationException("License Fee is not paid", "License Fee is not paid", new String[0]);
        }
        BigDecimal amtPaid = demandDetails.get().getAmtCollected();
        String startYear = DateUtils.toYearFormat((Date)demandDetails.get().getInstallmentStartDate());
        String endYear = DateUtils.toYearFormat((Date)demandDetails.get().getInstallmentEndDate());
        reportParams.put("installMentYear", startYear + "-" + endYear);
        reportParams.put("applicationdate", DateUtils.getDefaultFormattedDate((Date)license.getApplicationDate()));
        reportParams.put("demandUpdateDate", DateUtils.getDefaultFormattedDate((Date)license.getCurrentDemand().getModifiedDate()));
        reportParams.put("demandTotalamt", amtPaid);
        List commissionerAssignments = this.assignmentService.findPrimaryAssignmentForDesignationName("Commissioner");
        if (!commissionerAssignments.isEmpty()) {
            Employee commissioner = ((Assignment)commissionerAssignments.get(0)).getEmployee();
            ByteArrayInputStream commissionerSign = new ByteArrayInputStream(commissioner.getSignature() == null ? new byte[]{} : commissioner.getSignature());
            reportParams.put("commissionerSign", commissionerSign);
        }
        if (isProvisional) {
            reportParams.put("certificateType", "provisional");
        } else {
            StringBuilder qrCodeValue = new StringBuilder();
            qrCodeValue.append("License Number : ").append(license.getLicenseNumber()).append(System.lineSeparator());
            qrCodeValue.append("Trade Title : ").append(license.getNameOfEstablishment()).append(System.lineSeparator());
            qrCodeValue.append("Owner Name : ").append(license.getLicensee().getApplicantName()).append(System.lineSeparator());
            qrCodeValue.append("Valid Till : ").append(DateUtils.toDefaultDateTimeFormat((Date)license.getDateOfExpiry())).append(System.lineSeparator());
            qrCodeValue.append("Installment Year : ").append(reportParams.get("installMentYear")).append(System.lineSeparator());
            qrCodeValue.append("Paid Amount : ").append(LocalizationSettings.currencySymbolUtf8()).append(amtPaid).append(System.lineSeparator());
            qrCodeValue.append("More : ").append(ApplicationThreadLocals.getDomainURL()).append("/tl/viewtradelicense/viewTradeLicense-view.action?id=").append(license.getId());
            reportParams.put("qrCode", SecureCodeUtils.generatePDF417Code((String)qrCodeValue.toString()));
        }
        return reportParams;
    }

    @ReadOnly
    public List<String> getTradeLicenseForGivenParam(String paramValue, String paramType) {
        List<Object> licenseList = new ArrayList();
        if (paramType.equals("ApplicationNumber")) {
            licenseList = this.licenseRepository.findAllApplicationNumberLike(paramValue);
        } else if (paramType.equals("LicenseNumber")) {
            licenseList = this.licenseRepository.findAllLicenseNumberLike(paramValue);
        } else if (paramType.equals("OldLicenseNumber")) {
            licenseList = this.licenseRepository.findAllOldLicenseNumberLike(paramValue);
        } else if (paramType.equals("TradeTitle")) {
            licenseList = this.licenseRepository.findAllNameOfEstablishmentLike(paramValue);
        } else if (paramType.equals("TradeOwnerName")) {
            licenseList = this.licenseRepository.findAllApplicantNameLike(paramValue);
        } else if (paramType.equals("PropertyAssessmentNo")) {
            licenseList = this.licenseRepository.findAllAssessmentNoLike(paramValue);
        } else if (paramType.equals("MobileNo")) {
            licenseList = this.licenseRepository.findAllMobilePhoneNumberLike(paramValue);
        }
        return licenseList;
    }

    @ReadOnly
    public Page<SearchForm> searchTradeLicense(SearchForm searchForm) {
        PageRequest pageable = new PageRequest(searchForm.pageNumber(), searchForm.pageSize(), searchForm.orderDir(), new String[]{searchForm.orderBy()});
        String currentUserRoles = this.securityUtils.getCurrentUser().getRoles().toString();
        Page licenses = this.searchTradeRepository.findAll(SearchTradeSpec.searchTrade(searchForm), (Pageable)pageable);
        ArrayList searchResults = new ArrayList();
        licenses.forEach(license -> {
            CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(license.getDateOfExpiry());
            String expiryYear = financialYear != null ? financialYear.getFinYearRange() : "";
            searchResults.add(new SearchForm((License)((Object)license), currentUserRoles, this.getOwnerName((License)((Object)license)), expiryYear));
        });
        return new PageImpl(searchResults, (Pageable)pageable, licenses.getTotalElements());
    }

    @ReadOnly
    public List<OnlineSearchForm> onlineSearchTradeLicense(OnlineSearchForm searchForm) {
        Criteria searchCriteria = this.entityQueryService.getSession().createCriteria(TradeLicense.class);
        searchCriteria.createAlias("licensee", "licc").createAlias("category", "cat").createAlias("tradeName", "subcat").createAlias("status", "licstatus");
        if (StringUtils.isNotBlank((CharSequence)searchForm.getApplicationNumber())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"applicationNumber", (Object)searchForm.getApplicationNumber()).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)searchForm.getLicenseNumber())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"licenseNumber", (Object)searchForm.getLicenseNumber()).ignoreCase());
        }
        searchCriteria.add(Restrictions.isNotNull((String)"applicationNumber"));
        searchCriteria.addOrder(Order.asc((String)"id"));
        ArrayList<OnlineSearchForm> searchResult = new ArrayList<OnlineSearchForm>();
        License license = (License)((Object)searchCriteria.uniqueResult());
        if (license != null) {
            searchResult.add(new OnlineSearchForm(license, this.getDemandColl(license)));
        }
        return searchResult;
    }

    public BigDecimal[] getDemandColl(License license) {
        Object[] dmdColl = new BigDecimal[3];
        Arrays.fill(dmdColl, BigDecimal.ZERO);
        license.getCurrentDemand().getEgDemandDetails().stream().forEach(arg_0 -> TradeLicenseService.lambda$getDemandColl$3(license, (BigDecimal[])dmdColl, arg_0));
        return dmdColl;
    }

    @ReadOnly
    public List<DemandNoticeForm> getLicenseDemandNotices(DemandNoticeForm demandnoticeForm) {
        Criteria searchCriteria = this.entityQueryService.getSession().createCriteria(TradeLicense.class);
        searchCriteria.createAlias("licensee", "licc").createAlias("category", "cat").createAlias("tradeName", "subcat").createAlias("status", "licstatus");
        if (StringUtils.isNotBlank((CharSequence)demandnoticeForm.getLicenseNumber())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"licenseNumber", (Object)demandnoticeForm.getLicenseNumber()).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)demandnoticeForm.getOldLicenseNumber())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"oldLicenseNumber", (Object)demandnoticeForm.getOldLicenseNumber()).ignoreCase());
        }
        if (demandnoticeForm.getCategoryId() != null) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"cat.id", (Object)demandnoticeForm.getCategoryId()));
        }
        if (demandnoticeForm.getSubCategoryId() != null) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"subcat.id", (Object)demandnoticeForm.getSubCategoryId()));
        }
        if (demandnoticeForm.getWardId() != null) {
            searchCriteria.createAlias("parentBoundary", "wards").add((Criterion)Restrictions.eq((String)"wards.id", (Object)demandnoticeForm.getWardId()));
        }
        if (demandnoticeForm.getLocalityId() != null) {
            searchCriteria.createAlias("boundary", "locality").add((Criterion)Restrictions.eq((String)"locality.id", (Object)demandnoticeForm.getLocalityId()));
        }
        if (demandnoticeForm.getStatusId() != null) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"status.id", (Object)demandnoticeForm.getStatusId()));
        } else {
            searchCriteria.add((Criterion)Restrictions.ne((String)"licstatus.statusCode", (Object)StringUtils.upperCase((String)"CAN")));
        }
        searchCriteria.addOrder(Order.asc((String)"id"));
        LinkedList<DemandNoticeForm> finalList = new LinkedList<DemandNoticeForm>();
        for (TradeLicense license : searchCriteria.list()) {
            LicenseDemand licenseDemand = license.getCurrentDemand();
            if (licenseDemand == null) continue;
            Installment currentInstallment = licenseDemand.getEgInstallmentMaster();
            List previousInstallment = this.installmentDao.fetchPreviousInstallmentsInDescendingOrderByModuleAndDate(this.licenseUtils.getModule("Trade License"), currentInstallment.getToDate(), 1);
            Map<String, Map<String, BigDecimal>> outstandingFees = this.getOutstandingFeeForDemandNotice(license, currentInstallment, (Installment)previousInstallment.get(0));
            Map<String, BigDecimal> licenseFees = outstandingFees.get("License Fee");
            finalList.add(new DemandNoticeForm(license, licenseFees, this.getOwnerName(license)));
        }
        return finalList;
    }

    public String getOwnerName(License license) {
        List assignmentList;
        String ownerName = license.getState() != null ? (!(assignmentList = this.assignmentService.getAssignmentsForPosition(((Position)license.getState().getOwnerPosition()).getId(), new Date())).isEmpty() ? ((Assignment)assignmentList.get(0)).getEmployee().getName() : license.getLastModifiedBy().getName()) : license.getLastModifiedBy().getName();
        return ownerName;
    }

    public List<HashMap<String, Object>> populateHistory(TradeLicense tradeLicense) {
        ArrayList<HashMap<String, Object>> processHistoryDetails = new ArrayList<HashMap<String, Object>>();
        if (tradeLicense.hasState()) {
            State state = tradeLicense.getCurrentState();
            User lastModifiedUser = state.getLastModifiedBy();
            HashMap<String, Object> currentStateDetail = new HashMap<String, Object>();
            currentStateDetail.put("date", state.getLastModifiedDate());
            currentStateDetail.put("updatedBy", !lastModifiedUser.getType().equals((Object)UserType.EMPLOYEE) ? tradeLicense.getLicensee().getApplicantName() : lastModifiedUser.getName());
            currentStateDetail.put("status", "END".equals(state.getValue()) ? "Completed" : state.getValue());
            currentStateDetail.put("comments", StringUtils.defaultString((String)state.getComments()));
            User ownerUser = state.getOwnerUser();
            Position ownerPosition = (Position)state.getOwnerPosition();
            if (ownerPosition != null) {
                User usr = this.eisCommonService.getUserForPosition(ownerPosition.getId(), state.getLastModifiedDate());
                currentStateDetail.put("user", usr == null ? "" : usr.getName());
            } else {
                currentStateDetail.put("user", ownerUser == null ? "" : ownerUser.getName());
            }
            processHistoryDetails.add(currentStateDetail);
            state.getHistory().stream().sorted(Comparator.comparing(StateHistory::getLastModifiedDate).reversed()).forEach(sh -> processHistoryDetails.add(this.constructHistory((StateHistory<Position>)sh, tradeLicense)));
        }
        return processHistoryDetails;
    }

    private HashMap<String, Object> constructHistory(StateHistory<Position> stateHistory, TradeLicense tradeLicense) {
        HashMap<String, Object> processHistory = new HashMap<String, Object>();
        User lastModifiedUser = stateHistory.getLastModifiedBy();
        processHistory.put("date", stateHistory.getLastModifiedDate());
        processHistory.put("updatedBy", !lastModifiedUser.getType().equals((Object)UserType.EMPLOYEE) ? tradeLicense.getLicensee().getApplicantName() : lastModifiedUser.getName());
        processHistory.put("status", "END".equals(stateHistory.getValue()) ? "Completed" : stateHistory.getValue());
        processHistory.put("comments", StringUtils.defaultString((String)stateHistory.getComments()));
        Position ownerPosition = (Position)stateHistory.getOwnerPosition();
        User ownerUser = stateHistory.getOwnerUser();
        if (ownerPosition != null) {
            User userPos = this.eisCommonService.getUserForPosition(ownerPosition.getId(), stateHistory.getLastModifiedDate());
            processHistory.put("user", userPos == null ? "" : userPos.getName());
        } else {
            processHistory.put("user", ownerUser == null ? "" : ownerUser.getName());
        }
        return processHistory;
    }

    @ReadOnly
    public List<License> getLicenses(Example license) {
        return this.licenseRepository.findAll(license);
    }

    public List<BillReceipt> getReceipts(License license) {
        return this.demandGenericDao.getBillReceipts((EgDemand)license.getCurrentDemand());
    }

    public LicenseDocumentType getLicenseDocumentType(Long id) {
        return (LicenseDocumentType)((Object)this.licenseDocumentTypeRepository.findOne(id));
    }

    public Map<String, Map<String, List<LicenseDocument>>> getAttachedDocument(Long licenseId) {
        List<LicenseDocument> licenseDocuments = ((TradeLicense)((Object)this.getLicenseById(licenseId))).getDocuments();
        HashMap<String, Map<String, List<LicenseDocument>>> licenseDocumentDetails = new HashMap<String, Map<String, List<LicenseDocument>>>();
        licenseDocumentDetails.put("New".toUpperCase(), new HashMap());
        licenseDocumentDetails.put("Renew".toUpperCase(), new HashMap());
        for (LicenseDocument document : licenseDocuments) {
            String docType = document.getType().getName();
            String appType = document.getType().getApplicationType().toString();
            if (((Map)licenseDocumentDetails.get(appType)).containsKey(docType)) {
                ((List)((Map)licenseDocumentDetails.get(appType)).get(docType)).add(document);
                continue;
            }
            ArrayList<LicenseDocument> documents = new ArrayList<LicenseDocument>();
            documents.add(document);
            ((Map)licenseDocumentDetails.get(appType)).put(docType, documents);
        }
        return licenseDocumentDetails;
    }

    public ReportOutput generateAcknowledgment(Long licenseId) {
        Object license = this.getLicenseById(licenseId);
        HashMap<String, BigDecimal> reportParams = new HashMap<String, BigDecimal>();
        reportParams.put("amount", ((License)((Object)license)).getTotalBalance());
        ReportRequest reportRequest = new ReportRequest("tl_license_acknowledgment", license, reportParams);
        reportRequest.setReportFormat(ReportFormat.PDF);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        reportOutput.setReportName(org.egov.infra.utils.StringUtils.append((String)"license_ack_", (String)((License)((Object)license)).getApplicationNumber()));
        return reportOutput;
    }

    @ReadOnly
    public ReportOutput generateClosureNotice(String reportFormat) {
        ReportOutput reportOutput = new ReportOutput();
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        List<License> licenses = this.searchTradeRepository.findLicenseClosureByCurrentInstallmentYear(new Date());
        if (licenses.isEmpty()) {
            reportOutput.setReportName("tl_closure_notice");
            reportOutput.setReportFormat(ReportFormat.PDF);
            reportOutput.setReportOutputData("No Data".getBytes());
        } else {
            reportParams.put("License", licenses);
            reportParams.put("corp", this.cityService.getCityGrade());
            reportParams.put("currentDate", DateUtils.currentDateToDefaultDateFormat());
            reportParams.put("municipality", this.cityService.getMunicipalityName());
            reportOutput = this.reportService.createReport(new ReportRequest("tl_closure_notice", licenses, reportParams));
        }
        if (reportFormat.equalsIgnoreCase("zip")) {
            reportOutput.setReportOutputData(FileUtils.toByteArray((Path)FileUtils.addFilesToZip((File[])new File[]{FileUtils.byteArrayToFile((byte[])reportOutput.getReportOutputData(), (String)"tl_closure_notice_", (String)".pdf").toFile()})));
        }
        return reportOutput;
    }

    private static /* synthetic */ void lambda$getDemandColl$3(License license, BigDecimal[] dmdColl, EgDemandDetails egDemandDetails) {
        if (license.getCurrentDemand().getEgInstallmentMaster().equals((Object)egDemandDetails.getEgDemandReason().getEgInstallmentMaster())) {
            dmdColl[1] = dmdColl[1].add(egDemandDetails.getAmount());
            dmdColl[2] = dmdColl[2].add(egDemandDetails.getAmtCollected());
        } else {
            dmdColl[0] = dmdColl[0].add(egDemandDetails.getAmount());
            dmdColl[2] = dmdColl[2].add(egDemandDetails.getAmtCollected());
        }
    }
}

