/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.License;
import org.egov.tl.repository.LicenseRepository;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.service.es.LicenseApplicationIndexService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProcessOwnerReassignmentService {
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private LicenseRepository licenseRepository;
    @Autowired
    private LicenseApplicationIndexService licenseApplicationIndexService;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    public Map<String, String> employeePositionMap() {
        List assignments = this.assignmentService.findByDepartmentCodeAndDesignationCode("PHS", Arrays.asList("JASST", "SASST"));
        assignments.removeAll(this.assignmentService.getAllAssignmentsByEmpId(ApplicationThreadLocals.getUserId()));
        return assignments.stream().collect(Collectors.toMap(assignment -> assignment.getPosition().getId().toString(), assignment -> new StringBuffer().append(assignment.getEmployee().getName()).append("-").append(assignment.getPosition().getName()).toString()));
    }

    @Transactional
    public Boolean reassignLicenseProcessOwner(Long licenseId, Long approverPositionId) {
        Object license = this.tradeLicenseService.getLicenseById((long)licenseId);
        if (license != null) {
            Position position = this.positionMasterService.getPositionById(approverPositionId);
            license.changeProcessOwner((OwnerGroup)position);
            license.changeProcessInitiator((OwnerGroup)position);
            this.licenseRepository.save(license);
            this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex((License)((Object)license));
            return true;
        }
        return false;
    }

    public boolean reassignmentEnabled() {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Trade License", "Reassignment");
        return !appConfigValues.isEmpty() && "Y".equals(((AppConfigValues)appConfigValues.get(0)).getValue());
    }
}

