/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.matrix.service.WorkFlowMatrixService;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.entity.contracts.LicenseStateInfo;
import org.egov.tl.service.LicenseStatusService;
import org.egov.tl.service.ValidityService;
import org.egov.tl.utils.LicenseUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LicenseProcessWorkflowService {
    private static final String ERROR_KEY_WF_INITIATOR_NOT_DEFINED = "error.wf.initiator.not.defined";
    @Autowired
    protected LicenseStatusService licenseStatusService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<TradeLicense> licenseWorkflowService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private LicenseUtils licenseUtils;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private WorkFlowMatrixService workFlowMatrixService;
    @Autowired
    private ValidityService validityService;

    public void createNewLicenseWorkflowTransition(TradeLicense tradeLicense, WorkflowBean workflowBean) {
        DateTime currentDate = new DateTime();
        User currentUser = this.securityUtils.getCurrentUser();
        State currentState = tradeLicense.getCurrentState();
        List userPositions = this.positionMasterService.getPositionsForEmployee(currentUser.getId());
        if ("Approve".equals(workflowBean.getWorkFlowAction()) && tradeLicense.isCollectionPending()) {
            if (tradeLicense.isNewApplication()) {
                workflowBean.setAdditionaRule("NEWLICENSECOLLECTION");
            } else {
                workflowBean.setAdditionaRule("RENEWLICENSECOLLECTION");
            }
        }
        WorkFlowMatrix workFlowMatrix = this.getWorkFlowMatrix(tradeLicense, workflowBean);
        if (!tradeLicense.hasState() || tradeLicense.transitionCompleted()) {
            Position wfInitiator = this.getWfInitiatorByUser(workFlowMatrix.getCurrentDesignation());
            LicenseStateInfo licenseStateInfo = this.getLicenseStateInfo(workflowBean, wfInitiator, workFlowMatrix, new LicenseStateInfo(), wfInitiator);
            this.initiateWfTransition(tradeLicense);
            tradeLicense.transition().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(tradeLicense.isReNewApplication() ? "Renewal of Trade License" : "New Trade License").withStateValue(workFlowMatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)wfInitiator).withNextAction(workFlowMatrix.getNextAction()).withInitiator((OwnerGroup)wfInitiator).withExtraInfo((Object)licenseStateInfo);
        } else if ("Cancel".equalsIgnoreCase(workflowBean.getWorkFlowAction()) && userPositions.contains(tradeLicense.getCurrentState().getInitiatorPosition())) {
            tradeLicense.transition().end().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            this.updateCancelStatus(tradeLicense);
        } else if ("Sign".equals(workflowBean.getWorkFlowAction())) {
            tradeLicense.transition().end().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withStateValue(workFlowMatrix.getCurrentState()).withDateInfo(currentDate.toDate()).withNextAction(workFlowMatrix.getCurrentStatus());
            this.updateActiveStatus(tradeLicense);
        } else {
            Position owner = this.getCurrentPositionByWorkFlowBean(workflowBean, (State<Position>)currentState);
            LicenseStateInfo licenseStateInfo = this.getLicenseStateInfo(workflowBean, owner, workFlowMatrix, tradeLicense.extraInfo(), (Position)currentState.getOwnerPosition());
            this.commonWorkflowTransition(tradeLicense, workflowBean, workFlowMatrix, licenseStateInfo);
        }
    }

    private void updateCancelStatus(TradeLicense tradeLicense) {
        tradeLicense.setStatus(this.licenseStatusService.getLicenseStatusByCode("CAN"));
        tradeLicense.setCollectionPending(false);
        if (tradeLicense.isNewApplication()) {
            tradeLicense.setActive(false);
        }
        tradeLicense.setNewWorkflow(false);
    }

    private void initiateWfTransition(TradeLicense tradeLicense) {
        if (!tradeLicense.hasState()) {
            tradeLicense.transition().start();
        } else {
            tradeLicense.transition().startNext();
        }
    }

    private LicenseStateInfo getLicenseStateInfo(WorkflowBean workflowBean, Position position, WorkFlowMatrix workFlowMatrix, LicenseStateInfo licenseStateInfo, Position currentPosition) {
        if (workFlowMatrix.isRejectEnabled() != null && workFlowMatrix.isRejectEnabled().booleanValue()) {
            licenseStateInfo.setRejectionPosition(currentPosition.getId());
        }
        if (workFlowMatrix.getNextref() != null) {
            licenseStateInfo.setWfMatrixRef(workFlowMatrix.getNextref());
        } else {
            WorkFlowMatrix nextWorkFlowMatrix = this.licenseWorkflowService.getWfMatrix("TradeLicense", "ANY", null, workflowBean.getAdditionaRule(), workFlowMatrix.getNextState(), null, new Date(), "%" + position.getDeptDesig().getDesignation().getName() + "%");
            if (nextWorkFlowMatrix != null) {
                licenseStateInfo.setWfMatrixRef(nextWorkFlowMatrix.getId());
            }
        }
        return licenseStateInfo;
    }

    private void commonWorkflowTransition(TradeLicense tradeLicense, WorkflowBean workflowBean, WorkFlowMatrix workFlowMatrix, LicenseStateInfo licenseStateInfo) {
        DateTime currentDate = new DateTime();
        User currentUser = this.securityUtils.getCurrentUser();
        Position owner = this.getCurrentPositionByWorkFlowBean(workflowBean, (State<Position>)tradeLicense.getCurrentState());
        if (!this.licenseUtils.isDigitalSignEnabled().booleanValue() && "Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction()) && !tradeLicense.isCollectionPending()) {
            tradeLicense.transition().end().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withStateValue(workFlowMatrix.getNextState()).withDateInfo(currentDate.toDate());
            this.updateActiveStatus(tradeLicense);
        } else {
            tradeLicense.transition().progressWithStateCopy().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withStateValue(workFlowMatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)owner).withNextAction("Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction()) ? workFlowMatrix.getNextAction() : "").withExtraInfo((Object)licenseStateInfo);
            if ("Approve".equals(workflowBean.getWorkFlowAction()) && tradeLicense.isCollectionPending()) {
                tradeLicense.setStatus(this.licenseStatusService.getLicenseStatusByCode("COLLECTIONPENDING"));
            } else {
                tradeLicense.setStatus(this.licenseStatusService.getLicenseStatusByCode("UWF"));
            }
        }
    }

    private Position getCurrentPositionByWorkFlowBean(WorkflowBean workflowBean, State<Position> currentState) {
        if (workflowBean.getApproverPositionId() != null && workflowBean.getWorkFlowAction() != null && !"Approve".equals(workflowBean.getWorkFlowAction())) {
            return this.positionMasterService.getPositionById(workflowBean.getApproverPositionId());
        }
        return (Position)currentState.getOwnerPosition();
    }

    private Position getWfInitiatorByUser(String designation) {
        User currentUser = this.securityUtils.getCurrentUser();
        List assignments = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(currentUser.getId());
        if (!assignments.isEmpty()) {
            Optional<Assignment> empAssignment = assignments.stream().filter(assignment -> designation.contains(assignment.getDesignation().getName())).findAny();
            if (empAssignment.isPresent()) {
                return empAssignment.get().getPosition();
            }
            throw new ValidationException(ERROR_KEY_WF_INITIATOR_NOT_DEFINED, "No officials assigned to process this application", new String[0]);
        }
        throw new ValidationException(ERROR_KEY_WF_INITIATOR_NOT_DEFINED, "No officials assigned to process this application", new String[0]);
    }

    public WorkFlowMatrix getWorkFlowMatrix(TradeLicense tradeLicense, WorkflowBean workflowBean) {
        WorkFlowMatrix wfmatrix;
        if (tradeLicense.hasState() && !tradeLicense.getState().isEnded()) {
            State state = tradeLicense.getState();
            wfmatrix = this.licenseWorkflowService.getWfMatrix(tradeLicense.getStateType(), "ANY", null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState() != null ? workflowBean.getCurrentState() : state.getValue(), null, new Date(), workflowBean.getCurrentDesignation() != null ? workflowBean.getCurrentDesignation() : "%" + ((Position)state.getOwnerPosition()).getDeptDesig().getDesignation().getName() + "%");
        } else {
            wfmatrix = this.licenseWorkflowService.getWfMatrix(tradeLicense.getStateType(), "ANY", null, workflowBean.getAdditionaRule(), "Start", null, new Date(), null);
        }
        return wfmatrix;
    }

    public void collectionWorkflowTransition(TradeLicense tradeLicense) {
        WorkFlowMatrix workFlowMatrix;
        DateTime currentDate = new DateTime();
        User currentUser = this.securityUtils.getCurrentUser();
        LicenseStateInfo licenseStateInfo = tradeLicense.extraInfo();
        if (!StringUtils.isEmpty((CharSequence)tradeLicense.getState().getExtraInfo()) && (workFlowMatrix = this.workFlowMatrixService.getWorkFlowObjectbyId(Long.valueOf(licenseStateInfo.getWfMatrixRef()))) != null) {
            if (this.licenseUtils.isDigitalSignEnabled().booleanValue() || "ACK".equals(tradeLicense.getStatus().getStatusCode())) {
                tradeLicense.transition().progressWithStateCopy().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workFlowMatrix.getNextState()).withStateValue(workFlowMatrix.getNextState()).withDateInfo(currentDate.toDate()).withNextAction(workFlowMatrix.getNextAction());
                tradeLicense.setStatus(this.licenseStatusService.getLicenseStatusByCode("UWF"));
            } else {
                tradeLicense.transition().end().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workFlowMatrix.getNextState()).withStateValue(workFlowMatrix.getNextState()).withDateInfo(currentDate.toDate());
                this.updateActiveStatus(tradeLicense);
            }
        }
    }

    private void updateActiveStatus(TradeLicense tradeLicense) {
        tradeLicense.setStatus(this.licenseStatusService.getLicenseStatusByCode("ACT"));
        tradeLicense.setActive(true);
        tradeLicense.setLegacy(false);
        this.validityService.applyLicenseValidity(tradeLicense);
        tradeLicense.setNewWorkflow(false);
    }

    public void getWfWithThirdPartyOp(TradeLicense license, WorkflowBean workflowBean) {
        LicenseStateInfo licenseStateInfo;
        Assignment wfAssignment;
        WorkFlowMatrix workFlowMatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState(), null, new Date(), null);
        List<Assignment> assignmentList = this.getAssignments(workFlowMatrix);
        if (!assignmentList.isEmpty()) {
            String additionalRule = license.isNewApplication() ? "NEWLICENSE" : "RENEWLICENSE";
            wfAssignment = assignmentList.get(0);
            WorkFlowMatrix nextWorkFlowMatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), "ANY", null, additionalRule, workFlowMatrix.getNextState(), null, new Date(), "%" + wfAssignment.getDesignation().getName() + "%");
            licenseStateInfo = new LicenseStateInfo();
            if (nextWorkFlowMatrix != null) {
                licenseStateInfo.setWfMatrixRef(nextWorkFlowMatrix.getId());
            }
        } else {
            throw new ValidationException(ERROR_KEY_WF_INITIATOR_NOT_DEFINED, ERROR_KEY_WF_INITIATOR_NOT_DEFINED, new String[0]);
        }
        this.initiateWfTransition(license);
        license.transition().withSenderName(wfAssignment.getEmployee().getUsername() + "::" + wfAssignment.getEmployee().getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(license.isReNewApplication() ? "Renewal of Trade License" : "New Trade License").withStateValue(workFlowMatrix.getNextState()).withDateInfo(new Date()).withOwner((OwnerGroup)wfAssignment.getPosition()).withNextAction(workFlowMatrix.getNextAction()).withInitiator((OwnerGroup)wfAssignment.getPosition()).withExtraInfo((Object)licenseStateInfo);
    }

    public void getRejectTransition(TradeLicense tradeLicense, WorkflowBean workflowBean) {
        User currentUser = this.securityUtils.getCurrentUser();
        workflowBean.setAdditionaRule(tradeLicense.isNewApplication() ? "NEWLICENSEREJECT" : "RENEWLICENSEREJECT");
        WorkFlowMatrix workFlowMatrix = this.getWorkFlowMatrix(tradeLicense, workflowBean);
        if (!tradeLicense.getCurrentState().getExtraInfo().isEmpty()) {
            LicenseStateInfo licenseStateInfo = (LicenseStateInfo)tradeLicense.extraInfoAs(LicenseStateInfo.class);
            Position ownerPosition = licenseStateInfo.getRejectionPosition() != null && !licenseStateInfo.getRejectionPosition().equals(((Position)tradeLicense.getCurrentState().getOwnerPosition()).getId()) ? this.positionMasterService.getPositionById(licenseStateInfo.getRejectionPosition()) : (Position)tradeLicense.getCurrentState().getInitiatorPosition();
            tradeLicense.transition().progressWithStateCopy().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withStateValue(workFlowMatrix.getNextState()).withDateInfo(new DateTime().toDate()).withOwner((OwnerGroup)ownerPosition).withNextAction(workFlowMatrix.getNextAction()).withExtraInfo((Object)licenseStateInfo);
            tradeLicense.setStatus(this.licenseStatusService.getLicenseStatusByCode("REJ"));
        }
    }

    private List<Assignment> getAssignments(WorkFlowMatrix workFlowMatrix) {
        List nextDesig;
        Department nextAssigneeDept = this.departmentService.getDepartmentByName(workFlowMatrix.getDepartment());
        List<Assignment> assignmentList = this.getAssignmentsForDeptAndDesignation(nextAssigneeDept, nextDesig = this.designationService.getDesignationsByNames(Arrays.asList(StringUtils.upperCase((String)workFlowMatrix.getNextDesignation()).split(","))));
        if (assignmentList.isEmpty()) {
            throw new ValidationException(ERROR_KEY_WF_INITIATOR_NOT_DEFINED, ERROR_KEY_WF_INITIATOR_NOT_DEFINED, new String[0]);
        }
        return assignmentList;
    }

    private List<Assignment> getAssignmentsForDeptAndDesignation(Department nextAssigneeDept, List<Designation> nextAssigneeDesig) {
        ArrayList designationIds = new ArrayList();
        nextAssigneeDesig.forEach(designation -> designationIds.add(designation.getId()));
        return this.assignmentService.findByDepartmentDesignationsAndGivenDate(nextAssigneeDept.getId(), designationIds, new Date());
    }

    public void setLicenseWorkflowService(SimpleWorkflowService<TradeLicense> licenseWorkflowService) {
        this.licenseWorkflowService = licenseWorkflowService;
    }
}

