/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.portal.entity.PortalInboxBuilder;
import org.egov.portal.service.PortalInboxService;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.utils.LicenseUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseCitizenPortalService {
    private static final String APPLICATION_VIEW_URL = "/tl/viewtradelicense/viewTradeLicense-view.action?applicationNo=%s";
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private PortalInboxService portalInboxService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private LicenseUtils licenseUtils;

    public void onCreate(TradeLicense tradeLicense) {
        Module module = this.moduleService.getModuleByName("Trade License");
        PortalInboxBuilder portalInboxBuilder = new PortalInboxBuilder(module, tradeLicense.getState().getNatureOfTask(), tradeLicense.getApplicationNumber(), tradeLicense.getLicenseNumber() != null ? tradeLicense.getLicenseNumber() : tradeLicense.getApplicationNumber(), tradeLicense.getId(), tradeLicense.getStateType(), this.getDetailedMessage(tradeLicense), String.format(APPLICATION_VIEW_URL, tradeLicense.getApplicationNumber()), tradeLicense.transitionCompleted(), tradeLicense.getStatus().getName(), DateUtils.addHours((Date)new Date(), (int)this.licenseUtils.getSlaForAppType(tradeLicense.getLicenseAppType())), tradeLicense.getState(), Arrays.asList(this.securityUtils.getCurrentUser()));
        this.portalInboxService.pushInboxMessage(portalInboxBuilder.build());
    }

    private String getDetailedMessage(TradeLicense tradeLicense) {
        StringBuilder detailedMessage = new StringBuilder();
        if (tradeLicense.getLicenseAppType() != null) {
            detailedMessage.append("Application Number -").append(tradeLicense.getApplicationNumber()).append(" regarding ").append(tradeLicense.getState().getNatureOfTask() + " ").append(" is initiated");
        }
        return detailedMessage.toString();
    }

    public void onUpdate(TradeLicense tradeLicense) {
        this.portalInboxService.updateInboxMessage(tradeLicense.getApplicationNumber(), this.moduleService.getModuleByName("Trade License").getId(), tradeLicense.getStatus().getName(), Boolean.valueOf(tradeLicense.transitionCompleted()), null, tradeLicense.getState(), tradeLicense.getCreatedBy(), tradeLicense.getLicenseNumber() != null ? tradeLicense.getLicenseNumber() : tradeLicense.getApplicationNumber(), String.format(APPLICATION_VIEW_URL, tradeLicense.getApplicationNumber()));
    }
}

