/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.tl.entity.License;
import org.egov.tl.repository.LicenseRepository;
import org.egov.tl.service.LicenseApplicationService;
import org.egov.tl.service.TradeLicenseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LicenseCertificateDigiSignService {
    @Autowired
    private LicenseRepository licenseRepository;
    @Autowired
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private LicenseApplicationService licenseApplicationService;

    @Transactional
    public void digitalSignTransition(List<String> applicationNumbers) {
        for (String applicationNumber : applicationNumbers) {
            Object license = this.tradeLicenseService.getLicenseByApplicationNumber(applicationNumber);
            if (!((License)((Object)license)).isNewWorkflow()) {
                this.tradeLicenseService.digitalSignTransition(applicationNumber);
                continue;
            }
            this.licenseApplicationService.digitalSignature(applicationNumber);
        }
    }

    public List<License> getLicensePendingForDigiSign() {
        return this.licenseRepository.findByStateNextActionAndStateOwnerPositionIn("Digital Signature Pending", this.positionMasterService.getCurrentUserPositions());
    }

    public List<License> generateLicenseCertificateForDigiSign(List<Long> licenseIds) {
        ArrayList<License> licenses = new ArrayList<License>();
        for (Long licenseId : licenseIds) {
            Object license = this.tradeLicenseService.getLicenseById((long)licenseId);
            ReportOutput reportOutput = this.tradeLicenseService.generateLicenseCertificate((License)((Object)license), false);
            if (reportOutput == null) continue;
            ByteArrayInputStream fileStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
            FileStoreMapper fileStore = this.fileStoreService.store((InputStream)fileStream, "SN/" + ((License)((Object)license)).getApplicationNumber() + ".pdf", "application/pdf", "TL");
            ((License)((Object)license)).setDigiSignedCertFileStoreId(fileStore.getFileStoreId());
            this.tradeLicenseService.save((License)((Object)license));
            licenses.add((License)((Object)license));
        }
        return licenses;
    }
}

