/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.List;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.repository.LicenseCategoryRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LicenseCategoryService {
    @Autowired
    private LicenseCategoryRepository licenseCategoryRepository;

    @Transactional
    public LicenseCategory saveCategory(LicenseCategory licenseCategory) {
        return (LicenseCategory)((Object)this.licenseCategoryRepository.save((Object)licenseCategory));
    }

    public LicenseCategory getCategoryByCode(String code) {
        return this.licenseCategoryRepository.findByCodeIgnoreCase(code);
    }

    public List<LicenseCategory> getCategories() {
        return this.licenseCategoryRepository.findAll();
    }

    public List<LicenseCategory> getCategoriesOrderByName() {
        return this.licenseCategoryRepository.findAllByOrderByNameAsc();
    }

    public String getCategoryCode() {
        return String.format("%05d", this.licenseCategoryRepository.findTopByOrderByIdDesc().getId() + 1L);
    }
}

