/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.tl.entity.License;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.service.LicenseCitizenPortalService;
import org.egov.tl.service.LicenseProcessWorkflowService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.service.TradeLicenseSmsAndEmailService;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LicenseApplicationService
extends TradeLicenseService {
    @Autowired
    private TradeLicenseSmsAndEmailService tradeLicenseSmsAndEmailService;
    @Autowired
    private LicenseProcessWorkflowService licenseProcessWorkflowService;
    @Autowired
    private LicenseCitizenPortalService licenseCitizenPortalService;

    @Transactional
    public License createWithMeseva(TradeLicense license, WorkflowBean wfBean) {
        return this.create(license, wfBean);
    }

    @Transactional
    public License renewWithMeeseva(TradeLicense license, WorkflowBean wfBean) {
        return this.renew(license, wfBean);
    }

    @Transactional
    public License create(TradeLicense license, WorkflowBean workflowBean) {
        Date fromRange = this.installmentDao.getInsatllmentByModuleForGivenDate(this.getModuleName(), new DateTime().toDate()).getFromDate();
        Date toRange = this.installmentDao.getInsatllmentByModuleForGivenDate(this.getModuleName(), new DateTime().plusYears(1).toDate()).getToDate();
        if (license.getCommencementDate().before(fromRange) || license.getCommencementDate().after(toRange)) {
            throw new ValidationException("TL-009", "TL-009", new String[0]);
        }
        license.setLicenseAppType(this.getLicenseApplicationType());
        this.raiseNewDemand(license);
        license.getLicensee().setLicense(license);
        license.setStatus(this.licenseStatusService.getLicenseStatusByName("Acknowledged"));
        if (StringUtils.isBlank((CharSequence)license.getApplicationNumber())) {
            license.setApplicationNumber(this.licenseNumberUtils.generateApplicationNumber());
        }
        this.processAndStoreDocument(license);
        if (this.securityUtils.currentUserIsEmployee()) {
            this.licenseProcessWorkflowService.createNewLicenseWorkflowTransition(license, workflowBean);
        } else {
            this.licenseProcessWorkflowService.getWfWithThirdPartyOp(license, workflowBean);
        }
        this.licenseRepository.save((Object)license);
        if (this.securityUtils.currentUserIsCitizen()) {
            this.licenseCitizenPortalService.onCreate(license);
        }
        this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex(license);
        this.sendEmailAndSMS(license, workflowBean.getWorkFlowAction());
        return license;
    }

    @Transactional
    public License renew(TradeLicense license, WorkflowBean workflowBean) {
        license.setLicenseAppType(this.getLicenseApplicationTypeForRenew());
        if (!this.currentUserIsMeeseva().booleanValue()) {
            license.setApplicationNumber(this.licenseNumberUtils.generateApplicationNumber());
        }
        this.recalculateDemand(this.feeMatrixService.getLicenseFeeDetails(license, license.getLicenseDemand().getEgInstallmentMaster().getFromDate()), license);
        license.setStatus(this.licenseStatusService.getLicenseStatusByName("Acknowledged"));
        this.processAndStoreDocument(license);
        if (this.securityUtils.currentUserIsEmployee()) {
            this.licenseProcessWorkflowService.createNewLicenseWorkflowTransition(license, workflowBean);
        } else {
            this.licenseProcessWorkflowService.getWfWithThirdPartyOp(license, workflowBean);
        }
        this.licenseRepository.save((Object)license);
        if (this.securityUtils.currentUserIsCitizen()) {
            this.licenseCitizenPortalService.onCreate(license);
        }
        this.sendEmailAndSMS(license, workflowBean.getWorkFlowAction());
        this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex(license);
        return license;
    }

    @Transactional
    public License save(TradeLicense license) {
        license.setLicenseAppType(this.getLicenseApplicationType());
        if (this.securityUtils.currentUserIsEmployee()) {
            this.licenseRepository.save((Object)license);
        }
        return license;
    }

    @Override
    @Transactional
    public void updateTradeLicense(TradeLicense license, WorkflowBean workflowBean) {
        this.updateDemandForChangeTradeArea(license);
        if (!license.isPaid()) {
            license.setCollectionPending(true);
        } else {
            license.setCollectionPending(false);
        }
        if ("Reject".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            this.licenseProcessWorkflowService.getRejectTransition(license, workflowBean);
        } else {
            this.licenseProcessWorkflowService.createNewLicenseWorkflowTransition(license, workflowBean);
        }
        if ("Approve".equals(workflowBean.getWorkFlowAction()) && StringUtils.isEmpty((CharSequence)license.getLicenseNumber()) && license.isNewApplication()) {
            license.setLicenseNumber(this.licenseNumberUtils.generateLicenseNumber());
        }
        this.licenseRepository.save((Object)license);
        this.licenseCitizenPortalService.onUpdate(license);
        this.tradeLicenseSmsAndEmailService.sendSmsAndEmail(license, workflowBean.getWorkFlowAction());
        this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex(license);
    }

    public void digitalSignature(String applicationNumber) {
        if (StringUtils.isNotBlank((CharSequence)applicationNumber)) {
            License license = this.licenseRepository.findByApplicationNumber(applicationNumber);
            WorkflowBean workflowBean = new WorkflowBean();
            workflowBean.setWorkFlowAction("Sign");
            workflowBean.setAdditionaRule(license.isNewApplication() ? "NEWLICENSE" : "RENEWLICENSE");
            this.licenseProcessWorkflowService.createNewLicenseWorkflowTransition((TradeLicense)license, workflowBean);
            this.licenseRepository.save((Object)license);
            this.licenseCitizenPortalService.onUpdate((TradeLicense)license);
            this.tradeLicenseSmsAndEmailService.sendSMsAndEmailOnDigitalSign(license);
            this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex(license);
        }
    }

    public void collectionTransition(TradeLicense tradeLicense) {
        this.licenseProcessWorkflowService.collectionWorkflowTransition(tradeLicense);
    }

    public WorkFlowMatrix getWorkflowAPI(TradeLicense tradeLicense, WorkflowBean workflowBean) {
        if ("Reject".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            workflowBean.setAdditionaRule(tradeLicense.isNewApplication() ? "NEWLICENSEREJECT" : "RENEWLICENSEREJECT");
        }
        return this.licenseProcessWorkflowService.getWorkFlowMatrix(tradeLicense, workflowBean);
    }
}

