/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.persistence.utils.Page;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.tl.entity.contracts.InstallmentWiseDCBRequest;
import org.egov.tl.entity.view.InstallmentWiseDCB;
import org.egov.tl.repository.InstallmentwiseDCBReportRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class InstallmentwiseDCBReportService {
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private InstallmentwiseDCBReportRepository installmentwiseDCBReportRepository;
    @Autowired
    private ReportService reportService;

    public List<CFinancialYear> getFinancialYears() {
        List financialYearList = this.cFinancialYearService.findAll();
        Collections.reverse(financialYearList);
        return financialYearList;
    }

    @ReadOnly
    public Date financialYearStartDate(InstallmentWiseDCBRequest installmentWiseDCBRequest) {
        return this.cFinancialYearService.getFinacialYearByYearRange(installmentWiseDCBRequest.getInstallment()).getStartingDate();
    }

    @ReadOnly
    public Page<InstallmentWiseDCB> getReportResult(InstallmentWiseDCBRequest installmentWiseDCBRequest) {
        return this.installmentwiseDCBReportRepository.findByInstallmentWiseDCB(installmentWiseDCBRequest, this.financialYearStartDate(installmentWiseDCBRequest));
    }

    @ReadOnly
    public ReportOutput generateInstallmentwiseDCBReport(InstallmentWiseDCBRequest reportCriteria) {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("year", reportCriteria.getInstallment());
        ReportRequest reportRequest = new ReportRequest("tl_installment_yearwise_dcb_report", this.installmentwiseDCBReportRepository.findInstallmentWiseReport(reportCriteria, this.financialYearStartDate(reportCriteria)), reportParams);
        reportRequest.setReportFormat(reportCriteria.getPrintFormat());
        return this.reportService.createReport(reportRequest);
    }

    @ReadOnly
    public Object[] reportGrandTotal(InstallmentWiseDCBRequest installmentWiseDCBRequest) {
        return this.installmentwiseDCBReportRepository.findReportTotal(installmentWiseDCBRequest, this.financialYearStartDate(installmentWiseDCBRequest));
    }
}

