/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.EnvironmentSettings;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.PersistenceUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.tl.entity.DemandGenerationLog;
import org.egov.tl.entity.DemandGenerationLogDetail;
import org.egov.tl.entity.License;
import org.egov.tl.entity.contracts.DemandGenerationRequest;
import org.egov.tl.entity.enums.ProcessStatus;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.DemandGenerationLogService;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DemandGenerationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DemandGenerationService.class);
    private static final String LICENSE_NOT_ACTIVE = "License Not Active";
    private static final String SUCCESSFUL = "Successful";
    private static final String DEMAND_EXIST = "Demand exist";
    private static final String ERRORMSG = "Error occurred while generating demand for license {}";
    @Autowired
    private DemandGenerationLogService demandGenerationLogService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private CFinancialYearService financialYearService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    @Qualifier(value="tradeLicenseService")
    private AbstractLicenseService licenseService;
    private int batchSize;

    @Autowired
    public DemandGenerationService(EnvironmentSettings environmentSettings) {
        this.batchSize = environmentSettings.getBatchUpdateSize();
    }

    @Transactional
    public DemandGenerationLog getDemandGenerationLog(CFinancialYear financialYear) {
        DemandGenerationLog demandGenerationLog = this.demandGenerationLogService.getDemandGenerationLogByInstallmentYear(financialYear.getFinYearRange());
        if (demandGenerationLog == null) {
            demandGenerationLog = this.createDemandGenerationLog(financialYear);
        }
        return demandGenerationLog;
    }

    @Transactional
    public DemandGenerationLog createDemandGenerationLog(CFinancialYear financialYear) {
        DemandGenerationLog previousDemandGenLog = this.demandGenerationLogService.getPreviousInstallmentDemandGenerationLog(financialYear.getFinYearRange());
        if (previousDemandGenLog != null && previousDemandGenLog.getDemandGenerationStatus().equals((Object)ProcessStatus.INCOMPLETE)) {
            throw new ApplicationRuntimeException("TL-008");
        }
        if (!this.installmentYearValidForDemandGeneration(financialYear)) {
            throw new ApplicationRuntimeException("TL-006");
        }
        return this.demandGenerationLogService.createDemandGenerationLog(financialYear.getFinYearRange());
    }

    @Transactional
    public DemandGenerationLog updateDemandGenerationLog(CFinancialYear financialYear) {
        return this.demandGenerationLogService.completeDemandGenerationLog(this.demandGenerationLogService.getDemandGenerationLogByInstallmentYear(financialYear.getFinYearRange()));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, timeout=7200)
    public List<DemandGenerationLogDetail> generateDemand(DemandGenerationRequest demandGenerationRequest) {
        DemandGenerationLog demandGenerationLog = this.demandGenerationLogService.getDemandGenerationLogByInstallmentYear(demandGenerationRequest.getInstallmentYear());
        ArrayList<DemandGenerationLogDetail> demandGenerationLogDetails = new ArrayList<DemandGenerationLogDetail>();
        if (demandGenerationLog != null) {
            Module module = this.moduleService.getModuleByName("Trade License");
            CFinancialYear financialYear = this.financialYearService.getFinacialYearByYearRange(demandGenerationRequest.getInstallmentYear());
            Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, financialYear.getStartingDate());
            int batchUpdateCount = 0;
            for (Long licenseId : demandGenerationRequest.getLicenseIds()) {
                Object license = this.licenseService.getLicenseById(licenseId);
                DemandGenerationLogDetail demandGenerationLogDetail = this.demandGenerationLogService.createOrGetDemandGenerationLogDetail(demandGenerationLog, (License)((Object)license));
                try {
                    if (!((License)((Object)license)).getIsActive()) {
                        demandGenerationLogDetail.setDetail(LICENSE_NOT_ACTIVE);
                    } else if (!installment.equals((Object)((License)((Object)license)).getCurrentDemand().getEgInstallmentMaster())) {
                        this.licenseService.raiseDemand(license, module, installment);
                        demandGenerationLogDetail.setDetail(SUCCESSFUL);
                    } else {
                        demandGenerationLogDetail.setDetail(DEMAND_EXIST);
                    }
                    demandGenerationLogDetail.setStatus(ProcessStatus.COMPLETED);
                }
                catch (RuntimeException e) {
                    LOGGER.warn(ERRORMSG, (Object)((License)((Object)license)).getLicenseNumber(), (Object)e);
                    this.demandGenerationLogService.updateDemandGenerationLogDetailOnException(demandGenerationLog, demandGenerationLogDetail, e);
                }
                PersistenceUtils.flushBatchUpdate((EntityManager)this.entityManager, (int)(++batchUpdateCount), (int)this.batchSize);
                demandGenerationLogDetails.add(demandGenerationLogDetail);
            }
        }
        return demandGenerationLogDetails;
    }

    @Transactional
    public boolean generateLicenseDemand(Long licenseId) {
        boolean generationSuccess = true;
        try {
            Object license = this.licenseService.getLicenseById(licenseId);
            this.licenseService.raiseDemand(license, this.licenseService.getModuleName(), this.installmentDao.getInsatllmentByModuleForGivenDate(this.licenseService.getModuleName(), new DateTime().withMonthOfYear(4).withDayOfMonth(1).toDate()));
        }
        catch (ValidationException e) {
            LOGGER.warn(ERRORMSG, (Throwable)e);
            generationSuccess = false;
        }
        return generationSuccess;
    }

    private boolean installmentYearValidForDemandGeneration(CFinancialYear installmentYear) {
        DateTime currentDate = new DateTime();
        DateTime startOfCalenderDate = new DateTime((Object)installmentYear.getStartingDate()).monthOfYear().withMinimumValue().dayOfMonth().withMinimumValue().withTimeAtStartOfDay();
        DateTime endOfCalenderDate = startOfCalenderDate.monthOfYear().withMaximumValue().dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue();
        return currentDate.isAfter((ReadableInstant)startOfCalenderDate) && currentDate.isBefore((ReadableInstant)endOfCalenderDate);
    }
}

