/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.List;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.tl.entity.contracts.DCBReportSearchRequest;
import org.egov.tl.entity.view.DCBReportResult;
import org.egov.tl.repository.DCBReportRepository;
import org.egov.tl.repository.specs.DCBReportSpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DCBReportService {
    @Autowired
    private DCBReportRepository dCBReportRepository;
    @Autowired
    private ReportService reportService;

    @ReadOnly
    public Page<DCBReportResult> pagedDCBRecords(DCBReportSearchRequest searchRequest) {
        PageRequest pageable = new PageRequest(searchRequest.pageNumber(), searchRequest.pageSize(), searchRequest.orderDir(), new String[]{searchRequest.orderBy()});
        return this.dCBReportRepository.findAll(DCBReportSpec.dCBReportSpecification(searchRequest), (Pageable)pageable);
    }

    @ReadOnly
    public List<DCBReportResult> getDCBRecords(DCBReportSearchRequest reportCriteria) {
        return this.dCBReportRepository.findAll(DCBReportSpec.dCBReportSpecification(reportCriteria));
    }

    @ReadOnly
    public ReportOutput generateDCBReport(DCBReportSearchRequest reportCriteria) {
        ReportRequest reportRequest = new ReportRequest("tl_dcb_report", this.getDCBRecords(reportCriteria));
        reportRequest.setReportFormat(reportCriteria.getPrintFormat());
        return this.reportService.createReport(reportRequest);
    }

    @ReadOnly
    public Object[] dcbGrandTotal(DCBReportSearchRequest searchRequest) {
        return this.dCBReportRepository.findByBaseRegisterRequest(searchRequest);
    }
}

