/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.dao.DemandGenericHibDao;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseDemand;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.LicenseSubCategoryDetails;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.entity.enums.ApplicationType;
import org.egov.tl.entity.enums.RateTypeEnum;
import org.egov.tl.repository.LicenseDocumentTypeRepository;
import org.egov.tl.repository.LicenseRepository;
import org.egov.tl.service.DocumentTypeService;
import org.egov.tl.service.FeeMatrixService;
import org.egov.tl.service.FeeTypeService;
import org.egov.tl.service.LicenseAppTypeService;
import org.egov.tl.service.LicenseCitizenPortalService;
import org.egov.tl.service.LicenseStatusService;
import org.egov.tl.service.NatureOfBusinessService;
import org.egov.tl.service.PenaltyRatesService;
import org.egov.tl.service.SubCategoryDetailsService;
import org.egov.tl.service.TradeLicenseSmsAndEmailService;
import org.egov.tl.service.ValidityService;
import org.egov.tl.service.es.LicenseApplicationIndexService;
import org.egov.tl.utils.LicenseNumberUtils;
import org.egov.tl.utils.LicenseUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class AbstractLicenseService<T extends License> {
    private static final String ARREAR = "arrear";
    private static final String CURRENT = "current";
    private static final String PENALTY = "penalty";
    private static final String ERROR_KEY_WF_INITIATOR_NOT_DEFINED = "error.wf.initiator.not.defined";
    private static final String ERROR_KEY_WF_NEXT_OWNER_NOT_FOUND = "error.wf.next.owner.not.found";
    @Autowired
    @Qualifier(value="entityQueryService")
    protected PersistenceService entityQueryService;
    @Autowired
    protected InstallmentHibDao installmentDao;
    @Autowired
    protected LicenseNumberUtils licenseNumberUtils;
    @Autowired
    protected DocumentTypeService documentTypeService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    protected FileStoreService fileStoreService;
    @Autowired
    protected FeeMatrixService<License> feeMatrixService;
    @Autowired
    protected LicenseDocumentTypeRepository licenseDocumentTypeRepository;
    @Autowired
    protected LicenseApplicationIndexService licenseApplicationIndexService;
    @Autowired
    protected SecurityUtils securityUtils;
    @Autowired
    protected DemandGenericHibDao demandGenericDao;
    @Autowired
    protected ValidityService validityService;
    protected SimpleWorkflowService<T> licenseWorkflowService;
    @Autowired
    protected LicenseRepository licenseRepository;
    @Autowired
    protected LicenseStatusService licenseStatusService;
    @Autowired
    protected LicenseAppTypeService licenseAppTypeService;
    @Autowired
    protected PositionMasterService positionMasterService;
    @Autowired
    protected NatureOfBusinessService natureOfBusinessService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private PenaltyRatesService penaltyRatesService;
    @Autowired
    private LicenseUtils licenseUtils;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private TradeLicenseSmsAndEmailService tradeLicenseSmsAndEmailService;
    @Autowired
    private SubCategoryDetailsService subCategoryDetailsService;
    @Autowired
    private FeeTypeService feeTypeService;
    @Autowired
    private LicenseCitizenPortalService licenseCitizenPortalService;

    protected abstract LicenseAppType getLicenseApplicationTypeForRenew();

    protected abstract LicenseAppType getLicenseApplicationType();

    protected abstract Module getModuleName();

    protected abstract NatureOfBusiness getNatureOfBusiness();

    protected abstract void sendEmailAndSMS(T var1, String var2);

    protected abstract LicenseAppType getClosureLicenseApplicationType();

    public void setLicenseWorkflowService(SimpleWorkflowService<T> licenseWorkflowService) {
        this.licenseWorkflowService = licenseWorkflowService;
    }

    public T getLicenseById(Long id) {
        return (T)((Object)((License)((Object)this.licenseRepository.findOne(id))));
    }

    private List<Assignment> getAssignments() {
        Designation nextAssigneeDesig;
        Department nextAssigneeDept = this.departmentService.getDepartmentByCode("PHS");
        List<Assignment> assignmentList = this.getAssignmentsForDeptAndDesignation(nextAssigneeDept, nextAssigneeDesig = this.designationService.getDesignationByName("Junior Assistant"));
        if (assignmentList.isEmpty()) {
            nextAssigneeDesig = Optional.ofNullable(this.designationService.getDesignationByName("Senior Assistant")).orElseThrow(() -> new ValidationException(ERROR_KEY_WF_INITIATOR_NOT_DEFINED, ERROR_KEY_WF_INITIATOR_NOT_DEFINED, new String[0]));
            assignmentList = this.getAssignmentsForDeptAndDesignation(nextAssigneeDept, nextAssigneeDesig);
        }
        if (assignmentList.isEmpty()) {
            nextAssigneeDesig = Optional.ofNullable(this.designationService.getDesignationByName("Revenue Clerk")).orElseThrow(() -> new ValidationException(ERROR_KEY_WF_INITIATOR_NOT_DEFINED, ERROR_KEY_WF_INITIATOR_NOT_DEFINED, new String[0]));
            assignmentList = this.getAssignmentsForDeptAndDesignation(nextAssigneeDept, nextAssigneeDesig);
        }
        return assignmentList;
    }

    private List<Assignment> getAssignmentsForDeptAndDesignation(Department nextAssigneeDept, Designation nextAssigneeDesig) {
        return this.assignmentService.findAllAssignmentsByDeptDesigAndDates(nextAssigneeDept.getId(), nextAssigneeDesig.getId(), new Date());
    }

    public BigDecimal raiseNewDemand(T license) {
        LicenseDemand ld = new LicenseDemand();
        Module moduleName = this.getModuleName();
        BigDecimal totalAmount = BigDecimal.ZERO;
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(moduleName, ((License)((Object)license)).getCommencementDate());
        ld.setIsHistory("N");
        ld.setEgInstallmentMaster(installment);
        ld.setLicense((License)((Object)license));
        ld.setIsLateRenewal('0');
        ld.setCreateDate(new Date());
        ld.setModifiedDate(new Date());
        List<FeeMatrixDetail> feeMatrixDetails = this.feeMatrixService.getLicenseFeeDetails((License)((Object)license), ((License)((Object)license)).getCommencementDate());
        for (FeeMatrixDetail fm : feeMatrixDetails) {
            EgDemandReasonMaster reasonMaster = this.demandGenericDao.getDemandReasonMasterByCode(fm.getFeeMatrix().getFeeType().getName(), moduleName);
            EgDemandReason reason = this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(reasonMaster, installment, moduleName);
            if (fm.getFeeMatrix().getFeeType().getName().contains("Late") || reason == null) continue;
            BigDecimal tradeAmt = this.calculateAmountByRateType((License)((Object)license), fm);
            ld.getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)tradeAmt, (EgDemandReason)reason, (BigDecimal)BigDecimal.ZERO));
            totalAmount = totalAmount.add(tradeAmt);
        }
        ld.setBaseDemand(totalAmount);
        ((License)((Object)license)).setLicenseDemand(ld);
        return totalAmount;
    }

    private BigDecimal calculateAmountByRateType(License license, FeeMatrixDetail feeMatrixDetail) {
        Long feeTypeId = this.feeTypeService.findByName("License Fee").getId();
        LicenseSubCategoryDetails licenseSubCategoryDetails = this.subCategoryDetailsService.getSubcategoryDetailBySubcategoryAndFeeType(license.getTradeName().getId(), feeTypeId);
        BigDecimal amt = BigDecimal.ZERO;
        if (licenseSubCategoryDetails != null) {
            if (RateTypeEnum.Flat_by_Range.equals((Object)licenseSubCategoryDetails.getRateType())) {
                amt = feeMatrixDetail.getAmount();
            } else if (RateTypeEnum.Percentage.equals((Object)licenseSubCategoryDetails.getRateType())) {
                amt = license.getTradeArea_weight().multiply(feeMatrixDetail.getAmount()).divide(new BigDecimal(100));
            } else if (RateTypeEnum.Unit_by_Range.equals((Object)licenseSubCategoryDetails.getRateType())) {
                amt = license.getTradeArea_weight().multiply(feeMatrixDetail.getAmount());
            }
        }
        return amt;
    }

    public License updateDemandForChangeTradeArea(T license) {
        LicenseDemand licenseDemand = ((License)((Object)license)).getLicenseDemand();
        Date date = new Date();
        Set demandDetails = licenseDemand.getEgDemandDetails();
        Date licenseDate = ((License)((Object)license)).isNewApplication() ? ((License)((Object)license)).getCommencementDate() : ((License)((Object)license)).getLicenseDemand().getEgInstallmentMaster().getFromDate();
        List<FeeMatrixDetail> feeList = this.feeMatrixService.getLicenseFeeDetails((License)((Object)license), licenseDate);
        for (EgDemandDetails dmd : demandDetails) {
            for (FeeMatrixDetail fm : feeList) {
                if (!licenseDemand.getEgInstallmentMaster().equals((Object)dmd.getEgDemandReason().getEgInstallmentMaster()) || !dmd.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase(fm.getFeeMatrix().getFeeType().getName())) continue;
                BigDecimal tradeAmt = this.calculateAmountByRateType((License)((Object)license), fm);
                dmd.setAmount(tradeAmt);
                dmd.setModifiedDate(date);
            }
        }
        licenseDemand.recalculateBaseDemand();
        return license;
    }

    public void recalculateDemand(List<FeeMatrixDetail> feeList, T license) {
        LicenseDemand licenseDemand = ((License)((Object)license)).getCurrentDemand();
        for (EgDemandDetails dmd : licenseDemand.getEgDemandDetails()) {
            for (FeeMatrixDetail fm : feeList) {
                if (!licenseDemand.getEgInstallmentMaster().equals((Object)dmd.getEgDemandReason().getEgInstallmentMaster()) || !dmd.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase(fm.getFeeMatrix().getFeeType().getName())) continue;
                BigDecimal tradeAmt = this.calculateAmountByRateType((License)((Object)license), fm);
                dmd.setAmount(tradeAmt.setScale(0, RoundingMode.HALF_UP));
                dmd.setAmtCollected(BigDecimal.ZERO);
            }
        }
        licenseDemand.recalculateBaseDemand();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void raiseDemand(T licenze, Module module, Installment installment) {
        License license = (License)((Object)this.licenseRepository.findOne(((License)((Object)licenze)).getId()));
        Map<EgDemandReason, EgDemandDetails> reasonWiseDemandDetails = this.getReasonWiseDemandDetails(license.getLicenseDemand());
        for (FeeMatrixDetail feeMatrixDetail : this.feeMatrixService.getLicenseFeeDetails(license, installment.getFromDate())) {
            String feeType = feeMatrixDetail.getFeeMatrix().getFeeType().getName();
            if (feeType.contains("Late")) continue;
            EgDemandReason reason = this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(this.demandGenericDao.getDemandReasonMasterByCode(feeType, module), installment, module);
            if (reason == null) {
                throw new ValidationException("TL-007", "Demand reason missing for " + feeType, new String[0]);
            }
            EgDemandDetails licenseDemandDetail = reasonWiseDemandDetails.get(reason);
            BigDecimal tradeAmt = this.calculateAmountByRateType(license, feeMatrixDetail);
            if (licenseDemandDetail == null) {
                license.getLicenseDemand().getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)tradeAmt, (EgDemandReason)reason, (BigDecimal)BigDecimal.ZERO));
            } else if (licenseDemandDetail.getBalance().compareTo(BigDecimal.ZERO) != 0) {
                licenseDemandDetail.setAmount(tradeAmt);
            }
            if (!license.getCurrentDemand().getEgInstallmentMaster().getInstallmentYear().before(installment.getInstallmentYear())) continue;
            license.getLicenseDemand().setEgInstallmentMaster(installment);
        }
        license.getLicenseDemand().recalculateBaseDemand();
        this.licenseRepository.save((Object)license);
    }

    public Map<EgDemandReason, EgDemandDetails> getReasonWiseDemandDetails(EgDemand currentDemand) {
        HashMap<EgDemandReason, EgDemandDetails> reasonWiseDemandDetails = new HashMap<EgDemandReason, EgDemandDetails>();
        if (currentDemand != null) {
            for (EgDemandDetails demandDetail : currentDemand.getEgDemandDetails()) {
                if (!"License Fee".equals(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
                reasonWiseDemandDetails.put(demandDetail.getEgDemandReason(), demandDetail);
            }
        }
        return reasonWiseDemandDetails;
    }

    public void transitionWorkFlow(T license, WorkflowBean workflowBean) {
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        if ("Reject".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            Position initiatorPosition = (Position)license.getCurrentState().getInitiatorPosition();
            List userPositions = this.positionMasterService.getPositionsForEmployee(this.securityUtils.getCurrentUser().getId());
            if (userPositions.contains(initiatorPosition) && ("Rejected".equals(license.getState().getValue()) || "License Created".equals(license.getState().getValue()))) {
                license.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            } else {
                String stateValue = "Rejected";
                license.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)initiatorPosition).withNextAction("Sanitary inspector Approve pending");
            }
        } else if ("Generate Certificate".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            WorkFlowMatrix wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), license.getCurrentState().getValue(), null);
            license.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(license.getCurrentState().getInitiatorPosition()).withNextAction(wfmatrix.getNextAction());
        } else if (!license.hasState()) {
            List assignments = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(user.getId());
            if (assignments.isEmpty()) {
                throw new ValidationException(ERROR_KEY_WF_INITIATOR_NOT_DEFINED, "No officials assigned to process this application", new String[0]);
            }
            Position wfInitiator = ((Assignment)assignments.get(0)).getPosition();
            WorkFlowMatrix wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState(), null);
            license.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(((License)((Object)license)).isReNewApplication() ? "Renewal of Trade License" : "New Trade License").withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)wfInitiator).withNextAction(wfmatrix.getNextAction()).withInitiator((OwnerGroup)wfInitiator);
            ((License)((Object)license)).setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("TRADELICENSE", "CREATED"));
        } else if ("Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            Position commissioner = this.getCommissionerPosition();
            if ("APPROVED".equals(((License)((Object)license)).getEgwStatus().getCode())) {
                if (this.licenseUtils.isDigitalSignEnabled().booleanValue()) {
                    license.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withStateValue("Digital sign-Commissioner Approved no collection").withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)commissioner).withNextAction("Digital Signature Pending");
                } else {
                    license.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withStateValue("Commissioner approved no collection").withDateInfo(currentDate.toDate()).withOwner(license.getCurrentState().getInitiatorPosition()).withNextAction("Certificate generation pending");
                }
            } else if ("SECONDLVLCOLLECTIONPENDING".equals(((License)((Object)license)).getEgwStatus().getCode())) {
                WorkFlowMatrix wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), license.getCurrentState().getValue(), null);
                license.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)commissioner).withNextAction(wfmatrix.getNextAction());
            }
        } else {
            Position pos = null;
            if (workflowBean.getApproverPositionId() != null && workflowBean.getApproverPositionId() > 0L) {
                pos = this.positionMasterService.getPositionById(workflowBean.getApproverPositionId());
            }
            WorkFlowMatrix wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), license.getCurrentState().getValue(), null);
            license.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction());
        }
    }

    private Position getCommissionerPosition() {
        return this.positionMasterService.getPositionsForEmployee(this.securityUtils.getCurrentUser().getId()).stream().filter(position -> position.getDeptDesig().getDesignation().getName().equals("Commissioner")).findFirst().orElseThrow(() -> new ValidationException("error.wf.comm.pos.not.found", "You are not authorized approve this application", new String[0]));
    }

    public WorkFlowMatrix getWorkFlowMatrixApi(License license, WorkflowBean workflowBean) {
        return this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState(), null);
    }

    public void processAndStoreDocument(License license) {
        license.getDocuments().forEach(document -> {
            document.setType((LicenseDocumentType)((Object)((Object)this.licenseDocumentTypeRepository.findOne(document.getType().getId()))));
            if (!document.getUploads().isEmpty() && !document.getUploadsFileName().isEmpty()) {
                int fileCount = 0;
                for (File file : document.getUploads()) {
                    FileStoreMapper fileStore = this.fileStoreService.store(file, document.getUploadsFileName().get(fileCount), document.getUploadsContentType().get(fileCount++), "EGTL");
                    document.getFiles().add(fileStore);
                }
                document.setEnclosed(true);
                document.setDocDate(new Date());
            } else if (document.getType().isMandatory() && document.getFiles().isEmpty()) {
                document.getFiles().clear();
                throw new ValidationException("TL-004", "TL-004", new String[]{document.getType().getName()});
            }
            document.setLicense(license);
        });
    }

    public List<LicenseDocumentType> getDocumentTypesByApplicationType(ApplicationType applicationType) {
        return this.documentTypeService.getDocumentTypesByApplicationType(applicationType);
    }

    public List<NatureOfBusiness> getAllNatureOfBusinesses() {
        return this.natureOfBusinessService.getNatureOfBusinesses();
    }

    public T getLicenseByLicenseNumber(String licenseNumber) {
        return (T)((Object)this.licenseRepository.findByLicenseNumber(licenseNumber));
    }

    public T getLicenseByApplicationNumber(String applicationNumber) {
        return (T)((Object)this.licenseRepository.findByApplicationNumber(applicationNumber));
    }

    public List<Installment> getLastFiveYearInstallmentsForLicense() {
        List installmentList = this.installmentDao.fetchInstallments(this.getModuleName(), new Date(), 6);
        Collections.reverse(installmentList);
        return installmentList;
    }

    public Map<String, Map<String, BigDecimal>> getOutstandingFee(T license) {
        HashMap<String, Map<String, BigDecimal>> outstandingFee = new HashMap<String, Map<String, BigDecimal>>();
        LicenseDemand licenseDemand = ((License)((Object)license)).getCurrentDemand();
        for (EgDemandDetails demandDetail : licenseDemand.getEgDemandDetails()) {
            Map<String, BigDecimal> feeByTypes;
            String demandReason = demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster();
            Installment installmentYear = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            if (outstandingFee.containsKey(demandReason)) {
                feeByTypes = (Map)outstandingFee.get(demandReason);
            } else {
                feeByTypes = new HashMap();
                feeByTypes.put(ARREAR, BigDecimal.ZERO);
                feeByTypes.put(CURRENT, BigDecimal.ZERO);
            }
            BigDecimal demandAmount = demandDetail.getAmount().subtract(demandDetail.getAmtCollected());
            if (installmentYear.equals((Object)licenseDemand.getEgInstallmentMaster())) {
                feeByTypes.put(CURRENT, demandAmount);
            } else {
                feeByTypes.put(ARREAR, ((BigDecimal)feeByTypes.get(ARREAR)).add(demandAmount));
            }
            outstandingFee.put(demandReason, feeByTypes);
        }
        return outstandingFee;
    }

    public Map<String, Map<String, BigDecimal>> getOutstandingFeeForDemandNotice(TradeLicense license, Installment currentInstallment, Installment previousInstallment) {
        HashMap<String, Map<String, BigDecimal>> outstandingFee = new HashMap<String, Map<String, BigDecimal>>();
        LicenseDemand licenseDemand = license.getCurrentDemand();
        Date endDateOfPreviousFinancialYear = new DateTime((Object)previousInstallment.getFromDate()).withMonthOfYear(12).withDayOfMonth(31).toDate();
        for (EgDemandDetails demandDetail : licenseDemand.getEgDemandDetails()) {
            Map<String, BigDecimal> feeByTypes;
            String demandReason = demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster();
            Installment installmentYear = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            if (demandReason.equalsIgnoreCase("Penalty")) continue;
            if (outstandingFee.containsKey(demandReason)) {
                feeByTypes = (Map)outstandingFee.get(demandReason);
            } else {
                feeByTypes = new HashMap();
                feeByTypes.put(ARREAR, BigDecimal.ZERO);
                feeByTypes.put(CURRENT, BigDecimal.ZERO);
                feeByTypes.put(PENALTY, BigDecimal.ZERO);
            }
            BigDecimal demandAmount = demandDetail.getAmount().subtract(demandDetail.getAmtCollected());
            if (demandAmount.compareTo(BigDecimal.valueOf(0L)) > 0) {
                if (installmentYear.equals((Object)currentInstallment)) {
                    feeByTypes.put(CURRENT, ((BigDecimal)feeByTypes.get(CURRENT)).add(demandAmount));
                } else {
                    feeByTypes.put(ARREAR, ((BigDecimal)feeByTypes.get(ARREAR)).add(demandAmount));
                    BigDecimal penaltyAmt = this.penaltyRatesService.calculatePenalty(license, installmentYear.getFromDate(), endDateOfPreviousFinancialYear, demandAmount);
                    feeByTypes.put(PENALTY, ((BigDecimal)feeByTypes.get(PENALTY)).add(penaltyAmt));
                }
            }
            outstandingFee.put(demandReason, feeByTypes);
        }
        return outstandingFee;
    }

    @Transactional
    public void save(License license) {
        this.updateDemandForChangeTradeArea(license);
        this.licenseRepository.save((Object)license);
    }

    public BigDecimal calculateFeeAmount(License license) {
        Date licenseDate = license.isNewApplication() ? license.getCommencementDate() : license.getLicenseDemand().getEgInstallmentMaster().getFromDate();
        List<FeeMatrixDetail> feeList = this.feeMatrixService.getLicenseFeeDetails(license, licenseDate);
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (FeeMatrixDetail fm : feeList) {
            BigDecimal tradeAmt = this.calculateAmountByRateType(license, fm);
            totalAmount = totalAmount.add(tradeAmt);
        }
        return totalAmount;
    }

    public BigDecimal recalculateLicenseFee(LicenseDemand licenseDemand) {
        BigDecimal licenseFee = BigDecimal.ZERO;
        for (EgDemandDetails demandDetail : licenseDemand.getEgDemandDetails()) {
            if (!demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().equals("License Fee") || !licenseDemand.getEgInstallmentMaster().equals((Object)demandDetail.getEgDemandReason().getEgInstallmentMaster())) continue;
            licenseFee = licenseFee.add(demandDetail.getAmtCollected());
        }
        return licenseFee;
    }

    @Transactional
    public License saveClosure(T license, WorkflowBean workflowBean) {
        User currentUser = this.securityUtils.getCurrentUser();
        if (license.hasState() && !license.getState().isEnded()) {
            throw new ValidationException("lic.appl.wf.validation", "Cannot initiate Closure process, application under processing", new String[0]);
        }
        Position position = null;
        if (workflowBean.getApproverPositionId() != null) {
            position = this.positionMasterService.getPositionById(workflowBean.getApproverPositionId());
        }
        if (license.getState() == null || license.hasState() && license.getState().isEnded()) {
            WorkFlowMatrix wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), "NEW", null);
            List assignments = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(this.securityUtils.getCurrentUser().getId());
            if (this.securityUtils.currentUserIsEmployee()) {
                Position wfInitiator = null;
                if (license.getState() == null || license.transitionCompleted()) {
                    if (!assignments.isEmpty()) {
                        wfInitiator = ((Assignment)assignments.get(0)).getPosition();
                    } else {
                        throw new ValidationException(ERROR_KEY_WF_NEXT_OWNER_NOT_FOUND, "No employee assigned to process Closure application", new String[]{"Closure"});
                    }
                }
                if (!license.hasState()) {
                    license.transition().start();
                } else {
                    license.transition().startNext();
                }
                license.transition().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask("Closure License").withStateValue(wfmatrix.getNextState()).withDateInfo(new DateTime().toDate()).withOwner((OwnerGroup)position).withNextAction(wfmatrix.getNextAction()).withInitiator((OwnerGroup)wfInitiator).withExtraInfo(((License)((Object)license)).getLicenseAppType().getName());
            } else {
                this.closureWfWithOperator(license);
            }
            if (!this.currentUserIsMeeseva().booleanValue()) {
                ((License)((Object)license)).setApplicationNumber(this.licenseNumberUtils.generateApplicationNumber());
            }
            this.licenseUtils.applicationStatusChange((License)((Object)license), "CREATED");
            ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Acknowledged"));
            ((License)((Object)license)).setLicenseAppType(this.getClosureLicenseApplicationType());
            this.tradeLicenseSmsAndEmailService.sendSMsAndEmailOnClosure((License)((Object)license), workflowBean.getWorkFlowAction());
        }
        this.licenseRepository.save(license);
        if (this.securityUtils.currentUserIsCitizen()) {
            this.licenseCitizenPortalService.onCreate((TradeLicense)((Object)license));
        }
        this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex((License)((Object)license));
        return license;
    }

    @Transactional
    public void cancelLicenseWorkflow(T license, WorkflowBean workflowBean) {
        User currentUser = this.securityUtils.getCurrentUser();
        Position owner = null;
        if (workflowBean.getApproverPositionId() != null) {
            owner = this.positionMasterService.getPositionById(workflowBean.getApproverPositionId());
        }
        WorkFlowMatrix wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState(), null);
        if (workflowBean.getWorkFlowAction() != null && workflowBean.getWorkFlowAction().contains("Reject")) {
            if ("Rejected".equals(license.getState().getValue())) {
                this.licenseUtils.applicationStatusChange((License)((Object)license), "CERTIFICATEGENERATED");
                ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Active"));
                ((License)((Object)license)).setActive(true);
                if (license.getState().getExtraInfo() != null) {
                    ((License)((Object)license)).setLicenseAppType(this.licenseAppTypeService.getLicenseAppTypeByName(license.getState().getExtraInfo()));
                }
                license.transition().end().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(new DateTime().toDate());
            } else {
                this.licenseUtils.applicationStatusChange((License)((Object)license), "CREATED");
                ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Acknowledged"));
                String stateValue = "Rejected";
                license.transition().progressWithStateCopy().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withStateValue("Rejected").withDateInfo(new DateTime().toDate()).withOwner(license.getState().getInitiatorPosition()).withNextAction("SI/SS Approval Pending");
            }
        } else if ("NEW".equals(license.getState().getValue())) {
            WorkFlowMatrix newwfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), "NEW", null);
            license.transition().progressWithStateCopy().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withStateValue(newwfmatrix.getNextState()).withDateInfo(new DateTime().toDate()).withOwner((OwnerGroup)owner).withNextAction(newwfmatrix.getNextAction());
            this.licenseUtils.applicationStatusChange((License)((Object)license), "CREATED");
            ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Acknowledged"));
        } else if ("Revenue Clerk/JA Approved".equals(license.getState().getValue()) || "Rejected".equals(license.getState().getValue())) {
            this.licenseUtils.applicationStatusChange((License)((Object)license), "CREATED");
            ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("UnderWorkflow"));
            license.transition().progressWithStateCopy().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(new DateTime().toDate()).withOwner((OwnerGroup)owner).withNextAction(wfmatrix.getNextAction());
        } else if ("SI/SS Approved".equals(license.getState().getValue())) {
            this.licenseUtils.applicationStatusChange((License)((Object)license), "CANCELLED");
            ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Cancelled"));
            ((License)((Object)license)).setActive(false);
            owner = this.getCommissionerPosition();
            WorkFlowMatrix commWfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), license.getCurrentState().getValue(), null);
            license.transition().end().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withStateValue(commWfmatrix.getNextState()).withDateInfo(new DateTime().toDate()).withOwner((OwnerGroup)owner).withNextAction(commWfmatrix.getNextAction());
            this.tradeLicenseSmsAndEmailService.sendSMsAndEmailOnClosure((License)((Object)license), workflowBean.getWorkFlowAction());
        }
        this.licenseRepository.save(license);
        this.licenseCitizenPortalService.onUpdate((TradeLicense)((Object)license));
        this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex((License)((Object)license));
    }

    private void closureWfWithOperator(T license) {
        Assignment wfAssignment;
        String currentUserRoles = this.securityUtils.getCurrentUser().getRoles().toString();
        String comment = "";
        if (currentUserRoles.contains("CSC Operator")) {
            comment = "CSC Operator Initiated";
        } else if (currentUserRoles.contains("PUBLIC")) {
            comment = "Citizen applied for closure";
        } else if (currentUserRoles.contains("MeeSeva Operator")) {
            comment = "Meeseva Operator Initiated";
        }
        List<Assignment> assignmentList = this.getAssignments();
        if (!assignmentList.isEmpty()) {
            wfAssignment = assignmentList.get(0);
            if (!license.hasState()) {
                license.transition().start();
            } else {
                license.transition().startNext();
            }
        } else {
            throw new ValidationException(ERROR_KEY_WF_INITIATOR_NOT_DEFINED, ERROR_KEY_WF_INITIATOR_NOT_DEFINED, new String[0]);
        }
        license.transition().withSenderName(wfAssignment.getEmployee().getUsername() + "::" + wfAssignment.getEmployee().getName()).withComments(comment).withNatureOfTask("Closure License").withStateValue("NEW").withDateInfo(new Date()).withOwner((OwnerGroup)wfAssignment.getPosition()).withNextAction("SI/SS Approval Pending").withInitiator((OwnerGroup)wfAssignment.getPosition());
        ((License)((Object)license)).setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("TRADELICENSE", "CREATED"));
    }

    public List<Long> getLicenseIdsForDemandGeneration(CFinancialYear financialYear) {
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(this.getModuleName(), financialYear.getStartingDate());
        return this.licenseRepository.findLicenseIdsForDemandGeneration(installment.getFromDate());
    }

    public License closureWithMeeseva(T license, WorkflowBean wfBean) {
        return this.saveClosure(license, wfBean);
    }

    public Boolean currentUserIsMeeseva() {
        return this.securityUtils.getCurrentUser().hasRole("MeeSeva Operator");
    }

    @Transactional
    public void digitalSignTransition(String applicationNumber) {
        User user = this.securityUtils.getCurrentUser();
        if (StringUtils.isNotBlank((CharSequence)applicationNumber)) {
            License license = this.licenseRepository.findByApplicationNumber(applicationNumber);
            DateTime currentDate = new DateTime();
            WorkFlowMatrix wfmatrix = (license = this.licenseUtils.applicationStatusChange(license, "APPROVED")).isReNewApplication() ? this.licenseWorkflowService.getWfMatrix("TradeLicense", null, null, "RENEWTRADELICENSE", "Digital signed", null) : this.licenseWorkflowService.getWfMatrix("TradeLicense", null, null, "NEWTRADELICENSE", "Digital signed", null);
            license.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments("Digital signed").withStateValue(wfmatrix.getCurrentState()).withDateInfo(currentDate.toDate()).withOwner(license.getCurrentState().getInitiatorPosition()).withNextAction(wfmatrix.getCurrentStatus());
            this.licenseRepository.save((Object)license);
            this.tradeLicenseSmsAndEmailService.sendSMsAndEmailOnDigitalSign(license);
            this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex(license);
        }
    }
}

