/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.repository.specs;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.egov.tl.entity.License;
import org.egov.tl.entity.contracts.SearchForm;
import org.springframework.data.jpa.domain.Specification;

public final class SearchTradeSpec {
    private SearchTradeSpec() {
    }

    public static Specification<License> searchTrade(SearchForm searchForm) {
        return (root, query, builder) -> {
            Predicate predicate = builder.conjunction();
            if (searchForm.getLicenseNumber() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("licenseNumber"), (Object)searchForm.getLicenseNumber()));
            }
            if (searchForm.getApplicationNumber() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("applicationNumber"), (Object)searchForm.getApplicationNumber()));
            }
            if (searchForm.getOldLicenseNumber() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("oldLicenseNumber"), (Object)searchForm.getOldLicenseNumber()));
            }
            if (searchForm.getCategoryId() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("category").get("id"), (Object)searchForm.getCategoryId()));
            }
            if (searchForm.getSubCategoryId() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("tradeName").get("id"), (Object)searchForm.getSubCategoryId()));
            }
            if (searchForm.getTradeTitle() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("nameOfEstablishment"), (Object)searchForm.getTradeTitle()));
            }
            if (searchForm.getStatusId() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("status").get("id"), (Object)searchForm.getStatusId()));
            }
            if (searchForm.getTradeOwnerName() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("licensee").get("applicantName"), (Object)searchForm.getTradeOwnerName()));
            }
            if (searchForm.getPropertyAssessmentNo() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("assessmentNo"), (Object)searchForm.getPropertyAssessmentNo()));
            }
            if (searchForm.getMobileNo() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("licensee").get("mobilePhoneNumber"), (Object)searchForm.getMobileNo()));
            }
            if (searchForm.getInactive() != null && searchForm.getInactive().equals(Boolean.TRUE)) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("isActive"), (Object)false));
            }
            predicate.getExpressions().add(builder.isNotNull((Expression)root.get("applicationNumber")));
            return predicate;
        };
    }
}

