/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.repository;

import java.util.Date;
import java.util.List;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.License;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface LicenseRepository
extends JpaRepository<License, Long> {
    public License findByOldLicenseNumber(String var1);

    public License findByOldLicenseNumberAndIdIsNot(String var1, Long var2);

    public License findByLicenseNumber(String var1);

    public License findByApplicationNumber(String var1);

    public List<License> findByIsActiveTrue();

    public List<License> findByNatureOfBusinessName(String var1);

    @Query(value="select l.applicationNumber from License l where upper(l.applicationNumber) like upper('%'||:applicationNumber||'%')")
    public List<String> findAllApplicationNumberLike(@Param(value="applicationNumber") String var1);

    @Query(value="select l.licenseNumber from License l where upper(l.licenseNumber) like upper('%'||:licenseNumber||'%')")
    public List<String> findAllLicenseNumberLike(@Param(value="licenseNumber") String var1);

    @Query(value="select l.oldLicenseNumber from License l where upper(l.oldLicenseNumber) like upper('%'||:oldLicenseNumber||'%')")
    public List<String> findAllOldLicenseNumberLike(@Param(value="oldLicenseNumber") String var1);

    @Query(value="select l.nameOfEstablishment from License l where upper(l.nameOfEstablishment) like upper('%'||:nameOfEstablishment||'%')")
    public List<String> findAllNameOfEstablishmentLike(@Param(value="nameOfEstablishment") String var1);

    @Query(value="select l.licensee.applicantName from License l where upper(l.licensee.applicantName) like upper('%'||:applicantName||'%')")
    public List<String> findAllApplicantNameLike(@Param(value="applicantName") String var1);

    @Query(value="select l.assessmentNo from License l where upper(l.assessmentNo) like upper('%'||:assessmentNo||'%')")
    public List<String> findAllAssessmentNoLike(@Param(value="assessmentNo") String var1);

    @Query(value="select l.licensee.mobilePhoneNumber from License l where l.licensee.mobilePhoneNumber like '%'||:mobilePhoneNumber||'%'")
    public List<String> findAllMobilePhoneNumberLike(@Param(value="mobilePhoneNumber") String var1);

    @Query(value="select l.id from org.egov.tl.entity.License l where l.natureOfBusiness.name='Permanent' and l.status.name='Active' and l.licenseDemand.egInstallmentMaster.fromDate < :installmentFromDate ")
    public List<Long> findLicenseIdsForDemandGeneration(@Param(value="installmentFromDate") Date var1);

    public List<License> findByStateNextActionAndStateOwnerPositionIn(String var1, List<Position> var2);
}

