/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.egov.infra.persistence.utils.Page;
import org.egov.tl.entity.contracts.InstallmentWiseDCBRequest;
import org.egov.tl.entity.view.InstallmentWiseDCB;
import org.egov.tl.repository.InstallmentwiseDCBReportRepositoryCustom;
import org.springframework.data.domain.Sort;

public class InstallmentwiseDCBReportRepositoryImpl
implements InstallmentwiseDCBReportRepositoryCustom {
    public static final String ACTIVE = "active";
    public static final String LICENSEID = "licenseid";
    private static final String INSTALLMENT = "installment";
    private static final String CURRENTDEMAND = "currentdemand";
    private static final String LICENSENUMBER = "licensenumber";
    private static final String CURRENTCOLLECTION = "currentcollection";
    private static final String CURRENTBALANCE = "currentbalance";
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<InstallmentWiseDCB> findByInstallmentWiseDCB(InstallmentWiseDCBRequest installmentWiseDCBRequest, Date financialYearStartDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countCriteriaQuery = criteriaBuilder.createQuery(InstallmentWiseDCB.class);
        Root countRoot = countCriteriaQuery.from(InstallmentWiseDCB.class);
        TypedQuery query = this.entityManager.createQuery(this.generateReport(criteriaBuilder, installmentWiseDCBRequest, financialYearStartDate, true));
        countCriteriaQuery.multiselect(new Selection[]{criteriaBuilder.count((Expression)countRoot)}).where(this.predicatecondition(criteriaBuilder, (Root<InstallmentWiseDCB>)countRoot, installmentWiseDCBRequest, financialYearStartDate).toArray(new Predicate[0])).groupBy(new Expression[]{countRoot.get(LICENSEID)});
        TypedQuery countquery = this.entityManager.createQuery(countCriteriaQuery);
        int recordTotal = countquery.getResultList().size();
        return new Page(query, installmentWiseDCBRequest.pageNumber() + 1, installmentWiseDCBRequest.pageSize(), recordTotal);
    }

    @Override
    public List<InstallmentWiseDCB> findInstallmentWiseReport(InstallmentWiseDCBRequest installmentWiseDCBRequest, Date financialYearStartDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        return this.entityManager.createQuery(this.generateReport(criteriaBuilder, installmentWiseDCBRequest, financialYearStartDate, false)).getResultList();
    }

    @Override
    public Object[] findReportTotal(InstallmentWiseDCBRequest installmentWiseDCBRequest, Date financialYearStartDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Object[].class);
        Root root = criteriaQuery.from(InstallmentWiseDCB.class);
        criteriaQuery.multiselect(new Selection[]{criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.lessThan((Expression)root.get(INSTALLMENT), (Comparable)financialYearStartDate), (Expression)root.get(CURRENTDEMAND)).otherwise((Object)0.0)), (Object)0).alias("arreardemand"), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.equal((Expression)root.get(INSTALLMENT), (Object)financialYearStartDate), (Expression)root.get(CURRENTDEMAND)).otherwise((Object)0.0)), (Object)0).alias(CURRENTDEMAND), criteriaBuilder.sum(criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.lessThan((Expression)root.get(INSTALLMENT), (Comparable)financialYearStartDate), (Expression)root.get(CURRENTDEMAND)).otherwise((Object)0.0)), (Object)0), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.equal((Expression)root.get(INSTALLMENT), (Object)financialYearStartDate), (Expression)root.get(CURRENTDEMAND)).otherwise((Object)0.0)), (Object)0)).alias("totalDemand"), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.lessThan((Expression)root.get(INSTALLMENT), (Comparable)financialYearStartDate), (Expression)root.get(CURRENTCOLLECTION)).otherwise((Object)0.0)), (Object)0).alias("arrearcoll"), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.equal((Expression)root.get(INSTALLMENT), (Object)financialYearStartDate), (Expression)root.get(CURRENTCOLLECTION)).otherwise((Object)0.0)), (Object)0).alias(CURRENTCOLLECTION), criteriaBuilder.sum(criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.lessThan((Expression)root.get(INSTALLMENT), (Comparable)financialYearStartDate), (Expression)root.get(CURRENTCOLLECTION)).otherwise((Object)0.0)), (Object)0), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.equal((Expression)root.get(INSTALLMENT), (Object)financialYearStartDate), (Expression)root.get(CURRENTCOLLECTION)).otherwise((Object)0.0)), (Object)0)), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.lessThan((Expression)root.get(INSTALLMENT), (Comparable)financialYearStartDate), (Expression)root.get(CURRENTBALANCE)).otherwise((Object)0.0)), (Object)0).alias("arrearbalance"), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.equal((Expression)root.get(INSTALLMENT), (Object)financialYearStartDate), (Expression)root.get(CURRENTBALANCE)).otherwise((Object)0.0)), (Object)0).alias(CURRENTBALANCE), criteriaBuilder.sum(criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.lessThan((Expression)root.get(INSTALLMENT), (Comparable)financialYearStartDate), (Expression)root.get(CURRENTBALANCE)).otherwise((Object)0.0)), (Object)0), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.equal((Expression)root.get(INSTALLMENT), (Object)financialYearStartDate), (Expression)root.get(CURRENTBALANCE)).otherwise((Object)0.0)), (Object)0))}).where(this.predicatecondition(criteriaBuilder, (Root<InstallmentWiseDCB>)root, installmentWiseDCBRequest, financialYearStartDate).toArray(new Predicate[0]));
        return (Object[])this.entityManager.createQuery(criteriaQuery).getSingleResult();
    }

    public CriteriaQuery<InstallmentWiseDCB> generateReport(CriteriaBuilder criteriaBuilder, InstallmentWiseDCBRequest installmentWiseDCBRequest, Date financialYearStartDate, Boolean fuzzyLogic) {
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(InstallmentWiseDCB.class);
        Root root = criteriaQuery.from(InstallmentWiseDCB.class);
        criteriaQuery.multiselect(new Selection[]{root.get(LICENSEID), root.get(LICENSENUMBER), root.get(ACTIVE), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.equal((Expression)root.get(INSTALLMENT), (Object)financialYearStartDate), (Expression)root.get(CURRENTDEMAND)).otherwise((Object)0.0)), (Object)0).alias(CURRENTDEMAND), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.equal((Expression)root.get(INSTALLMENT), (Object)financialYearStartDate), (Expression)root.get(CURRENTCOLLECTION)).otherwise((Object)0.0)), (Object)0).alias(CURRENTCOLLECTION), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.equal((Expression)root.get(INSTALLMENT), (Object)financialYearStartDate), (Expression)root.get(CURRENTBALANCE)).otherwise((Object)0.0)), (Object)0).alias(CURRENTBALANCE), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.lessThan((Expression)root.get(INSTALLMENT), (Comparable)financialYearStartDate), (Expression)root.get(CURRENTDEMAND)).otherwise((Object)0.0)), (Object)0).alias("arreardemand"), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.lessThan((Expression)root.get(INSTALLMENT), (Comparable)financialYearStartDate), (Expression)root.get(CURRENTCOLLECTION)).otherwise((Object)0.0)), (Object)0).alias("arrearcollection"), criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.selectCase().when((Expression)criteriaBuilder.lessThan((Expression)root.get(INSTALLMENT), (Comparable)financialYearStartDate), (Expression)root.get(CURRENTBALANCE)).otherwise((Object)0.0)), (Object)0).alias("arrearbalance")}).where(this.predicatecondition(criteriaBuilder, (Root<InstallmentWiseDCB>)root, installmentWiseDCBRequest, financialYearStartDate).toArray(new Predicate[0])).groupBy(new Expression[]{root.get(LICENSEID), root.get(LICENSENUMBER), root.get(ACTIVE)});
        if (fuzzyLogic.booleanValue()) {
            if (installmentWiseDCBRequest.orderBy().equals(LICENSENUMBER)) {
                criteriaQuery.orderBy(new Order[]{installmentWiseDCBRequest.orderDir().equals((Object)Sort.Direction.ASC) ? criteriaBuilder.asc((Expression)root.get(installmentWiseDCBRequest.orderBy())) : criteriaBuilder.desc((Expression)root.get(installmentWiseDCBRequest.orderBy()))});
            } else {
                criteriaQuery.orderBy(new Order[]{installmentWiseDCBRequest.orderDir().equals((Object)Sort.Direction.ASC) ? criteriaBuilder.asc(criteriaBuilder.sum((Expression)root.get(installmentWiseDCBRequest.orderBy()))) : criteriaBuilder.desc(criteriaBuilder.sum((Expression)root.get(installmentWiseDCBRequest.orderBy())))});
            }
        }
        return criteriaQuery;
    }

    private List<Predicate> predicatecondition(CriteriaBuilder criteriaBuilder, Root<InstallmentWiseDCB> root, InstallmentWiseDCBRequest installmentWiseDCBRequest, Date financialYearStartDate) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (installmentWiseDCBRequest.getLicensenumber() != null) {
            predicates.add(criteriaBuilder.equal((Expression)root.get(LICENSENUMBER), (Object)installmentWiseDCBRequest.getLicensenumber()));
        }
        if (installmentWiseDCBRequest.getActiveLicense() > 0) {
            predicates.add(criteriaBuilder.equal((Expression)root.get(ACTIVE), (Object)(installmentWiseDCBRequest.getActiveLicense() == 1 ? 1 : 0)));
        }
        predicates.add(criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get(INSTALLMENT), (Object)financialYearStartDate), (Expression)criteriaBuilder.lessThan((Expression)root.get(INSTALLMENT), (Comparable)financialYearStartDate)));
        return predicates;
    }
}

