/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity.contracts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.tl.entity.License;

public class OnlineSearchForm {
    private Long licenseId;
    private String applicationNumber;
    private String licenseNumber;
    private String tradeOwnerName;
    private String propertyAssessmentNo;
    private String mobileNo;
    private List<String> actions = new ArrayList<String>();
    private BigDecimal arrDmd;
    private BigDecimal currDmd;
    private BigDecimal totColl;
    private String status;

    public OnlineSearchForm() {
    }

    public OnlineSearchForm(License license, BigDecimal[] dmdColl) {
        this.setLicenseId(license.getId());
        this.setApplicationNumber(license.getApplicationNumber());
        this.setLicenseNumber(license.getLicenseNumber());
        this.setTradeOwnerName(license.getLicensee().getApplicantName());
        this.setMobileNo(license.getLicensee().getMobilePhoneNumber());
        this.setStatus(license.getStatus().getName());
        this.setPropertyAssessmentNo(license.getAssessmentNo() != null ? license.getAssessmentNo() : "");
        this.setArrDmd(dmdColl[0]);
        this.setCurrDmd(dmdColl[1]);
        this.setTotColl(dmdColl[2]);
        if (license.canCollectLicenseFee() || license.canCollectFee()) {
            this.actions.add("Payment");
        }
        if (license.getIsActive()) {
            this.actions.add("View DCB");
        }
        if (license.isReadyForRenewal()) {
            this.actions.add("Renew License");
        }
        if (license.isClosureApplicable()) {
            this.actions.add("Closure");
        }
        if (license.isStatusActive() && !license.isLegacy()) {
            this.actions.add("Print Certificate");
        }
        if (!"Closure".equals(license.getLicenseAppType().getName()) && license.getStatus().getStatusCode().equals("UWF")) {
            this.actions.add("Print Provisional Certificate");
        }
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public String getTradeOwnerName() {
        return this.tradeOwnerName;
    }

    public void setTradeOwnerName(String tradeOwnerName) {
        this.tradeOwnerName = tradeOwnerName;
    }

    public String getPropertyAssessmentNo() {
        return this.propertyAssessmentNo;
    }

    public void setPropertyAssessmentNo(String propertyAssessmentNo) {
        this.propertyAssessmentNo = propertyAssessmentNo;
    }

    public String getMobileNo() {
        return this.mobileNo;
    }

    public void setMobileNo(String mobileNo) {
        this.mobileNo = mobileNo;
    }

    public Long getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(Long licenseId) {
        this.licenseId = licenseId;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public BigDecimal getArrDmd() {
        return this.arrDmd;
    }

    public void setArrDmd(BigDecimal arrDmd) {
        this.arrDmd = arrDmd;
    }

    public BigDecimal getCurrDmd() {
        return this.currDmd;
    }

    public void setCurrDmd(BigDecimal currDmd) {
        this.currDmd = currDmd;
    }

    public BigDecimal getTotColl() {
        return this.totColl;
    }

    public void setTotColl(BigDecimal totColl) {
        this.totColl = totColl;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

