/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.tl.entity.License;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="egtl_trade_license")
@Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
public class TradeLicense
extends License {
    private static final long serialVersionUID = 986289058758315223L;
    @Transient
    private List<Integer> financialyear = new ArrayList<Integer>();
    @Transient
    private List<Integer> legacyInstallmentwiseFees = new ArrayList<Integer>();
    @Transient
    private List<Boolean> legacyFeePayStatus = new ArrayList<Boolean>();
    @Transient
    private MultipartFile[] files;

    @Override
    public String getStateDetails() {
        StringBuilder details = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.getLicenseNumber())) {
            details.append("Trade License Number").append(this.getLicenseNumber()).append(" and ");
        }
        details.append("App No. ").append(this.applicationNumber).append(" dated ").append(DateUtils.toDefaultDateFormat((Date)this.applicationDate));
        if (StringUtils.isNotBlank((CharSequence)this.getState().getComments())) {
            details.append("<br/> Remarks : ").append(this.getState().getComments());
        }
        return details.toString();
    }

    public String myLinkId() {
        if ("Closure License".equals(this.getState().getNatureOfTask())) {
            return "/tl/viewtradelicense/viewTradeLicense-closure.action?model.id=" + this.id;
        }
        return "/tl/newtradelicense/newTradeLicense-showForApproval.action?model.id=" + this.id;
    }

    public List<Integer> getFinancialyear() {
        return this.financialyear;
    }

    public void setFinancialyear(List<Integer> financialyear) {
        this.financialyear = financialyear;
    }

    public List<Integer> getLegacyInstallmentwiseFees() {
        return this.legacyInstallmentwiseFees;
    }

    public void setLegacyInstallmentwiseFees(List<Integer> legacyInstallmentwiseFees) {
        this.legacyInstallmentwiseFees = legacyInstallmentwiseFees;
    }

    public List<Boolean> getLegacyFeePayStatus() {
        return this.legacyFeePayStatus;
    }

    public void setLegacyFeePayStatus(List<Boolean> legacyFeePayStatus) {
        this.legacyFeePayStatus = legacyFeePayStatus;
    }

    public MultipartFile[] getFiles() {
        return this.files;
    }

    public void setFiles(MultipartFile[] files) {
        this.files = files;
    }
}

