/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseDocumentType;

@Entity
@Table(name="egtl_document")
@SequenceGenerator(name="seq_egtl_document", sequenceName="seq_egtl_document", allocationSize=1)
public class LicenseDocument
extends AbstractAuditable {
    public static final String SEQ_EGTL_DOCUMENT = "seq_egtl_document";
    private static final long serialVersionUID = 7655384098687964458L;
    @Id
    @GeneratedValue(generator="seq_egtl_document", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @JoinColumn(name="type")
    private LicenseDocumentType type;
    private String description;
    @Temporal(value=TemporalType.DATE)
    private Date docDate;
    private boolean enclosed;
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinTable(name="egtl_document_files", joinColumns={@JoinColumn(name="document")}, inverseJoinColumns={@JoinColumn(name="filestore")})
    private Set<FileStoreMapper> files = new HashSet<FileStoreMapper>();
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="license")
    private License license;
    @Transient
    private List<File> uploads = new ArrayList<File>();
    @Transient
    private List<String> uploadsFileName = new ArrayList<String>();
    @Transient
    private List<String> uploadsContentType = new ArrayList<String>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LicenseDocumentType getType() {
        return this.type;
    }

    public void setType(LicenseDocumentType type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDocDate() {
        return this.docDate;
    }

    public void setDocDate(Date docDate) {
        this.docDate = docDate;
    }

    public boolean isEnclosed() {
        return this.enclosed;
    }

    public void setEnclosed(boolean enclosed) {
        this.enclosed = enclosed;
    }

    public Set<FileStoreMapper> getFiles() {
        return this.files;
    }

    public void setFiles(Set<FileStoreMapper> files) {
        this.files = files;
    }

    public List<File> getUploads() {
        return this.uploads;
    }

    public void setUploads(List<File> uploads) {
        this.uploads = uploads;
    }

    public List<String> getUploadsFileName() {
        return this.uploadsFileName;
    }

    public void setUploadsFileName(List<String> uploadsFileName) {
        this.uploadsFileName = uploadsFileName;
    }

    public List<String> getUploadsContentType() {
        return this.uploadsContentType;
    }

    public void setUploadsContentType(List<String> uploadsContentType) {
        this.uploadsContentType = uploadsContentType;
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }
}

