/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.PersistenceUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.tl.entity.DemandGenerationLog;
import org.egov.tl.entity.DemandGenerationLogDetail;
import org.egov.tl.entity.License;
import org.egov.tl.entity.enums.ProcessStatus;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.DemandGenerationLogService;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DemandGenerationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DemandGenerationService.class);
    private static final String LICENSE_NOT_ACTIVE = "License Not Active";
    private static final String SUCCESSFUL = "Successful";
    private static final String DEMAND_EXIST = "Demand exist";
    private static final String ERRORMSG = "Error occurred while generating demand for license {}";
    @Autowired
    private DemandGenerationLogService demandGenerationLogService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private CFinancialYearService financialYearService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    @Qualifier(value="tradeLicenseService")
    private AbstractLicenseService licenseService;
    private int batchSize;

    @Autowired
    public DemandGenerationService(ApplicationProperties applicationProperties) {
        this.batchSize = applicationProperties.getBatchUpdateSize();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, timeout=7200)
    public DemandGenerationLog generateDemand(String installmentYearRange) {
        DemandGenerationLog demandGenerationLog = this.demandGenerationLogService.getDemandGenerationLogByInstallmentYear(installmentYearRange);
        if (demandGenerationLog != null) {
            return demandGenerationLog;
        }
        DemandGenerationLog previousDemandGenerationLog = this.demandGenerationLogService.getPreviousInstallmentDemandGenerationLog(installmentYearRange);
        if (previousDemandGenerationLog != null && previousDemandGenerationLog.getDemandGenerationStatus().equals((Object)ProcessStatus.INCOMPLETE)) {
            throw new ApplicationRuntimeException("TL-008");
        }
        CFinancialYear installmentYear = this.financialYearService.getFinacialYearByYearRange(installmentYearRange);
        if (!this.installmentYearValidForDemandGeneration(installmentYear)) {
            throw new ApplicationRuntimeException("TL-006");
        }
        demandGenerationLog = this.demandGenerationLogService.createDemandGenerationLog(installmentYearRange);
        List<License> licenses = this.licenseService.getAllLicensesByNatureOfBusiness("Permanent");
        return this.generateDemand(demandGenerationLog, installmentYear, licenses);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, timeout=7200)
    public DemandGenerationLog retryFailedDemandGeneration(String installmentYearRange) {
        DemandGenerationLog demandGenerationLog = this.demandGenerationLogService.getDemandGenerationLogByInstallmentYear(installmentYearRange);
        Module module = this.moduleService.getModuleByName("Trade License");
        CFinancialYear installmentYear = this.financialYearService.getFinacialYearByYearRange(installmentYearRange);
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, installmentYear.getStartingDate());
        int batchUpdateCount = 0;
        for (DemandGenerationLogDetail detail : demandGenerationLog.getDetails()) {
            if (!detail.getStatus().equals((Object)ProcessStatus.INCOMPLETE)) continue;
            try {
                this.licenseService.raiseDemand(detail.getLicense(), module, installment);
                detail.setDetail(SUCCESSFUL);
                detail.setStatus(ProcessStatus.COMPLETED);
            }
            catch (RuntimeException e) {
                LOGGER.warn(ERRORMSG, (Object)detail.getLicense().getLicenseNumber(), (Object)e);
                this.demandGenerationLogService.updateDemandGenerationLogDetailOnException(demandGenerationLog, detail, e);
            }
            PersistenceUtils.flushBatchUpdate((EntityManager)this.entityManager, (int)(++batchUpdateCount), (int)this.batchSize);
        }
        return this.demandGenerationLogService.completeDemandGenerationLog(demandGenerationLog);
    }

    private boolean installmentYearValidForDemandGeneration(CFinancialYear installmentYear) {
        DateTime currentDate = new DateTime();
        DateTime startOfCalenderDate = new DateTime((Object)installmentYear.getStartingDate()).monthOfYear().withMinimumValue().dayOfMonth().withMinimumValue().withTimeAtStartOfDay();
        DateTime endOfCalenderDate = startOfCalenderDate.monthOfYear().withMaximumValue().dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue();
        return currentDate.isAfter((ReadableInstant)startOfCalenderDate) && currentDate.isBefore((ReadableInstant)endOfCalenderDate);
    }

    private DemandGenerationLog generateDemand(DemandGenerationLog demandGenerationLog, CFinancialYear installmentYear, List<License> licenses) {
        Module module = this.moduleService.getModuleByName("Trade License");
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, installmentYear.getStartingDate());
        if (installment == null) {
            throw new ApplicationRuntimeException("TL-005");
        }
        demandGenerationLog.setDemandGenerationStatus(ProcessStatus.INPROGRESS);
        int batchUpdateCount = 0;
        for (License license : licenses) {
            DemandGenerationLogDetail demandGenerationLogDetail = this.demandGenerationLogService.createOrGetDemandGenerationLogDetail(demandGenerationLog, license);
            try {
                if (!license.getIsActive()) {
                    demandGenerationLogDetail.setDetail(LICENSE_NOT_ACTIVE);
                } else if (!installment.equals((Object)license.getCurrentDemand().getEgInstallmentMaster())) {
                    this.licenseService.raiseDemand(license, module, installment);
                    demandGenerationLogDetail.setDetail(SUCCESSFUL);
                } else {
                    demandGenerationLogDetail.setDetail(DEMAND_EXIST);
                }
                demandGenerationLogDetail.setStatus(ProcessStatus.COMPLETED);
            }
            catch (RuntimeException e) {
                LOGGER.warn(ERRORMSG, (Object)license.getLicenseNumber(), (Object)e);
                this.demandGenerationLogService.updateDemandGenerationLogDetailOnException(demandGenerationLog, demandGenerationLogDetail, e);
            }
            PersistenceUtils.flushBatchUpdate((EntityManager)this.entityManager, (int)(++batchUpdateCount), (int)this.batchSize);
        }
        return this.demandGenerationLogService.completeDemandGenerationLog(demandGenerationLog);
    }

    @Transactional
    public boolean generateLicenseDemand(License license) {
        boolean generationSuccess = true;
        try {
            this.licenseService.raiseDemand(license, this.licenseService.getModuleName(), this.installmentDao.getInsatllmentByModuleForGivenDate(this.licenseService.getModuleName(), new DateTime().withMonthOfYear(4).withDayOfMonth(1).toDate()));
        }
        catch (ValidationException e) {
            LOGGER.warn(ERRORMSG, (Object)license.getLicenseNumber(), (Object)e);
            generationSuccess = false;
        }
        return generationSuccess;
    }

    public CFinancialYear getLatestFinancialYear() {
        return this.financialYearService.getFinancialYearByDate(new DateTime().withMonthOfYear(4).withDayOfMonth(1).toDate());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, timeout=7200)
    public DemandGenerationLog generateMissingDemand(String installmentYearRange) {
        DemandGenerationLog demandGenerationLog = this.demandGenerationLogService.getDemandGenerationLogByInstallmentYear(installmentYearRange);
        DemandGenerationLog previousDemandGenerationLog = this.demandGenerationLogService.getPreviousInstallmentDemandGenerationLog(installmentYearRange);
        if (previousDemandGenerationLog != null && previousDemandGenerationLog.getDemandGenerationStatus().equals((Object)ProcessStatus.INCOMPLETE)) {
            throw new ApplicationRuntimeException("TL-008");
        }
        CFinancialYear installmentYear = this.financialYearService.getFinacialYearByYearRange(installmentYearRange);
        if (!this.installmentYearValidForDemandGeneration(installmentYear)) {
            throw new ApplicationRuntimeException("TL-006");
        }
        List<License> licenses = this.licenseService.getLicensesForDemandGeneration("Permanent", installmentYear);
        ArrayList<License> demandMissingLicenses = new ArrayList<License>();
        HashSet demandLogLicenses = new HashSet();
        demandGenerationLog.getDetails().stream().filter(demandGenerationLogDetail -> !LICENSE_NOT_ACTIVE.equals(demandGenerationLogDetail.getDetail())).forEach(demandGenerationLogDetail -> demandLogLicenses.add(demandGenerationLogDetail.getLicense()));
        licenses.stream().forEach(license -> {
            if (!demandLogLicenses.contains(license)) {
                demandMissingLicenses.add((License)((Object)license));
            }
        });
        return this.generateDemand(demandGenerationLog, installmentYear, demandMissingLicenses);
    }
}

