/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.commons.Installment;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.InstallmentDao;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.PenaltyRates;
import org.egov.tl.service.LicenseStatusService;
import org.egov.tl.service.LicenseSubCategoryService;
import org.egov.tl.service.PenaltyRatesService;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseUtils.class);
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private LicenseSubCategoryService licenseSubCategoryService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private PenaltyRatesService penaltyRatesService;

    public Module getModule(String moduleName) {
        return this.moduleService.getModuleByName(moduleName);
    }

    public List<LicenseSubCategory> getAllTradeNames(String simpleName) {
        return this.licenseSubCategoryService.getSubCategoriesByLicenseTypeName(simpleName);
    }

    public List<Department> getAllDepartments() {
        return this.departmentService.getAllDepartments();
    }

    public Installment getCurrInstallment(Module module) {
        return this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date());
    }

    public Boolean isDigitalSignEnabled() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Trade License", "DIGITALSIGNINCLUDEINWORKFLOW").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public String getDepartmentCodeForBillGenerate() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Trade License", "DEPARTMENTFORGENERATEBILL");
        return appConfigValue.isEmpty() ? "" : ((AppConfigValues)appConfigValue.get(0)).getValue();
    }

    public Position getCityLevelCommissioner() {
        Department deptObj = this.departmentService.getDepartmentByName("Health");
        Designation desgnObj = this.designationService.getDesignationByName("Commissioner");
        List assignlist = new ArrayList();
        if (deptObj != null) {
            assignlist = this.assignmentService.getAssignmentsByDeptDesigAndDates(deptObj.getId(), desgnObj.getId(), new Date(), new Date());
        }
        if (assignlist.isEmpty()) {
            assignlist = this.assignmentService.getAllPositionsByDepartmentAndDesignationForGivenRange(null, desgnObj.getId(), new Date());
        }
        if (assignlist.isEmpty()) {
            assignlist = this.assignmentService.getAllActiveAssignments(desgnObj.getId());
        }
        return !assignlist.isEmpty() ? ((Assignment)assignlist.get(0)).getPosition() : null;
    }

    public License applicationStatusChange(License licenseObj, String code) {
        licenseObj.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("TRADELICENSE", code));
        return licenseObj;
    }

    public License licenseStatusUpdate(License licenseObj, String code) {
        licenseObj.setStatus(this.licenseStatusService.getLicenseStatusByCode(code));
        return licenseObj;
    }

    public BigDecimal calculatePenalty(License license, Date fromDate, Date collectionDate, BigDecimal amount) {
        if (fromDate != null) {
            int paymentDueDays = Days.daysBetween((ReadablePartial)new LocalDate(fromDate.getTime()), (ReadablePartial)new LocalDate(collectionDate.getTime())).getDays();
            PenaltyRates penaltyRates = this.penaltyRatesService.findByDaysAndLicenseAppType(Long.valueOf(paymentDueDays), license.getLicenseAppType());
            if (penaltyRates == null) {
                LOG.warn("License payment due since {} days, There is no penatlity rate definied for License Type {}", (Object)paymentDueDays, (Object)license.getLicenseAppType().getName());
                return BigDecimal.ZERO;
            }
            return amount.multiply(BigDecimal.valueOf(penaltyRates.getRate() / 100.0));
        }
        return BigDecimal.ZERO;
    }
}

