/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.PenaltyRates;
import org.egov.tl.repository.LicenseAppTypeRepository;
import org.egov.tl.repository.PenaltyRatesRepository;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PenaltyRatesService {
    private final PenaltyRatesRepository penaltyRatesRepository;
    private final LicenseAppTypeRepository licenseAppTypeRepository;

    @Autowired
    public PenaltyRatesService(PenaltyRatesRepository penaltyRatesRepository, LicenseAppTypeRepository licenseAppTypeRepository) {
        this.penaltyRatesRepository = penaltyRatesRepository;
        this.licenseAppTypeRepository = licenseAppTypeRepository;
    }

    public PenaltyRates findByDaysAndLicenseAppType(Long days, LicenseAppType licenseAppType) {
        return this.penaltyRatesRepository.findByDaysAndLicenseAppType(days, licenseAppType);
    }

    public List<LicenseAppType> findAllLicenseAppType() {
        return this.licenseAppTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public PenaltyRates findOne(Long id) {
        return (PenaltyRates)((Object)this.penaltyRatesRepository.findOne(id));
    }

    public LicenseAppType findByLicenseAppType(Long licenseAppId) {
        return (LicenseAppType)((Object)this.licenseAppTypeRepository.findOne(licenseAppId));
    }

    @Transactional
    public List<PenaltyRates> create(List<PenaltyRates> penaltyRates) {
        return this.penaltyRatesRepository.save(penaltyRates);
    }

    public List<PenaltyRates> search(Long licenseAppType) {
        if (licenseAppType != null) {
            return this.penaltyRatesRepository.findByLicenseAppTypeIdOrderByIdAsc(licenseAppType);
        }
        return this.penaltyRatesRepository.findAll();
    }

    @Transactional
    public void delete(PenaltyRates penaltyRates) {
        this.penaltyRatesRepository.delete((Object)penaltyRates);
    }

    public BigDecimal calculatePenalty(Date commencementDate, Date penaltyCalculationEndDate, BigDecimal amount, License license) {
        if (commencementDate != null) {
            int paymentDueDays = Days.daysBetween((ReadablePartial)new LocalDate(commencementDate.getTime()), (ReadablePartial)new LocalDate(penaltyCalculationEndDate.getTime())).getDays();
            PenaltyRates penaltyRates = this.findByDaysAndLicenseAppType(Long.valueOf(paymentDueDays), license.getLicenseAppType());
            if (penaltyRates == null) {
                return BigDecimal.ZERO;
            }
            return amount.multiply(BigDecimal.valueOf(penaltyRates.getRate() / 100.0));
        }
        return BigDecimal.ZERO;
    }
}

