/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.tl.entity.FeeMatrix;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.entity.FeeType;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseSubCategoryDetails;
import org.egov.tl.repository.FeeMatrixRepository;
import org.egov.tl.service.LicenseAppTypeService;
import org.egov.tl.service.NatureOfBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FeeMatrixService<T extends License> {
    @Autowired
    private FeeMatrixRepository feeMatrixRepository;
    @Autowired
    private NatureOfBusinessService natureOfBusinessService;
    @Autowired
    private LicenseAppTypeService licenseAppTypeService;

    @Transactional
    public FeeMatrix create(FeeMatrix feeMatrix) {
        for (FeeMatrixDetail fd : feeMatrix.getFeeMatrixDetail()) {
            fd.setFeeMatrix(feeMatrix);
        }
        return (FeeMatrix)((Object)this.feeMatrixRepository.save((Object)feeMatrix));
    }

    @Transactional
    public FeeMatrix update(FeeMatrix feeMatrix) {
        feeMatrix.getFeeMatrixDetail().removeIf(FeeMatrixDetail::isMarkedForRemoval);
        for (FeeMatrixDetail feeMatrixDetail : feeMatrix.getFeeMatrixDetail()) {
            feeMatrixDetail.setFeeMatrix(feeMatrix);
        }
        return (FeeMatrix)((Object)this.feeMatrixRepository.saveAndFlush((Object)feeMatrix));
    }

    public List<FeeMatrix> getFeeMatrix(Long licenseCategory, Long subCategory, Long financialYear) {
        return this.feeMatrixRepository.searchFeeMatrix(licenseCategory, subCategory, financialYear);
    }

    public FeeMatrix getFeeMatrixById(Long id) {
        return (FeeMatrix)((Object)this.feeMatrixRepository.findOne(id));
    }

    public List<FeeMatrixDetail> getLicenseFeeDetails(T license, Date effectiveDate) {
        ArrayList<FeeMatrixDetail> licenseFeeDetails = new ArrayList<FeeMatrixDetail>();
        for (LicenseSubCategoryDetails subcategoryDetail : ((License)((Object)license)).getTradeName().getLicenseSubCategoryDetails()) {
            FeeMatrix feeMatrix = this.getFeeMatrix((License)((Object)license), subcategoryDetail.getFeeType(), effectiveDate).orElseThrow(() -> new ValidationException("TL-002", "Fee matrix not defined", new String[0]));
            FeeMatrixDetail feeMatrixDetail = feeMatrix.getFeeMatrixDetail().parallelStream().filter(detail -> license.getTradeArea_weight().intValue() > detail.getUomFrom() && license.getTradeArea_weight().intValue() <= detail.getUomTo()).findFirst().orElseThrow(() -> new ValidationException("TL-003", "Fee range not defined", new String[0]));
            licenseFeeDetails.add(feeMatrixDetail);
        }
        return licenseFeeDetails;
    }

    private Optional<FeeMatrix> getFeeMatrix(License license, FeeType feeType, Date effectiveDate) {
        Optional<FeeMatrix> feeMatrix = this.feeMatrixRepository.findFeeMatrix(license, license.getNatureOfBusiness(), feeType, license.getLicenseAppType(), effectiveDate);
        if (!feeMatrix.isPresent() && license.isNewApplication()) {
            feeMatrix = this.getFeeMatrixForTemporaryLicense(license, feeType, effectiveDate);
        }
        if (!feeMatrix.isPresent() && license.isReNewApplication()) {
            feeMatrix = this.getFeeMatrixForRenew(license, feeType, effectiveDate);
        }
        return feeMatrix;
    }

    private Optional<FeeMatrix> getFeeMatrixForRenew(License license, FeeType feeType, Date effectiveDate) {
        Optional<FeeMatrix> feeMatrix = this.getFeeMatrixForTemporaryLicense(license, feeType, effectiveDate);
        if (!feeMatrix.isPresent()) {
            feeMatrix = this.feeMatrixRepository.findFeeMatrix(license, license.getNatureOfBusiness(), feeType, this.licenseAppTypeService.getNewLicenseAppType(), effectiveDate);
        }
        if (!feeMatrix.isPresent() && license.isTemporary()) {
            feeMatrix = this.feeMatrixRepository.findFeeMatrix(license, this.natureOfBusinessService.getPermanentBusinessNature(), feeType, this.licenseAppTypeService.getNewLicenseAppType(), effectiveDate);
        }
        return feeMatrix;
    }

    private Optional<FeeMatrix> getFeeMatrixForTemporaryLicense(License license, FeeType feeType, Date effectiveDate) {
        Optional<FeeMatrix> feeMatrix = Optional.empty();
        if (license.isTemporary()) {
            feeMatrix = this.feeMatrixRepository.findFeeMatrix(license, this.natureOfBusinessService.getPermanentBusinessNature(), feeType, license.getLicenseAppType(), effectiveDate);
        }
        return feeMatrix;
    }
}

