/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.Valid;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.LicenseSubCategoryDetails;
import org.egov.tl.entity.LicenseSubType;
import org.egov.tl.entity.LicenseType;
import org.egov.tl.entity.NatureOfBusiness;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGTL_MSTR_SUB_CATEGORY")
@SequenceGenerator(name="SEQ_EGTL_MSTR_SUB_CATEGORY", sequenceName="SEQ_EGTL_MSTR_SUB_CATEGORY", allocationSize=1)
@Unique(fields={"code", "name"}, enableDfltMsg=true)
public class LicenseSubCategory
extends AbstractAuditable {
    public static final String SEQUENCE = "SEQ_EGTL_MSTR_SUB_CATEGORY";
    private static final long serialVersionUID = 4137779539190266766L;
    @Id
    @GeneratedValue(generator="SEQ_EGTL_MSTR_SUB_CATEGORY", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotBlank(message="tradelic.master.tradesubcategorycode.null")
    @Length(max=32, message="tradelic.master.tradesubcategorycode.length")
    @SafeHtml
    private String code;
    @NotBlank(message="tradelic.master.tradesubcategoryname.null")
    @Length(max=256, message="tradelic.master.tradesubcategoryname.length")
    @SafeHtml
    private String name;
    @ManyToOne
    @JoinColumn(name="ID_CATEGORY")
    private LicenseCategory category;
    @ManyToOne
    @JoinColumn(name="ID_LICENSE_TYPE")
    private LicenseType licenseType;
    @ManyToOne
    @JoinColumn(name="ID_NATURE")
    private NatureOfBusiness natureOfBusiness;
    @ManyToOne
    @JoinColumn(name="ID_LICENSE_SUB_TYPE")
    private LicenseSubType licenseSubType;
    @OneToMany(mappedBy="subCategory", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Valid
    private List<LicenseSubCategoryDetails> licenseSubCategoryDetails = new ArrayList<LicenseSubCategoryDetails>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LicenseCategory getCategory() {
        return this.category;
    }

    public void setCategory(LicenseCategory category) {
        this.category = category;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(LicenseType licenseType) {
        this.licenseType = licenseType;
    }

    public NatureOfBusiness getNatureOfBusiness() {
        return this.natureOfBusiness;
    }

    public void setNatureOfBusiness(NatureOfBusiness natureOfBusiness) {
        this.natureOfBusiness = natureOfBusiness;
    }

    public LicenseSubType getLicenseSubType() {
        return this.licenseSubType;
    }

    public void setLicenseSubType(LicenseSubType licenseSubType) {
        this.licenseSubType = licenseSubType;
    }

    public void addLicenseSubCategoryDetails(LicenseSubCategoryDetails licenseSubCategoryDetail) {
        this.getLicenseSubCategoryDetails().add(licenseSubCategoryDetail);
    }

    public List<LicenseSubCategoryDetails> getLicenseSubCategoryDetails() {
        return this.licenseSubCategoryDetails;
    }

    public void setLicenseSubCategoryDetails(List<LicenseSubCategoryDetails> licenseSubCategoryDetails) {
        this.licenseSubCategoryDetails = licenseSubCategoryDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LicenseSubCategory that = (LicenseSubCategory)((Object)o);
        if (this.getCode() != null ? !this.getCode().equals(that.getCode()) : that.getCode() != null) {
            return false;
        }
        return this.getName() != null ? this.getName().equals(that.getName()) : that.getName() == null;
    }

    public int hashCode() {
        int result = this.getCode() != null ? this.getCode().hashCode() : 0;
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        return result;
    }
}

