/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.tl.entity.dto.InstallmentWiseDCBForm;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class InstallmentwiseDCBReportService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private CFinancialYearService cFinancialYearService;

    public List<CFinancialYear> getFinancialYears() {
        List financialYearList = this.cFinancialYearService.findAll();
        Collections.reverse(financialYearList);
        return financialYearList;
    }

    @ReadOnly
    public List<InstallmentWiseDCBForm> getReportResult(String licenseNumber, String financialYear) {
        CFinancialYear cFinancialYear = this.cFinancialYearService.getFinacialYearByYearRange(financialYear);
        SQLQuery finalQuery = this.prepareQuery(licenseNumber, cFinancialYear);
        if (cFinancialYear != null) {
            finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(InstallmentWiseDCBForm.class));
            finalQuery.setParameter("fromDate", (Object)cFinancialYear.getStartingDate());
        }
        if (StringUtils.isNotEmpty((CharSequence)licenseNumber)) {
            finalQuery.setParameter("licenseNumber", (Object)licenseNumber);
        }
        return finalQuery.list();
    }

    private SQLQuery prepareQuery(String licenseNumber, CFinancialYear financialYear) {
        StringBuilder selectQry = new StringBuilder();
        StringBuilder whereQry = new StringBuilder();
        if (financialYear != null) {
            selectQry.append("select mv.licensenumber as licensenumber,cast(mv.licenseid as integer) as licenseid,").append("coalesce(cast(sum(mv.curr_demand) as bigint),0) as currentdemand,coalesce(cast(sum(mv.curr_coll) as bigint),0) as currentcoll,").append("coalesce(cast(sum(mv.curr_balance) as bigint),0) as currentbalance ,coalesce(cast(sum(mv.arr_demand) as bigint),0) as arreardemand,").append("coalesce(cast(sum(mv.arr_coll) as bigint),0) as arrearcoll,coalesce(cast(sum(arr_balance) as bigint),0) as arrearbalance ").append("from (select aggrdcb.licensenumber,aggrdcb.licenseid,").append("case when aggrdcb.installment = :fromDate then aggrdcb.curr_demand end as curr_demand,").append("case when aggrdcb.installment = :fromDate then aggrdcb.curr_coll end as curr_coll,").append("case when aggrdcb.installment = :fromDate then aggrdcb.curr_balance end as curr_balance,").append("case when aggrdcb.installment < :fromDate then aggrdcb.curr_demand end as arr_demand,").append("case when aggrdcb.installment < :fromDate then aggrdcb.curr_coll end as arr_coll,").append("case when aggrdcb.installment < :fromDate then aggrdcb.curr_balance end as arr_balance ").append("from egtl_dcb_aggr_view aggrdcb where 1=1 ");
            whereQry.append("and aggrdcb.installment <=:fromDate ");
            if (StringUtils.isNotEmpty((CharSequence)licenseNumber)) {
                whereQry.append("and aggrdcb.licensenumber =:licenseNumber ");
            }
            whereQry.append("order by aggrdcb.licenseid) as mv group by mv.licensenumber,mv.licenseid order by mv.licenseid");
        }
        selectQry.append((CharSequence)whereQry);
        return ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(selectQry.toString());
    }
}

