/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.tl.entity.DemandGenerationLog;
import org.egov.tl.entity.DemandGenerationLogDetail;
import org.egov.tl.entity.License;
import org.egov.tl.entity.enums.ProcessStatus;
import org.egov.tl.repository.DemandGenerationLogDetailRepository;
import org.egov.tl.repository.DemandGenerationLogRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DemandGenerationLogService {
    private static final String INSTALLMENT_YEAR = "%d-%s";
    @Autowired
    private DemandGenerationLogRepository demandGenerationLogRepository;
    @Autowired
    private DemandGenerationLogDetailRepository demandGenerationLogDetailRepository;

    public DemandGenerationLog getDemandGenerationLogByInstallmentYear(String installmentYearRange) {
        return this.demandGenerationLogRepository.findByInstallmentYear(installmentYearRange);
    }

    public DemandGenerationLog getPreviousInstallmentDemandGenerationLog(String installmentYearRange) {
        int previousInstallmentStartYear = Integer.valueOf(installmentYearRange.split("-")[0]) - 1;
        String previousInstallmentYearRange = String.format(INSTALLMENT_YEAR, previousInstallmentStartYear, String.valueOf(previousInstallmentStartYear + 1).substring(2, 4));
        return this.getDemandGenerationLogByInstallmentYear(previousInstallmentYearRange);
    }

    @Transactional
    public DemandGenerationLog createDemandGenerationLog(String installmentYearRange) {
        return (DemandGenerationLog)((Object)this.demandGenerationLogRepository.save((Object)new DemandGenerationLog(installmentYearRange)));
    }

    @Transactional
    public DemandGenerationLog completeDemandGenerationLog(DemandGenerationLog demandGenerationLog) {
        demandGenerationLog.setDemandGenerationStatus(ProcessStatus.COMPLETED);
        for (DemandGenerationLogDetail detail : demandGenerationLog.getDetails()) {
            if (!detail.getStatus().equals((Object)ProcessStatus.INCOMPLETE)) continue;
            demandGenerationLog.setDemandGenerationStatus(ProcessStatus.INCOMPLETE);
            break;
        }
        demandGenerationLog.setExecutionStatus(ProcessStatus.COMPLETED);
        return (DemandGenerationLog)((Object)this.demandGenerationLogRepository.save((Object)demandGenerationLog));
    }

    @Transactional
    public DemandGenerationLogDetail createOrGetDemandGenerationLogDetail(DemandGenerationLog demandGenerationLog, License license) {
        DemandGenerationLogDetail logDetail = this.demandGenerationLogDetailRepository.findByDemandGenerationLogIdAndLicenseId(demandGenerationLog.getId(), license.getId());
        if (logDetail == null) {
            logDetail = new DemandGenerationLogDetail();
            logDetail.setLicense(license);
            logDetail.setDemandGenerationLog(demandGenerationLog);
            logDetail.setStatus(ProcessStatus.INPROGRESS);
            demandGenerationLog.getDetails().add(logDetail);
        }
        return logDetail;
    }

    @Transactional
    public void updateDemandGenerationLogDetailOnException(DemandGenerationLog demandGenerationLog, DemandGenerationLogDetail logDetail, RuntimeException exception) {
        String error = exception instanceof ValidationException ? ((ValidationError)((ValidationException)((Object)exception)).getErrors().get(0)).getMessage() : "Error : " + exception;
        logDetail.setStatus(ProcessStatus.INCOMPLETE);
        logDetail.setDetail(error);
        demandGenerationLog.setDemandGenerationStatus(ProcessStatus.INCOMPLETE);
    }
}

