/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.egov.collection.entity.es.CollectionDocument;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.DateUtils;
import org.egov.tl.entity.dto.DCRSearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class DailyCollectionReportService {
    private static final String RECEIPT_COUNT = "receipt_count";
    private static final String COLLECTION_INDEX_NAME = "receipts";
    private static final String COLLECION_BILLING_SERVICE_TL = "Trade License";
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private AppConfigValueService appConfigValueService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public Set<User> getCollectionOperators() {
        String operatorDesignation = this.appConfigValueService.getAppConfigValueByDate("Collection", "COLLECTIONDESIGNATIONFORCSCOPERATORASCLERK", new Date()).getValue();
        return this.assignmentService.getUsersByDesignations(operatorDesignation.split(","));
    }

    public List<CollectionDocument> searchDailyCollection(DCRSearchRequest dcrSearchRequest) {
        BoolQueryBuilder dcrSearchCriteria = this.getCollectionFilterQuery(dcrSearchRequest);
        NativeSearchQuery dcrSearchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{COLLECTION_INDEX_NAME}).withQuery((QueryBuilder)dcrSearchCriteria).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)RECEIPT_COUNT).field("consumerCode")).build();
        ValueCount receiptCount = (ValueCount)((Aggregations)this.elasticsearchTemplate.query((SearchQuery)dcrSearchQuery, SearchResponse::getAggregations)).get(RECEIPT_COUNT);
        dcrSearchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{COLLECTION_INDEX_NAME}).withQuery((QueryBuilder)dcrSearchCriteria).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)RECEIPT_COUNT).field("consumerCode")).withPageable((Pageable)new PageRequest(0, receiptCount.getValue() == 0L ? 1 : (int)receiptCount.getValue())).build();
        return this.elasticsearchTemplate.queryForList((SearchQuery)dcrSearchQuery, CollectionDocument.class);
    }

    public BoolQueryBuilder getCollectionFilterQuery(DCRSearchRequest searchRequest) {
        Date fromDate = null;
        Date toDate = null;
        if (searchRequest.getFromDate() != null) {
            fromDate = DateUtils.startOfDay((Date)searchRequest.getFromDate());
        }
        if (searchRequest.getToDate() != null) {
            toDate = DateUtils.endOfDay((Date)searchRequest.getToDate());
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"billingService", (Object)COLLECION_BILLING_SERVICE_TL)).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"receiptDate").gte(DateUtils.getFormattedDate((Date)fromDate, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")).lte(DateUtils.getFormattedDate((Date)toDate, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")).includeUpper(false));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityName", (Object)ApplicationThreadLocals.getCityName()));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCollectionOperator())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"receiptCreator", (Object)searchRequest.getCollectionOperator()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getStatus())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)searchRequest.getStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"revenueWard", (Object)searchRequest.getRevenueWard()));
        }
        return boolQuery;
    }
}

