/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.tl.entity.DemandGenerationLogDetail;
import org.egov.tl.entity.enums.ProcessStatus;

@Entity
@Table(name="egtl_demandgenerationlog")
@SequenceGenerator(name="seq_egtl_demandgenerationlog", sequenceName="seq_egtl_demandgenerationlog", allocationSize=1)
@Unique(fields={"installmentYear"}, enableDfltMsg=true)
public class DemandGenerationLog
extends AbstractAuditable {
    public static final String SEQ = "seq_egtl_demandgenerationlog";
    private static final long serialVersionUID = 3323170307345697375L;
    @Id
    @GeneratedValue(generator="seq_egtl_demandgenerationlog", strategy=GenerationType.SEQUENCE)
    private Long id;
    private String installmentYear;
    @Enumerated(value=EnumType.STRING)
    private ProcessStatus executionStatus;
    @Enumerated(value=EnumType.STRING)
    private ProcessStatus demandGenerationStatus;
    @OneToMany(mappedBy="demandGenerationLog", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private Set<DemandGenerationLogDetail> details = new HashSet<DemandGenerationLogDetail>();

    protected DemandGenerationLog() {
    }

    public DemandGenerationLog(String installmentYear) {
        this.installmentYear = installmentYear;
        this.executionStatus = ProcessStatus.INPROGRESS;
        this.demandGenerationStatus = ProcessStatus.INCOMPLETE;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getInstallmentYear() {
        return this.installmentYear;
    }

    public void setInstallmentYear(String installmentYear) {
        this.installmentYear = installmentYear;
    }

    public ProcessStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ProcessStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public ProcessStatus getDemandGenerationStatus() {
        return this.demandGenerationStatus;
    }

    public void setDemandGenerationStatus(ProcessStatus demandGenerationStatus) {
        this.demandGenerationStatus = demandGenerationStatus;
    }

    public Set<DemandGenerationLogDetail> getDetails() {
        return this.details;
    }

    public void setDetails(Set<DemandGenerationLogDetail> details) {
        this.details = details;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DemandGenerationLog)) {
            return false;
        }
        DemandGenerationLog that = (DemandGenerationLog)((Object)other);
        return Objects.equals(this.installmentYear, that.installmentYear);
    }

    public int hashCode() {
        return Objects.hash(this.installmentYear);
    }
}

