/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.utils.DateUtils;
import org.egov.tl.entity.License;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class TradeLicenseSmsAndEmailService {
    @Autowired
    private MessagingService messagingService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource licenseMessageSource;

    public void sendSMSOnLicense(String mobileNumber, String smsBody) {
        this.messagingService.sendSMS(mobileNumber, smsBody);
    }

    public void sendEmailOnLicense(String email, String emailBody, String emailSubject) {
        this.messagingService.sendEmail(email, emailSubject, emailBody);
    }

    public String getMunicipalityName() {
        return ApplicationThreadLocals.getMunicipalityName();
    }

    public void sendSmsAndEmail(License license, String workFlowAction) {
        String mobileNumber = license.getLicensee() != null && license.getLicensee().getMobilePhoneNumber() != null ? license.getLicensee().getMobilePhoneNumber() : null;
        String email = license.getLicensee() != null && license.getLicensee().getEmailId() != null ? license.getLicensee().getEmailId() : null;
        this.getSmsAndEmailForNewTradeLicense(license, workFlowAction, email, mobileNumber);
    }

    public void getSmsAndEmailForNewTradeLicense(License license, String workFlowAction, String email, String mobileNumber) {
        String smsMsg = null;
        String emailBody = "";
        String emailSubject = "";
        Locale locale = Locale.getDefault();
        String[] strarr = this.getMunicipalityName().split(" ");
        String cityname = strarr[0];
        if (license.getState().getHistory().isEmpty() && license.isAcknowledged()) {
            String emailCode;
            String smsCode;
            if (license.isReNewApplication()) {
                smsCode = "msg.renewTradeLicensecreator.sms";
                emailCode = "msg.renewTradeLicensecreate.email.body";
            } else {
                smsCode = "msg.newTradeLicensecreator.sms";
                emailCode = "msg.newTradeLicensecreate.email.body";
            }
            smsMsg = this.licenseMessageSource.getMessage(smsCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), this.getMunicipalityName()}, locale);
            emailBody = this.licenseMessageSource.getMessage(emailCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), this.getMunicipalityName()}, locale);
            emailSubject = this.licenseMessageSource.getMessage("msg.newTradeLicensecreate.email.subject", (Object[])new String[]{license.getApplicationNumber()}, locale);
        } else if (workFlowAction.equals("Approve") && "UWF".equalsIgnoreCase(license.getStatus().getStatusCode())) {
            BigDecimal demAmt = license.getLatestAmountPaid();
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            String emailCode = license.isReNewApplication() ? "msg.renewTradeLicenseapproval.email.body" : "msg.newTradeLicenseapproval.email.body";
            smsMsg = this.licenseMessageSource.getMessage("msg.newTradeLicenseapproval.sms", (Object[])new String[]{license.getLicensee().getApplicantName(), license.getLicenseNumber(), demAmt.toString(), formatter.format(license.getApplicationDate()), cityname, this.getMunicipalityName()}, locale);
            emailBody = this.licenseMessageSource.getMessage(emailCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getLicenseNumber(), demAmt.toString(), formatter.format(license.getApplicationDate()), cityname, this.getMunicipalityName()}, locale);
            emailSubject = this.licenseMessageSource.getMessage("msg.newTradeLicenseApproval.email.subject", (Object[])new String[]{license.getLicenseNumber()}, locale);
        } else if ("CAN".equalsIgnoreCase(license.getStatus().getStatusCode())) {
            smsMsg = this.licenseMessageSource.getMessage("msg.newTradeLicensecancelled.sms", (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), cityname, this.getMunicipalityName()}, locale);
            emailBody = this.licenseMessageSource.getMessage("msg.newTradeLicensecancelled.email.body", (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), cityname, this.getMunicipalityName()}, locale);
            emailSubject = this.licenseMessageSource.getMessage("msg.newTradeLicensecancelled.email.subject", (Object[])new String[]{license.getApplicationNumber()}, locale);
        }
        this.sendSMSOnLicense(mobileNumber, smsMsg);
        this.sendEmailOnLicense(email, emailBody, emailSubject);
    }

    public void sendSMsAndEmailOnCollection(License license, Date receiptDate, BigDecimal demandAmount) {
        String message;
        String subject;
        if (license.getLicenseNumber() != null) {
            subject = String.format("Trade License Application Amount Collected for %s %s", "TIN No.", license.getLicenseNumber());
            message = String.format("Dear %s,%nTrade License with TIN No.%s, fee collected is at the rate of Rs.%s/- per year w.e.f %s.%nThanks,%n%s", license.getLicensee().getApplicantName(), license.getLicenseNumber(), demandAmount.toString(), DateUtils.toDefaultDateFormat((Date)receiptDate), ApplicationThreadLocals.getMunicipalityName());
        } else {
            subject = String.format("Trade License Application Amount Collected for %s %s", "Application No.", license.getApplicationNumber());
            message = String.format("Dear %s, %nYour Trade License application with number %s has been accepted, please use this number for future reference.%nThanks,%n%s", license.getLicensee().getApplicantName(), license.getApplicationNumber(), ApplicationThreadLocals.getMunicipalityName());
        }
        this.messagingService.sendSMS(license.getLicensee().getMobilePhoneNumber(), message);
        this.messagingService.sendEmail(license.getLicensee().getEmailId(), subject, message);
    }
}

