/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.service.CFinancialYearService;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.entity.dto.DemandnoticeForm;
import org.egov.tl.entity.dto.SearchForm;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.TradeLicenseSmsAndEmailService;
import org.egov.tl.utils.LicenseUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class TradeLicenseService
extends AbstractLicenseService<TradeLicense> {
    @Autowired
    private TradeLicenseSmsAndEmailService tradeLicenseSmsAndEmailService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private LicenseUtils licenseUtils;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private CityService cityService;

    @Override
    protected NatureOfBusiness getNatureOfBusiness() {
        return this.natureOfBusinessService.getNatureOfBusinessByName("Permanent");
    }

    @Override
    protected Module getModuleName() {
        return this.moduleService.getModuleByName("Trade License");
    }

    @Override
    protected void sendEmailAndSMS(TradeLicense license, String currentAction) {
        this.tradeLicenseSmsAndEmailService.sendSmsAndEmail(license, currentAction);
    }

    @Override
    protected LicenseAppType getLicenseApplicationTypeForRenew() {
        return this.licenseAppTypeService.getLicenseAppTypeByName("Renew");
    }

    @Override
    protected LicenseAppType getLicenseApplicationType() {
        return this.licenseAppTypeService.getLicenseAppTypeByName("New");
    }

    @Transactional
    public void updateTradeLicense(TradeLicense license, WorkflowBean workflowBean) {
        this.licenseRepository.save((Object)license);
        this.tradeLicenseSmsAndEmailService.sendSmsAndEmail(license, workflowBean.getWorkFlowAction());
        this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex(license);
    }

    @Transactional
    public void updateStatusInWorkFlowProgress(TradeLicense license, String workFlowAction) {
        BigDecimal currentDemandAmount = this.recalculateLicenseFee(license.getCurrentDemand());
        BigDecimal recalDemandAmount = this.calculateFeeAmount(license);
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(this.securityUtils.getCurrentUser().getId());
        Position wfInitiator = this.getWorkflowInitiator(license);
        if ("Approve".equals(workFlowAction)) {
            license.setActive(true);
            if (license.getTempLicenseNumber() == null && license.isNewApplication()) {
                license.setLicenseNumber(this.licenseNumberUtils.generateLicenseNumber());
            }
            if (license.getCurrentDemand().getBaseDemand().compareTo(license.getCurrentDemand().getAmtCollected()) <= 0) {
                this.licenseUtils.applicationStatusChange(license, "APPROVED");
            } else {
                this.licenseUtils.applicationStatusChange(license, "SECONDLVLCOLLECTIONPENDING");
            }
        }
        if ("Approve".equals(workFlowAction) || "Forward".equals(workFlowAction)) {
            license.setStatus(this.licenseStatusService.getLicenseStatusByCode("UWF"));
            if (license.getState().getValue().equals("Revenue clerk approved")) {
                this.licenseUtils.applicationStatusChange(license, "INSPECTIONDONE");
            }
            if (license.getState().getValue().equals("Rejected")) {
                this.licenseUtils.applicationStatusChange(license, "CREATED");
            }
        }
        if ("Generate Certificate".equals(workFlowAction)) {
            license.setStatus(this.licenseStatusService.getLicenseStatusByCode("ACT"));
            license.setLegacy(false);
            this.validityService.applyLicenseValidity(license);
            this.licenseUtils.applicationStatusChange(license, "CERTIFICATEGENERATED");
        }
        if ("Reject".equals(workFlowAction)) {
            if (license.getLicenseAppType() != null && wfInitiator.equals((Object)userAssignment.getPosition()) && "Rejected".equals(license.getState().getValue()) || "License Created".equals(license.getState().getValue())) {
                license.setStatus(this.licenseStatusService.getLicenseStatusByCode("CAN"));
                this.licenseUtils.applicationStatusChange(license, "CANCELLED");
                if (license.isNewApplication()) {
                    license.setActive(false);
                }
            } else {
                license.setStatus(this.licenseStatusService.getLicenseStatusByCode("REJ"));
                this.licenseUtils.applicationStatusChange(license, "REJECTED");
            }
        }
        if (license.hasState() && license.getState().getValue().contains("Revenue clerk approved") && recalDemandAmount.compareTo(currentDemandAmount) > 0) {
            this.updateDemandForChangeTradeArea(license);
        }
    }

    public ReportRequest prepareReportInputData(License license) {
        String cityGrade = this.getCityGrade();
        if (cityGrade != null && cityGrade.equalsIgnoreCase("Corp")) {
            Map<String, Object> reportParams = this.getReportParamsForCertificate(license, null, null);
            return new ReportRequest("licenseCertificateForCorp", (Object)license, reportParams);
        }
        Map<String, Object> reportParams = this.getReportParamsForCertificate(license, null, null);
        return new ReportRequest("licenseCertificate", (Object)license, reportParams);
    }

    private String getCityGrade() {
        return this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName()).getGrade();
    }

    public ReportOutput prepareReportInputDataForDig(License license, String districtName, String cityMunicipalityName) {
        String cityGrade = this.getCityGrade();
        if (cityGrade != null && cityGrade.equalsIgnoreCase("Corp")) {
            return this.reportService.createReport(new ReportRequest("licenseCertificateForCorp", (Object)license, this.getReportParamsForCertificate(license, districtName, cityMunicipalityName)));
        }
        return this.reportService.createReport(new ReportRequest("licenseCertificate", (Object)license, this.getReportParamsForCertificate(license, districtName, cityMunicipalityName)));
    }

    private Map<String, Object> getReportParamsForCertificate(License license, String districtName, String cityMunicipalityName) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        reportParams.put("applicationnumber", license.getApplicationNumber());
        reportParams.put("applicantName", license.getLicensee().getApplicantName());
        reportParams.put("licencenumber", license.getLicenseNumber());
        reportParams.put("wardName", license.getBoundary().getName());
        reportParams.put("cscNumber", "");
        reportParams.put("nameOfEstablishment", license.getNameOfEstablishment());
        reportParams.put("licenceAddress", StringEscapeUtils.escapeXml((String)license.getAddress()));
        reportParams.put("municipality", cityMunicipalityName);
        reportParams.put("district", districtName);
        reportParams.put("category", license.getCategory().getName());
        reportParams.put("subCategory", license.getTradeName().getName());
        if (license.getState() != null && license.getState().getValue().equals("First level fee collected")) {
            reportParams.put("certificateType", "provisional");
        }
        reportParams.put("appType", license.isNewApplication() ? "New Trade" : "Renewal");
        reportParams.put("currentDate", DateUtils.currentDateToDefaultDateFormat());
        if (ApplicationThreadLocals.getMunicipalityName().contains("Corporation")) {
            reportParams.put("carporationulbType", Boolean.TRUE);
        }
        reportParams.put("municipality", ApplicationThreadLocals.getMunicipalityName());
        Optional<EgDemandDetails> demandDetails = license.getCurrentDemand().getEgDemandDetails().stream().sorted(Comparator.comparing(EgDemandDetails::getInstallmentEndDate).reversed()).filter(demandDetail -> demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().equals("License Fee")).filter(demandDetail -> demandDetail.getAmount().subtract(demandDetail.getAmtCollected()).doubleValue() <= 0.0).findFirst();
        if (!demandDetails.isPresent()) {
            throw new ValidationException("License Fee is not paid", "License Fee is not paid", new String[0]);
        }
        BigDecimal amtPaid = demandDetails.get().getAmtCollected();
        String startYear = DateUtils.toYearFormat((Date)demandDetails.get().getInstallmentStartDate());
        String endYear = DateUtils.toYearFormat((Date)demandDetails.get().getInstallmentEndDate());
        reportParams.put("installMentYear", startYear + "-" + endYear);
        reportParams.put("applicationdate", DateUtils.getDefaultFormattedDate((Date)license.getApplicationDate()));
        reportParams.put("demandUpdateDate", DateUtils.getDefaultFormattedDate((Date)license.getCurrentDemand().getModifiedDate()));
        reportParams.put("demandTotalamt", amtPaid);
        return reportParams;
    }

    public List<String> getTradeLicenseForGivenParam(String paramValue, String paramType) {
        List<Object> licenseList = new ArrayList();
        if (paramType.equals("ApplicationNumber")) {
            licenseList = this.licenseRepository.findAllApplicationNumberLike(paramValue);
        } else if (paramType.equals("LicenseNumber")) {
            licenseList = this.licenseRepository.findAllLicenseNumberLike(paramValue);
        } else if (paramType.equals("OldLicenseNumber")) {
            licenseList = this.licenseRepository.findAllOldLicenseNumberLike(paramValue);
        } else if (paramType.equals("TradeTitle")) {
            licenseList = this.licenseRepository.findAllNameOfEstablishmentLike(paramValue);
        } else if (paramType.equals("TradeOwnerName")) {
            licenseList = this.licenseRepository.findAllApplicantNameLike(paramValue);
        } else if (paramType.equals("PropertyAssessmentNo")) {
            licenseList = this.licenseRepository.findAllAssessmentNoLike(paramValue);
        } else if (paramType.equals("MobileNo")) {
            licenseList = this.licenseRepository.findAllMobilePhoneNumberLike(paramValue);
        }
        return licenseList;
    }

    public List<SearchForm> searchTradeLicense(SearchForm searchForm) {
        Criteria searchCriteria = this.entityQueryService.getSession().createCriteria(TradeLicense.class);
        searchCriteria.createAlias("licensee", "licc").createAlias("category", "cat").createAlias("tradeName", "subcat").createAlias("status", "licstatus");
        if (StringUtils.isNotBlank((CharSequence)searchForm.getApplicationNumber())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"applicationNumber", (Object)searchForm.getApplicationNumber()).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)searchForm.getLicenseNumber())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"licenseNumber", (Object)searchForm.getLicenseNumber()).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)searchForm.getOldLicenseNumber())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"oldLicenseNumber", (Object)searchForm.getOldLicenseNumber()).ignoreCase());
        }
        if (searchForm.getCategoryId() != null) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"cat.id", (Object)searchForm.getCategoryId()));
        }
        if (searchForm.getSubCategoryId() != null) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"subcat.id", (Object)searchForm.getSubCategoryId()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchForm.getTradeTitle())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"nameOfEstablishment", (Object)searchForm.getTradeTitle()).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)searchForm.getTradeOwnerName())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"licc.applicantName", (Object)searchForm.getTradeOwnerName()).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)searchForm.getPropertyAssessmentNo())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"assessmentNo", (Object)searchForm.getPropertyAssessmentNo()).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)searchForm.getMobileNo())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"licc.mobilePhoneNumber", (Object)searchForm.getMobileNo()));
        }
        if (searchForm.getStatusId() != null) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"status.id", (Object)searchForm.getStatusId()));
        }
        if (searchForm.getInactive() != null && searchForm.getInactive().equals(Boolean.TRUE)) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"isActive", (Object)false));
        }
        searchCriteria.add(Restrictions.isNotNull((String)"applicationNumber"));
        searchCriteria.addOrder(Order.asc((String)"id"));
        String currentUserRoles = this.securityUtils.getCurrentUser().getRoles().toString();
        LinkedList<SearchForm> finalList = new LinkedList<SearchForm>();
        for (License license : searchCriteria.list()) {
            CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(license.getDateOfExpiry());
            String expiryYear = financialYear != null ? financialYear.getFinYearRange() : "";
            finalList.add(new SearchForm(license, currentUserRoles, this.getOwnerName(license), expiryYear));
        }
        return finalList;
    }

    public List<DemandnoticeForm> searchLicensefordemandnotice(DemandnoticeForm demandnoticeForm) {
        Criteria searchCriteria = this.entityQueryService.getSession().createCriteria(TradeLicense.class);
        searchCriteria.createAlias("licensee", "licc").createAlias("category", "cat").createAlias("tradeName", "subcat").createAlias("status", "licstatus");
        if (StringUtils.isNotBlank((CharSequence)demandnoticeForm.getLicenseNumber())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"licenseNumber", (Object)demandnoticeForm.getLicenseNumber()).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)demandnoticeForm.getOldLicenseNumber())) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"oldLicenseNumber", (Object)demandnoticeForm.getOldLicenseNumber()).ignoreCase());
        }
        if (demandnoticeForm.getCategoryId() != null) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"cat.id", (Object)demandnoticeForm.getCategoryId()));
        }
        if (demandnoticeForm.getSubCategoryId() != null) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"subcat.id", (Object)demandnoticeForm.getSubCategoryId()));
        }
        if (demandnoticeForm.getWardId() != null) {
            searchCriteria.createAlias("parentBoundary", "wards").add((Criterion)Restrictions.eq((String)"wards.id", (Object)demandnoticeForm.getWardId()));
        }
        if (demandnoticeForm.getLocalityId() != null) {
            searchCriteria.createAlias("boundary", "locality").add((Criterion)Restrictions.eq((String)"locality.id", (Object)demandnoticeForm.getLocalityId()));
        }
        if (demandnoticeForm.getStatusId() != null) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"status.id", (Object)demandnoticeForm.getStatusId()));
        } else {
            searchCriteria.add((Criterion)Restrictions.ne((String)"licstatus.statusCode", (Object)StringUtils.upperCase((String)"CAN")));
        }
        searchCriteria.addOrder(Order.asc((String)"id"));
        LinkedList<DemandnoticeForm> finalList = new LinkedList<DemandnoticeForm>();
        for (TradeLicense license : searchCriteria.list()) {
            Installment currentInstallment = license.getCurrentDemand().getEgInstallmentMaster();
            List previousInstallment = this.installmentDao.fetchPreviousInstallmentsInDescendingOrderByModuleAndDate(this.licenseUtils.getModule("Trade License"), currentInstallment.getToDate(), 1);
            Map<String, Map<String, BigDecimal>> outstandingFees = this.getOutstandingFeeForDemandNotice(license, currentInstallment, (Installment)previousInstallment.get(0));
            Map<String, BigDecimal> licenseFees = outstandingFees.get("License Fee");
            finalList.add(new DemandnoticeForm(license, licenseFees, this.getOwnerName(license)));
        }
        return finalList;
    }

    public String getOwnerName(License license) {
        List assignmentList;
        String ownerName = license.getState() != null ? (!(assignmentList = this.assignmentService.getAssignmentsForPosition(license.getState().getOwnerPosition().getId(), new Date())).isEmpty() ? ((Assignment)assignmentList.get(0)).getEmployee().getName() : license.getLastModifiedBy().getName()) : license.getLastModifiedBy().getName();
        return ownerName;
    }
}

