/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infstr.services.Page;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class LicenseReportService {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private InstallmentHibDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    protected List<Map<String, Object>> licenseList = new ArrayList<Map<String, Object>>();
    protected EgovPaginatedList paginateList;
    protected Integer pageNum = 1;
    protected Integer pageSize = 20;
    protected List pageList = new ArrayList();
    protected Map<String, Object> hashMap;
    protected String query;

    public EgovPaginatedList getZoneWiseReportList(String pageNo, String moduleName, String licenseType) {
        Installment currentInstallment = this.getCurrentInstallment(moduleName);
        return this.populateZoneWiseReport(pageNo, licenseType, currentInstallment);
    }

    private EgovPaginatedList populateZoneWiseReport(String pageNo, String licenseType, Installment installment) {
        this.query = this.constructQuery("Zone", null, licenseType, installment).toString();
        SQLQuery hibQuery = this.persistenceService.getSession().createSQLQuery(this.query);
        this.pageNum = pageNo == null ? Integer.valueOf(1) : Integer.valueOf(pageNo);
        Integer fullSize = hibQuery.list().size();
        Page page = new Page((Query)hibQuery, this.pageNum, this.pageSize);
        this.pageList = page.getList();
        this.paginateList = new EgovPaginatedList(page, fullSize.intValue());
        if (this.pageList != null) {
            for (Object[] objects : this.pageList) {
                this.hashMap = new HashMap<String, Object>();
                this.hashMap.put("NEW", objects[0]);
                this.hashMap.put("CANCELLED", objects[1]);
                this.hashMap.put("OBJECTED", objects[2]);
                this.hashMap.put("RENEWED", objects[3]);
                this.hashMap.put("PENDING_RENEWALS", this.getPendingRenewals(licenseType, Long.valueOf(String.valueOf(objects[5])), null, this.getPendingRenewalsDate(installment)));
                this.hashMap.put("TOTAL_LICENSES", Long.valueOf(String.valueOf(objects[0])) + Long.valueOf(String.valueOf(objects[3])));
                this.hashMap.put("ZONE_ID", objects[5]);
                this.hashMap.put("Zone", objects[6]);
                this.hashMap.put("TOTAL_AMOUNT", objects[4]);
                this.licenseList.add(this.hashMap);
            }
        }
        this.paginateList.setList(this.licenseList);
        return this.paginateList;
    }

    public EgovPaginatedList getWardWiseReportList(Integer zoneId, String pageNo, String moduleName, String licenseType) {
        Installment currentInstallment = this.getCurrentInstallment(moduleName);
        return this.populateZoneWiseReport(zoneId, pageNo, licenseType, currentInstallment);
    }

    private EgovPaginatedList populateZoneWiseReport(Integer zoneId, String pageNo, String licenseType, Installment installment) {
        this.query = this.constructQuery("Ward", zoneId, licenseType, installment).toString();
        SQLQuery hibQuery = this.persistenceService.getSession().createSQLQuery(this.query);
        this.pageNum = pageNo == null ? Integer.valueOf(1) : Integer.valueOf(pageNo);
        Integer fullSize = hibQuery.list().size();
        Page page = new Page((Query)hibQuery, this.pageNum, this.pageSize);
        this.pageList = page.getList();
        this.paginateList = new EgovPaginatedList(page, fullSize.intValue());
        if (this.pageList != null) {
            for (Object[] objects : this.pageList) {
                this.hashMap = new HashMap<String, Object>();
                this.hashMap.put("NEW", objects[0]);
                this.hashMap.put("CANCELLED", objects[1]);
                this.hashMap.put("OBJECTED", objects[2]);
                this.hashMap.put("PENDING_RENEWALS", this.getPendingRenewals(licenseType, Long.valueOf(String.valueOf(objects[5])), null, this.getPendingRenewalsDate(installment)));
                this.hashMap.put("RENEWED", objects[3]);
                this.hashMap.put("TOTAL_LICENSES", Long.valueOf(String.valueOf(objects[0])) + Long.valueOf(String.valueOf(objects[3])));
                this.hashMap.put("WARD_ID", objects[5]);
                this.hashMap.put("WARD", objects[6]);
                this.hashMap.put("TOTAL_AMOUNT", objects[4]);
                this.licenseList.add(this.hashMap);
            }
        }
        this.paginateList.setList(this.licenseList);
        return this.paginateList;
    }

    private StringBuilder constructQuery(String boundaryType, Integer id, String licenseType, Installment currentInstallment) {
        StringBuilder queryStr = new StringBuilder(" select NVL(act, 0) AS act, NVL(can, 0) AS can, NVL(obj, 0) AS obj, NVL(ren, 0) AS ren, NVL(totalamount, 0) AS totalamount,egb.id_bndry bb , egb.name from ").append(" (select boundary.id_bndry, boundary.name from eg_boundary boundary , eg_boundary_type boundarytype ").append(" where boundarytype.name='").append(boundaryType).append("' and boundary.id_bndry_type= boundarytype.id_bndry_type").append(" and boundary.is_history = 'N'");
        if (id != null && id > 0 && boundaryType.equalsIgnoreCase("Ward")) {
            queryStr.append(" and boundary.parent=").append(id);
        }
        queryStr.append(") egb ").append(" left outer join ").append(" (select sum(issueCount) as act ,sum(canCount)as can,sum(objCount)as obj,sum(renCount)as ren ,sum(amount) as totalamount,bb from ").append(" (select case when status.status_name='").append("Active").append("' and ld.renewal_date is null and ld.id_installment=").append(currentInstallment.getId()).append(" then 1 else 0 end as issueCount, ").append(" case when status.status_name='").append("Cancelled").append("' and ld.id_installment=").append(currentInstallment.getId()).append(" then 1 else 0 end as canCount, ").append(" case when status.status_name='").append("Objected").append("' and ld.id_installment=").append(currentInstallment.getId()).append(" then 1 else 0 end as objCount, ").append(" case when status.status_name='").append("Active").append("'and ld.renewal_date is not null and ld.id_installment=").append(currentInstallment.getId()).append(" then 1 else 0 end as renCount, ").append(" case when status.status_name='").append("Active").append("' and ld.id_installment=").append(currentInstallment.getId()).append(" then demand.base_demand else 0 end as amount, ");
        if (boundaryType.equalsIgnoreCase("Zone")) {
            queryStr.append(" boun.parent as bb");
        } else if (boundaryType.equalsIgnoreCase("Ward")) {
            queryStr.append(" boun.id_bndry as bb");
        }
        queryStr.append(" from EGTL_license lic, EGTL_mstr_status status,eg_boundary boun  , EGTL_license_demand ld , eg_demand demand  where lic.id_status=status.id_status ").append(" and  status.status_name in('").append("Active").append("','").append("Cancelled").append("','").append("Objected").append("') and lic.license_type='").append(licenseType).append("' and boun.id_bndry= lic.id_adm_bndry").append(" and boun.is_history = 'N'").append(" and lic.id= ld.id_license and ld.id_demand=demand.id )group by bb) t ").append(" on egb.ID_BNDRY = t.bb\torder by LPAD(name,10) ");
        return queryStr;
    }

    public EgovPaginatedList getTradeWiseReportList(String pageNo, String moduleName, String licenseType, String type) {
        Installment currentInstallment = this.getCurrentInstallment(moduleName);
        return this.populateTradeWiseReport(pageNo, licenseType, type, currentInstallment);
    }

    private EgovPaginatedList populateTradeWiseReport(String pageNo, String licenseType, String type, Installment installment) {
        this.query = this.constructQueryForTradeList(licenseType, installment, type).toString();
        SQLQuery hibQuery = this.persistenceService.getSession().createSQLQuery(String.valueOf(this.query));
        this.pageNum = pageNo == null ? Integer.valueOf(1) : Integer.valueOf(pageNo);
        Integer fullSize = hibQuery.list().size();
        Page page = new Page((Query)hibQuery, this.pageNum, this.pageSize);
        this.pageList = page.getList();
        this.paginateList = new EgovPaginatedList(page, fullSize.intValue());
        if (this.pageList != null) {
            for (Object[] objects : this.pageList) {
                this.hashMap = new HashMap<String, Object>();
                this.hashMap.put("NEW", objects[0]);
                this.hashMap.put("CANCELLED", objects[1]);
                this.hashMap.put("OBJECTED", objects[2]);
                this.hashMap.put("RENEWED", objects[3]);
                this.hashMap.put("PENDING_RENEWALS", this.getPendingRenewals(licenseType, null, Long.valueOf(String.valueOf(objects[6])), this.getPendingRenewalsDate(installment)));
                this.hashMap.put("TOTAL_LICENSES", Long.valueOf(String.valueOf(objects[0])) + Long.valueOf(String.valueOf(objects[3])));
                this.hashMap.put("TRADE_ID", objects[5]);
                this.hashMap.put("TOTAL_AMOUNT", objects[4]);
                this.licenseList.add(this.hashMap);
            }
        }
        this.paginateList.setList(this.licenseList);
        return this.paginateList;
    }

    private StringBuilder constructQueryForTradeList(String licenseType, Installment currentInstallment, String type) {
        return new StringBuilder(" select NVL(act, 0) AS act, NVL(can, 0) AS can, NVL(obj, 0) AS obj,NVL(ren, 0) AS ren, NVL(totalamount, 0) AS totalamount, scat.trade_name,scat.id from ").append(" (select  scateg.name as trade_name,scateg.id from EGTL_mstr_sub_category scateg ,EGTL_mstr_license_type ltype").append(" where scateg.id_license_type= ltype.id  and ltype.name='").append(type).append("' ) scat").append(" LEFT OUTER JOIN").append(" ( select sum(issueCount) as act,sum(canCount) as can,sum(objCount)as obj,sum(renCount) as ren, sum(amount) as totalamount, trade_name,id from ( ").append(" select case when status.status_name='").append("Active").append("' and ld.renewal_date is null and ld.id_installment=").append(currentInstallment.getId()).append(" then 1 else 0 end as issueCount, ").append(" case when status.status_name='").append("Cancelled").append("'  and ld.id_installment=").append(currentInstallment.getId()).append(" then 1 else 0 end as canCount , ").append(" case when status.status_name='").append("Objected").append("'  and ld.id_installment=").append(currentInstallment.getId()).append(" then 1 else 0 end as objCount , ").append(" case when status.status_name='").append("Active").append("'and ld.renewal_date is not null and ld.id_installment=").append(currentInstallment.getId()).append(" then 1 else 0 end as renCount, ").append(" case when status.status_name='").append("Active").append("'  and ld.id_installment=").append(currentInstallment.getId()).append(" then demand.base_demand else 0 end as amount").append(" ,subcateg.name as trade_name ,subcateg.id ").append(" from EGTL_license lic, EGTL_mstr_status status , EGTL_license_demand ld , eg_demand demand ,").append(" EGTL_mstr_sub_category subcateg where ").append(" lic.id_status=status.id_status ").append(" and  status.status_name in('").append("Active").append("','").append("Cancelled").append("','").append("Objected").append("') and lic.license_type='").append(licenseType).append("'  ").append(" and lic.id= ld.id_license and ld.id_demand=demand.id ").append(" and lic.id_sub_category=subcateg.id ").append(" )group by trade_name,id ) t").append("  ON scat.id = t.id").append(" order by trade_name asc");
    }

    public EgovPaginatedList getLateRenewalsListReport(String pageNo, String moduleName, String licenseType) {
        Installment currentInstallment = this.getCurrentInstallment(moduleName);
        return this.populateLateRenewalsReport(pageNo, licenseType, currentInstallment);
    }

    private EgovPaginatedList populateLateRenewalsReport(String pageNo, String licenseType, Installment installment) {
        this.query = this.constructQueryForLateRenewalsList(licenseType, installment).toString();
        SQLQuery hibQuery = this.persistenceService.getSession().createSQLQuery(this.query);
        this.pageNum = pageNo == null ? Integer.valueOf(1) : Integer.valueOf(pageNo);
        Integer fullSize = hibQuery.list().size();
        Page page = new Page((Query)hibQuery, this.pageNum, this.pageSize);
        this.pageList = page.getList();
        this.paginateList = new EgovPaginatedList(page, fullSize.intValue());
        if (this.pageList != null) {
            for (Object[] objects : this.pageList) {
                this.hashMap = new HashMap<String, Object>();
                this.hashMap.put("NO_OF_LATE_RENEWALS", objects[0]);
                this.hashMap.put("WARD_NUM", objects[1]);
                this.hashMap.put("WARD_NAME", objects[3]);
                this.licenseList.add(this.hashMap);
            }
        }
        this.paginateList.setList(this.licenseList);
        return this.paginateList;
    }

    private StringBuilder constructQueryForLateRenewalsList(String licenseType, Installment installment) {
        StringBuilder queryStr = new StringBuilder(" select NVL(lateren, 0) AS lateren, egb.bndry_num,egb.id_bndry bb , egb.name from ").append(" (select boundary.id_bndry,boundary.bndry_num, boundary.name from eg_boundary boundary , eg_boundary_type boundarytype ").append(" where boundarytype.name='").append("Ward").append("' and boundary.id_bndry_type= boundarytype.id_bndry_type");
        queryStr.append(") egb ").append(" left outer join ").append(" (select sum(laterenCount) as lateren ,bb from ").append(" (select case when status.status_name='").append("Active").append("' and ld.renewal_date is not null AND ld.is_laterenewal='1' and ld.id_installment=").append(installment.getId()).append(" then 1 else 0 end as laterenCount, boun.id_bndry as bb");
        queryStr.append(" from  EGTL_license lic, EGTL_mstr_status status,eg_boundary boun  , EGTL_license_demand ld  where lic.id_status=status.id_status ").append(" and  status.status_name in('").append("Active").append("') and lic.license_type='").append(licenseType).append("' and boun.id_bndry= lic.id_adm_bndry").append(" and lic.id= ld.id_license )group by bb) t ").append(" on egb.ID_BNDRY = t.bb\torder by LPAD(name,10) ");
        return queryStr;
    }

    public List<Map<String, Object>> getTotalsForWardWiseReport(Integer zoneId, String moduleName, String licenseType) {
        Installment currentInstallment = this.getCurrentInstallment(moduleName);
        return this.populateTotalsForWardWiseReport(zoneId, licenseType, currentInstallment);
    }

    private List<Map<String, Object>> populateTotalsForWardWiseReport(Integer zoneId, String licenseType, Installment installment) {
        this.query = this.constructQuery("Ward", zoneId, licenseType, installment).toString();
        this.query = "Select sum(act),sum(can),sum(obj),sum(ren),sum(totalamount) from(" + this.query + ")";
        return this.getTotalList(licenseType, installment);
    }

    public List<Map<String, Object>> getTotalForTradeWiseReport(String moduleName, String licenseType, String type) {
        Installment currentInstallment = this.getCurrentInstallment(moduleName);
        return this.populateTotalForTradeWiseReport(licenseType, type, currentInstallment);
    }

    private List<Map<String, Object>> populateTotalForTradeWiseReport(String licenseType, String type, Installment currentInstallment) {
        this.query = this.constructQueryForTradeList(licenseType, currentInstallment, type).toString();
        this.query = "Select sum(act),sum(can),sum(obj),sum(ren),sum(totalamount) from(" + this.query + ")";
        return this.getTotalList(licenseType, currentInstallment);
    }

    public List<Map<String, Object>> getTotalForLateRenewalsReport(String moduleName, String licenseType) {
        Installment currentInstallment = this.getCurrentInstallment(moduleName);
        return this.populateTotalForLateRenewalsReport(licenseType, currentInstallment);
    }

    private List<Map<String, Object>> populateTotalForLateRenewalsReport(String licenseType, Installment currentInstallment) {
        this.query = this.constructQueryForLateRenewalsList(licenseType, currentInstallment).toString();
        this.query = "Select sum(lateren) from(" + this.query + ")";
        SQLQuery hibQuery = this.persistenceService.getSession().createSQLQuery(String.valueOf(this.query));
        List result = hibQuery.list();
        ArrayList<Map<String, Object>> totalList = new ArrayList<Map<String, Object>>();
        HashMap totalHashMap = new HashMap();
        totalHashMap.put("TOTAL_LATEREN", result.get(0));
        totalList.add(totalHashMap);
        return totalList;
    }

    protected List<Map<String, Object>> getTotalList(String licenseType, Installment installment) {
        return this.populateTotalList(licenseType, installment);
    }

    private List<Map<String, Object>> populateTotalList(String licenseType, Installment installment) {
        SQLQuery hibQuery = this.persistenceService.getSession().createSQLQuery(String.valueOf(this.query));
        List result = hibQuery.list();
        Iterator iterator = result.iterator();
        ArrayList<Map<String, Object>> totalList = new ArrayList<Map<String, Object>>();
        while (iterator.hasNext()) {
            Object[] objects = (Object[])iterator.next();
            HashMap<String, Object> totalHashMap = new HashMap<String, Object>();
            totalHashMap.put("TOTAL_NEW", objects[0]);
            totalHashMap.put("TOTAL_CAN", objects[1]);
            totalHashMap.put("TOTAL_OBJ", objects[2]);
            totalHashMap.put("TOTAL_RENEWED", objects[3]);
            totalHashMap.put("TOTAL_ISSUED", Long.valueOf(String.valueOf(objects[0])) + Long.valueOf(String.valueOf(objects[3])));
            totalHashMap.put("TOTAL_AMT", new BigDecimal(objects[4].toString()).setScale(2, 0));
            totalHashMap.put("TOTAL_PENDING", this.getPendingRenewals(licenseType, null, null, this.getPendingRenewalsDate(installment)));
            totalList.add(totalHashMap);
        }
        return totalList;
    }

    private Date getPendingRenewalsDate(Installment installment) {
        return installment.getToDate().after(new Date()) ? new Date() : installment.getFromDate();
    }

    private Object getPendingRenewals(String licenseType, Long boundaryId, Long subcategoryId, Date date) {
        StringBuilder queryStr = new StringBuilder(" select NVL(SUM(pren1)+SUM(pren2),0) from (SELECT ").append(" CASE WHEN expired = 0 AND months_between(dateofexpiry, ?)<1 THEN 1 ELSE 0 END AS pren1 , ").append(" CASE WHEN expired = 1 AND months_between(dateofexpiry, ?)>-6 THEN 1 ELSE 0 END AS pren2  FROM ").append(" (SELECT CASE WHEN ?<dateofexpiry THEN 0 ELSE 1 END AS expired,id_adm_bndry,dateofexpiry, license_type, id_status,id_sub_category ").append(" FROM EGTL_license) lic ,EGTL_mstr_status status,eg_boundary boun ").append(" WHERE lic.id_status=status.id_status AND status.status_name ='").append("Active").append("' AND lic.license_type='").append(licenseType).append("' ").append(" AND boun.id_bndry = lic.id_adm_bndry ");
        if (boundaryId != null && boundaryId > 0L) {
            queryStr.append(" and boun.id_bndry=").append(boundaryId);
        }
        if (subcategoryId != null && subcategoryId > 0L) {
            queryStr.append(" and lic.id_sub_category=").append(subcategoryId);
        }
        queryStr.append(" )");
        SQLQuery hibQuery = this.persistenceService.getSession().createSQLQuery(String.valueOf(queryStr));
        hibQuery.setDate(0, date);
        hibQuery.setDate(1, date);
        hibQuery.setDate(2, date);
        List result = hibQuery.list();
        return result.get(0);
    }

    public String getParameterValue(String field, Map<String, String[]> parameters) {
        String[] fieldArray = parameters.get(field);
        return fieldArray != null ? fieldArray[0] : null;
    }

    public Installment getCurrentInstallment(String moduleName) {
        return this.installmentDao.getInsatllmentByModuleForGivenDate(this.moduleService.getModuleByName(moduleName), new Date());
    }
}

