/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.tl.entity.dto.BaseRegisterForm;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BaseRegisterService {
    @PersistenceContext
    private EntityManager entityManager;

    public List<BaseRegisterForm> search(BaseRegisterForm baseRegisterForm) {
        SQLQuery finalQuery = this.prepareQuery(baseRegisterForm);
        finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(BaseRegisterForm.class));
        if (baseRegisterForm.getCategoryId() != null) {
            finalQuery.setParameter("categoryId", (Object)baseRegisterForm.getCategoryId());
        }
        if (baseRegisterForm.getSubCategoryId() != null) {
            finalQuery.setParameter("subCategoryId", (Object)baseRegisterForm.getSubCategoryId());
        }
        if (baseRegisterForm.getStatusId() != null) {
            finalQuery.setParameter("statusId", (Object)baseRegisterForm.getStatusId());
        }
        if (baseRegisterForm.getWardId() != null) {
            finalQuery.setParameter("wardId", (Object)baseRegisterForm.getWardId());
        }
        return finalQuery.list();
    }

    private SQLQuery prepareQuery(BaseRegisterForm baseRegisterForm) {
        StringBuilder whereQry = new StringBuilder();
        StringBuilder selectQry = new StringBuilder("select \"licenseid\", \"licensenumber\", \"tradetitle\", \"owner\", \"mobile\", \"categoryname\", \"subcategoryname\", \"assessmentno\", \"wardname\", \"localityname\", trim(regexp_replace(\"tradeaddress\", '\\s+', ' ', 'g')) as \"tradeaddress\", \"commencementdate\", \"statusname\", cast(arrearlicensefee as bigint) AS \"arrearlicensefee\", cast(arrearpenaltyfee as bigint) AS \"arrearpenaltyfee\", cast(curlicensefee as bigint) AS \"curlicensefee\", cast(curpenaltyfee as bigint) AS \"curpenaltyfee\",\"unitofmeasure\",\"tradewt\",\"rateval\"  from egtl_mv_baseregister_view where 1=1 ");
        if (baseRegisterForm.getCategoryId() != null) {
            whereQry = whereQry.append(" and cat = :categoryId");
        }
        if (baseRegisterForm.getSubCategoryId() != null) {
            whereQry = whereQry.append(" and subcat = :subCategoryId");
        }
        whereQry = baseRegisterForm.getStatusId() != null ? whereQry.append(" and status = :statusId") : whereQry.append(" and statusname not in ('Cancelled','Suspended')");
        if (baseRegisterForm.getWardId() != null) {
            whereQry = whereQry.append(" and ward = :wardId");
        }
        return ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(selectQry.append((CharSequence)whereQry).toString());
    }
}

