/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.egov.commons.Installment;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.dao.DemandGenericHibDao;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseDemand;
import org.egov.tl.entity.LicenseDocument;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.entity.enums.ApplicationType;
import org.egov.tl.repository.LicenseDocumentTypeRepository;
import org.egov.tl.repository.LicenseRepository;
import org.egov.tl.service.DocumentTypeService;
import org.egov.tl.service.FeeMatrixService;
import org.egov.tl.service.LicenseAppTypeService;
import org.egov.tl.service.LicenseStatusService;
import org.egov.tl.service.NatureOfBusinessService;
import org.egov.tl.service.PenaltyRatesService;
import org.egov.tl.service.ValidityService;
import org.egov.tl.service.es.LicenseApplicationIndexService;
import org.egov.tl.utils.LicenseNumberUtils;
import org.egov.tl.utils.LicenseUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class AbstractLicenseService<T extends License> {
    public static final String ARREAR = "arrear";
    private static final String CURRENT = "current";
    private static final String PENALTY = "penalty";
    @Autowired
    @Qualifier(value="entityQueryService")
    protected PersistenceService entityQueryService;
    @Autowired
    protected InstallmentHibDao installmentDao;
    @Autowired
    protected LicenseNumberUtils licenseNumberUtils;
    @Autowired
    protected DocumentTypeService documentTypeService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    protected FileStoreService fileStoreService;
    @Autowired
    protected FeeMatrixService<License> feeMatrixService;
    @Autowired
    protected LicenseDocumentTypeRepository licenseDocumentTypeRepository;
    @Autowired
    protected LicenseApplicationIndexService licenseApplicationIndexService;
    @Autowired
    protected SecurityUtils securityUtils;
    @Autowired
    protected DemandGenericHibDao demandGenericDao;
    @Autowired
    protected ValidityService validityService;
    protected SimpleWorkflowService<T> licenseWorkflowService;
    @Autowired
    protected LicenseRepository licenseRepository;
    @Autowired
    protected LicenseStatusService licenseStatusService;
    @Autowired
    protected LicenseAppTypeService licenseAppTypeService;
    @Autowired
    protected PositionMasterService positionMasterService;
    @Autowired
    protected NatureOfBusinessService natureOfBusinessService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private PenaltyRatesService penaltyRatesService;
    @Autowired
    private LicenseUtils licenseUtils;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DesignationService designationService;

    protected abstract LicenseAppType getLicenseApplicationTypeForRenew();

    protected abstract LicenseAppType getLicenseApplicationType();

    protected abstract Module getModuleName();

    protected abstract NatureOfBusiness getNatureOfBusiness();

    protected abstract void sendEmailAndSMS(T var1, String var2);

    public void setLicenseWorkflowService(SimpleWorkflowService<T> licenseWorkflowService) {
        this.licenseWorkflowService = licenseWorkflowService;
    }

    public T getLicenseById(Long id) {
        return (T)((Object)((License)((Object)this.licenseRepository.findOne(id))));
    }

    @Transactional
    public void create(T license, WorkflowBean workflowBean) {
        Date fromRange = this.installmentDao.getInsatllmentByModuleForGivenDate(this.getModuleName(), new DateTime().toDate()).getFromDate();
        Date toRange = this.installmentDao.getInsatllmentByModuleForGivenDate(this.getModuleName(), new DateTime().plusYears(1).toDate()).getToDate();
        if (((License)((Object)license)).getCommencementDate().before(fromRange) || ((License)((Object)license)).getCommencementDate().after(toRange)) {
            throw new ValidationException("TL-009", "TL-009", new String[0]);
        }
        ((License)((Object)license)).setLicenseAppType(this.getLicenseApplicationType());
        this.raiseNewDemand(license);
        ((License)((Object)license)).getLicensee().setLicense((License)((Object)license));
        ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Acknowledged"));
        ((License)((Object)license)).setApplicationNumber(this.licenseNumberUtils.generateApplicationNumber());
        this.processAndStoreDocument(((License)((Object)license)).getDocuments(), (License)((Object)license));
        String currentUserRoles = this.securityUtils.getCurrentUser().getRoles().toString();
        if (!currentUserRoles.contains("CSC Operator")) {
            this.transitionWorkFlow(license, workflowBean);
        } else {
            this.wfWithCscOperator(license, workflowBean);
        }
        this.licenseRepository.save(license);
        this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex((License)((Object)license));
        this.sendEmailAndSMS(license, workflowBean.getWorkFlowAction());
    }

    private void wfWithCscOperator(T license, WorkflowBean workflowBean) {
        WorkFlowMatrix wfmatrix;
        String natureOfWork;
        Assignment wfAssignment;
        List assignmentList = this.assignmentService.findAllAssignmentsByDeptDesigAndDates(this.departmentService.getDepartmentByName("PUBLIC HEALTH AND SANITATION").getId(), this.designationService.getDesignationByName("Junior Assistant").getId(), new Date());
        if (assignmentList.isEmpty()) {
            assignmentList = this.assignmentService.findAllAssignmentsByDeptDesigAndDates(this.departmentService.getDepartmentByName("PUBLIC HEALTH AND SANITATION").getId(), this.designationService.getDesignationByName("Revenue Clerk").getId(), new Date());
        }
        if (!assignmentList.isEmpty()) {
            wfAssignment = (Assignment)assignmentList.get(0);
            natureOfWork = ((License)((Object)license)).isReNewApplication() ? "Renewal of Trade License" : "New Trade License";
            wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), "PUBLIC HEALTH AND SANITATION", null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState(), null);
            if (((License)((Object)license)).isReNewApplication()) {
                license.reinitiateTransition();
            } else {
                license.transition();
            }
        } else {
            throw new ValidationException("license.wf.initiator.not.defined", "license.wf.initiator.not.defined", new String[0]);
        }
        license.start().withSenderName(wfAssignment.getEmployee().getUsername() + "::" + wfAssignment.getEmployee().getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(natureOfWork).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(wfAssignment.getPosition()).withNextAction(wfmatrix.getNextAction()).withInitiator(wfAssignment.getPosition());
        ((License)((Object)license)).setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("TRADELICENSE", "CREATED"));
    }

    private BigDecimal raiseNewDemand(T license) {
        LicenseDemand ld = new LicenseDemand();
        Module moduleName = this.getModuleName();
        BigDecimal totalAmount = BigDecimal.ZERO;
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(moduleName, ((License)((Object)license)).getCommencementDate());
        ld.setIsHistory("N");
        ld.setEgInstallmentMaster(installment);
        ld.setLicense((License)((Object)license));
        ld.setIsLateRenewal('0');
        ld.setCreateDate(new Date());
        ld.setModifiedDate(new Date());
        List<FeeMatrixDetail> feeMatrixDetails = this.feeMatrixService.getLicenseFeeDetails((License)((Object)license), ((License)((Object)license)).getCommencementDate());
        for (FeeMatrixDetail fm : feeMatrixDetails) {
            EgDemandReasonMaster reasonMaster = this.demandGenericDao.getDemandReasonMasterByCode(fm.getFeeMatrix().getFeeType().getName(), moduleName);
            EgDemandReason reason = this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(reasonMaster, installment, moduleName);
            if (fm.getFeeMatrix().getFeeType().getName().contains("Late") || reason == null) continue;
            ld.getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)fm.getAmount(), (EgDemandReason)reason, (BigDecimal)BigDecimal.ZERO));
            totalAmount = totalAmount.add(fm.getAmount());
        }
        ld.setBaseDemand(totalAmount);
        ((License)((Object)license)).setLicenseDemand(ld);
        return totalAmount;
    }

    public License updateDemandForChangeTradeArea(T license) {
        LicenseDemand licenseDemand = ((License)((Object)license)).getLicenseDemand();
        Set demandDetails = licenseDemand.getEgDemandDetails();
        Date licenseDate = ((License)((Object)license)).isNewApplication() ? ((License)((Object)license)).getCommencementDate() : ((License)((Object)license)).getLicenseDemand().getEgInstallmentMaster().getFromDate();
        List<FeeMatrixDetail> feeList = this.feeMatrixService.getLicenseFeeDetails((License)((Object)license), licenseDate);
        for (EgDemandDetails dmd : demandDetails) {
            for (FeeMatrixDetail fm : feeList) {
                if (!licenseDemand.getEgInstallmentMaster().equals((Object)dmd.getEgDemandReason().getEgInstallmentMaster()) || !dmd.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase(fm.getFeeMatrix().getFeeType().getName())) continue;
                dmd.setAmount(fm.getAmount());
                dmd.setModifiedDate(new Date());
            }
        }
        this.recalculateBaseDemand(licenseDemand);
        return license;
    }

    @Transactional
    public void recalculateDemand(List<FeeMatrixDetail> feeList, T license) {
        LicenseDemand licenseDemand = ((License)((Object)license)).getCurrentDemand();
        for (EgDemandDetails dmd : licenseDemand.getEgDemandDetails()) {
            for (FeeMatrixDetail fm : feeList) {
                if (!licenseDemand.getEgInstallmentMaster().equals((Object)dmd.getEgDemandReason().getEgInstallmentMaster()) || !dmd.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase(fm.getFeeMatrix().getFeeType().getName())) continue;
                dmd.setAmount(fm.getAmount().setScale(0, RoundingMode.HALF_UP));
                dmd.setAmtCollected(BigDecimal.ZERO);
            }
        }
        this.recalculateBaseDemand(licenseDemand);
    }

    @Transactional
    public void createLegacyLicense(T license, Map<Integer, Integer> legacyInstallmentwiseFees, Map<Integer, Boolean> legacyFeePayStatus) {
        if (this.licenseRepository.findByOldLicenseNumber(((License)((Object)license)).getOldLicenseNumber()) != null) {
            throw new ValidationException("TL-001", "TL-001", new String[]{((License)((Object)license)).getOldLicenseNumber()});
        }
        this.addLegacyDemand(legacyInstallmentwiseFees, legacyFeePayStatus, license);
        this.processAndStoreDocument(((License)((Object)license)).getDocuments(), (License)((Object)license));
        ((License)((Object)license)).setLicenseAppType(this.getLicenseApplicationType());
        ((License)((Object)license)).getLicensee().setLicense((License)((Object)license));
        ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Active"));
        ((License)((Object)license)).setApplicationNumber(this.licenseNumberUtils.generateApplicationNumber());
        ((License)((Object)license)).setLegacy(true);
        ((License)((Object)license)).setActive(true);
        ((License)((Object)license)).setLicenseNumber(this.licenseNumberUtils.generateLicenseNumber());
        this.validityService.applyLicenseValidity((License)((Object)license));
        this.licenseRepository.save(license);
    }

    private void addLegacyDemand(Map<Integer, Integer> legacyInstallmentwiseFees, Map<Integer, Boolean> legacyFeePayStatus, T license) {
        LicenseDemand licenseDemand = new LicenseDemand();
        licenseDemand.setIsHistory("N");
        licenseDemand.setCreateDate(new Date());
        licenseDemand.setModifiedDate(new Date());
        licenseDemand.setLicense((License)((Object)license));
        licenseDemand.setIsLateRenewal('0');
        Module module = this.getModuleName();
        for (Map.Entry<Integer, Integer> legacyInstallmentwiseFee : legacyInstallmentwiseFees.entrySet()) {
            if (legacyInstallmentwiseFee.getValue() == null || legacyInstallmentwiseFee.getValue() <= 0) continue;
            Installment installment = this.installmentDao.fetchInstallmentByModuleAndInstallmentNumber(module, legacyInstallmentwiseFee.getKey());
            licenseDemand.setEgInstallmentMaster(installment);
            BigDecimal demandAmount = BigDecimal.valueOf(legacyInstallmentwiseFee.getValue().intValue()).setScale(0, RoundingMode.HALF_UP);
            BigDecimal amtCollected = legacyFeePayStatus.get(legacyInstallmentwiseFee.getKey()) == null || legacyFeePayStatus.get(legacyInstallmentwiseFee.getKey()) == false ? BigDecimal.ZERO : demandAmount;
            licenseDemand.getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)demandAmount, (EgDemandReason)this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(this.demandGenericDao.getDemandReasonMasterByCode("License Fee", module), installment, module), (BigDecimal)amtCollected));
            licenseDemand.setBaseDemand(demandAmount.add(licenseDemand.getBaseDemand()).setScale(0, RoundingMode.HALF_UP));
            licenseDemand.setAmtCollected(amtCollected.add(licenseDemand.getAmtCollected()).setScale(0, RoundingMode.HALF_UP));
        }
        ((License)((Object)license)).setLicenseDemand(licenseDemand);
    }

    @Transactional
    public void updateLegacyLicense(T license, Map<Integer, Integer> updatedInstallmentFees, Map<Integer, Boolean> legacyFeePayStatus) {
        this.processAndStoreDocument(((License)((Object)license)).getDocuments(), (License)((Object)license));
        this.updateLegacyDemand(license, updatedInstallmentFees, legacyFeePayStatus);
        this.validityService.applyLicenseValidity((License)((Object)license));
        this.licenseRepository.save(license);
    }

    private void updateLegacyDemand(T license, Map<Integer, Integer> updatedInstallmentFees, Map<Integer, Boolean> legacyFeePayStatus) {
        LicenseDemand licenseDemand = ((License)((Object)license)).getCurrentDemand();
        Iterator demandDetails = licenseDemand.getEgDemandDetails().iterator();
        while (demandDetails.hasNext()) {
            EgDemandDetails demandDetail = (EgDemandDetails)demandDetails.next();
            Integer installmentNumber = demandDetail.getEgDemandReason().getEgInstallmentMaster().getInstallmentNumber();
            Integer updatedFee = updatedInstallmentFees.get(installmentNumber);
            Boolean feePaymentStatus = legacyFeePayStatus.get(installmentNumber);
            if (updatedFee != null) {
                BigDecimal updatedDemandAmt = BigDecimal.valueOf(updatedFee.intValue()).setScale(0, RoundingMode.HALF_UP);
                demandDetail.setAmount(updatedDemandAmt);
                if (feePaymentStatus != null && feePaymentStatus.booleanValue()) {
                    demandDetail.setAmtCollected(updatedDemandAmt);
                } else {
                    demandDetail.setAmtCollected(BigDecimal.ZERO);
                }
            } else {
                demandDetails.remove();
            }
            updatedInstallmentFees.put(installmentNumber, 0);
        }
        Module module = this.getModuleName();
        for (Map.Entry<Integer, Integer> updatedInstallmentFee : updatedInstallmentFees.entrySet()) {
            if (updatedInstallmentFee.getValue() == null || updatedInstallmentFee.getValue() <= 0) continue;
            Installment installment = this.installmentDao.fetchInstallmentByModuleAndInstallmentNumber(module, updatedInstallmentFee.getKey());
            BigDecimal demandAmount = BigDecimal.valueOf(updatedInstallmentFee.getValue().intValue()).setScale(0, RoundingMode.HALF_UP);
            BigDecimal amtCollected = legacyFeePayStatus.get(updatedInstallmentFee.getKey()) == null || legacyFeePayStatus.get(updatedInstallmentFee.getKey()) == false ? BigDecimal.ZERO : demandAmount;
            licenseDemand.getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)demandAmount, (EgDemandReason)this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(this.demandGenericDao.getDemandReasonMasterByCode("License Fee", module), installment, module), (BigDecimal)amtCollected));
        }
        this.recalculateBaseDemand(licenseDemand);
    }

    public void recalculateBaseDemand(LicenseDemand licenseDemand) {
        licenseDemand.setAmtCollected(BigDecimal.ZERO);
        licenseDemand.setBaseDemand(BigDecimal.ZERO);
        licenseDemand.setModifiedDate(new Date());
        for (EgDemandDetails demandDetail : licenseDemand.getEgDemandDetails()) {
            licenseDemand.setAmtCollected(licenseDemand.getAmtCollected().add(demandDetail.getAmtCollected()));
            licenseDemand.setBaseDemand(licenseDemand.getBaseDemand().add(demandDetail.getAmount()));
        }
    }

    @Transactional
    public void renew(T license, WorkflowBean workflowBean) {
        ((License)((Object)license)).setLicenseAppType(this.getLicenseApplicationTypeForRenew());
        String natureOfWork = ((License)((Object)license)).isReNewApplication() ? "Renewal of Trade License" : "New Trade License";
        Assignment wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(this.securityUtils.getCurrentUser().getId());
        ((License)((Object)license)).setApplicationNumber(this.licenseNumberUtils.generateApplicationNumber());
        this.recalculateDemand(this.feeMatrixService.getLicenseFeeDetails((License)((Object)license), ((License)((Object)license)).getLicenseDemand().getEgInstallmentMaster().getFromDate()), license);
        ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Acknowledged"));
        ((License)((Object)license)).setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("TRADELICENSE", "CREATED"));
        ((License)((Object)license)).setLicenseAppType(this.getLicenseApplicationTypeForRenew());
        User currentUser = this.securityUtils.getCurrentUser();
        String currentUserRoles = this.securityUtils.getCurrentUser().getRoles().toString();
        if (!currentUserRoles.contains("CSC Operator")) {
            WorkFlowMatrix wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState(), null);
            license.reinitiateTransition().start().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(natureOfWork).withStateValue(wfmatrix.getNextState()).withDateInfo(new DateTime().toDate()).withOwner(wfInitiator.getPosition()).withNextAction(wfmatrix.getNextAction()).withInitiator(wfInitiator.getPosition());
        } else {
            this.wfWithCscOperator(license, workflowBean);
        }
        this.licenseRepository.save(license);
        this.sendEmailAndSMS(license, workflowBean.getWorkFlowAction());
        this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex((License)((Object)license));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void raiseDemand(T licenze, Module module, Installment installment) {
        License license = (License)((Object)this.licenseRepository.findOne(((License)((Object)licenze)).getId()));
        Map<EgDemandReason, EgDemandDetails> reasonWiseDemandDetails = this.getReasonWiseDemandDetails(license.getLicenseDemand());
        for (FeeMatrixDetail feeMatrixDetail : this.feeMatrixService.getLicenseFeeDetails(license, installment.getFromDate())) {
            String feeType = feeMatrixDetail.getFeeMatrix().getFeeType().getName();
            if (feeType.contains("Late")) continue;
            EgDemandReason reason = this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(this.demandGenericDao.getDemandReasonMasterByCode(feeType, module), installment, module);
            if (reason == null) {
                throw new ValidationException("TL-007", "Demand reason missing for " + feeType, new String[0]);
            }
            EgDemandDetails licenseDemandDetail = reasonWiseDemandDetails.get(reason);
            if (licenseDemandDetail == null) {
                license.getLicenseDemand().getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)feeMatrixDetail.getAmount(), (EgDemandReason)reason, (BigDecimal)BigDecimal.ZERO));
            } else if (licenseDemandDetail.getBalance().compareTo(BigDecimal.ZERO) != 0) {
                licenseDemandDetail.setAmount(feeMatrixDetail.getAmount());
            }
            if (!license.getCurrentDemand().getEgInstallmentMaster().getInstallmentYear().before(installment.getInstallmentYear())) continue;
            license.getLicenseDemand().setEgInstallmentMaster(installment);
        }
        this.recalculateBaseDemand(license.getLicenseDemand());
        this.licenseRepository.save((Object)license);
    }

    public Map<EgDemandReason, EgDemandDetails> getReasonWiseDemandDetails(EgDemand currentDemand) {
        HashMap<EgDemandReason, EgDemandDetails> reasonWiseDemandDetails = new HashMap<EgDemandReason, EgDemandDetails>();
        if (currentDemand != null) {
            for (EgDemandDetails demandDetail : currentDemand.getEgDemandDetails()) {
                if (!"License Fee".equals(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
                reasonWiseDemandDetails.put(demandDetail.getEgDemandReason(), demandDetail);
            }
        }
        return reasonWiseDemandDetails;
    }

    @Transactional
    public void transitionWorkFlow(T license, WorkflowBean workflowBean) {
        String natureOfWork;
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        List assignments = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(user.getId());
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        Position wfInitiator = null;
        String string = natureOfWork = ((License)((Object)license)).isReNewApplication() ? "Renewal of Trade License" : "New Trade License";
        if (null != ((License)((Object)license)).getId()) {
            wfInitiator = this.getWorkflowInitiator(license);
        }
        if (wfInitiator != null && "Reject".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            if (wfInitiator.equals((Object)userAssignment.getPosition()) && ("Rejected".equals(license.getState().getValue()) || "License Created".equals(license.getState().getValue()))) {
                license.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            } else {
                String stateValue = "Rejected";
                license.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(natureOfWork).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator).withNextAction("Sanitary inspector Approve pending");
            }
        } else if ("Generate Certificate".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            WorkFlowMatrix wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), license.getCurrentState().getValue(), null);
            license.transition(false).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(natureOfWork).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(wfInitiator).withNextAction(wfmatrix.getNextAction());
        } else {
            WorkFlowMatrix wfmatrix;
            if (null != workflowBean.getApproverPositionId() && workflowBean.getApproverPositionId() != -1L) {
                pos = this.positionMasterService.getPositionById(workflowBean.getApproverPositionId());
            }
            if ("Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
                Assignment commissionerUsr = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
                pos = commissionerUsr.getPosition();
            }
            if (null == license.getState()) {
                if (assignments.isEmpty()) {
                    throw new ValidationException("wf.initiator.not.found", "No employee exist for creator's position", new String[0]);
                }
                wfInitiator = ((Assignment)assignments.get(0)).getPosition();
                wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState(), null);
                license.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(natureOfWork).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(wfInitiator).withNextAction(wfmatrix.getNextAction()).withInitiator(wfInitiator);
                ((License)((Object)license)).setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("TRADELICENSE", "CREATED"));
            } else if ("END".equalsIgnoreCase(license.getCurrentState().getNextAction())) {
                license.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(natureOfWork).withDateInfo(currentDate.toDate());
            } else if ("Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction()) && ((License)((Object)license)).getEgwStatus().getCode().equals("SECONDLVLCOLLECTIONPENDING")) {
                wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), license.getCurrentState().getValue(), null);
                license.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(natureOfWork).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            } else if ("Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction()) && ((License)((Object)license)).getEgwStatus().getCode().equals("APPROVED") && !this.licenseUtils.isDigitalSignEnabled().booleanValue()) {
                license.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(natureOfWork).withStateValue("Commissioner approved no collection").withDateInfo(currentDate.toDate()).withOwner(wfInitiator).withNextAction("Certificate generation pending");
            } else if ("Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction()) && ((License)((Object)license)).getEgwStatus().getCode().equals("APPROVED") && this.licenseUtils.isDigitalSignEnabled().booleanValue()) {
                license.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(natureOfWork).withStateValue("Digital sign-Commissioner Approved no collection").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("Digital Signature Pending");
            } else {
                wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), license.getCurrentState().getValue(), null);
                license.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask(natureOfWork).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            }
        }
    }

    protected Position getWorkflowInitiator(T license) {
        List assignments = Collections.emptyList();
        if (license.getState().getInitiatorPosition() != null) {
            assignments = this.assignmentService.getAssignmentsForPosition(license.getState().getInitiatorPosition().getId());
        }
        if (assignments.isEmpty()) {
            throw new ValidationException("wf.initiator.not.found", "No employee exist for creator's position", new String[0]);
        }
        return license.getState().getInitiatorPosition();
    }

    @Transactional
    public void processAndStoreDocument(List<LicenseDocument> documents, License license) {
        documents.forEach(document -> {
            document.setType((LicenseDocumentType)((Object)((Object)this.licenseDocumentTypeRepository.findOne(document.getType().getId()))));
            if (!document.getUploads().isEmpty() && !document.getUploadsContentType().isEmpty()) {
                int fileCount = 0;
                for (File file : document.getUploads()) {
                    FileStoreMapper fileStore = this.fileStoreService.store(file, document.getUploadsFileName().get(fileCount), document.getUploadsContentType().get(fileCount++), "EGTL");
                    document.getFiles().add(fileStore);
                }
                document.setEnclosed(true);
            } else if (document.getType().isMandatory() && document.getFiles().isEmpty()) {
                document.getFiles().clear();
                throw new ValidationException("TL-004", "TL-004", new String[]{document.getType().getName()});
            }
            document.setDocDate(new Date());
            document.setLicense(license);
        });
    }

    public List<LicenseDocumentType> getDocumentTypesByApplicationType(ApplicationType applicationType) {
        return this.documentTypeService.getDocumentTypesByApplicationType(applicationType);
    }

    public List<NatureOfBusiness> getAllNatureOfBusinesses() {
        return this.natureOfBusinessService.getNatureOfBusinesses();
    }

    public T getLicenseByLicenseNumber(String licenseNumber) {
        return (T)((Object)this.licenseRepository.findByLicenseNumber(licenseNumber));
    }

    public T getLicenseByApplicationNumber(String applicationNumber) {
        return (T)((Object)this.licenseRepository.findByApplicationNumber(applicationNumber));
    }

    public List<Installment> getLastFiveYearInstallmentsForLicense() {
        List installmentList = this.installmentDao.fetchInstallments(this.getModuleName(), new Date(), 6);
        Collections.reverse(installmentList);
        return installmentList;
    }

    public Map<String, Map<String, BigDecimal>> getOutstandingFee(T license) {
        HashMap<String, Map<String, BigDecimal>> outstandingFee = new HashMap<String, Map<String, BigDecimal>>();
        LicenseDemand licenseDemand = ((License)((Object)license)).getCurrentDemand();
        for (EgDemandDetails demandDetail : licenseDemand.getEgDemandDetails()) {
            Map<String, BigDecimal> feeByTypes;
            String demandReason = demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster();
            Installment installmentYear = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            if (outstandingFee.containsKey(demandReason)) {
                feeByTypes = (Map)outstandingFee.get(demandReason);
            } else {
                feeByTypes = new HashMap();
                feeByTypes.put(ARREAR, BigDecimal.ZERO);
                feeByTypes.put(CURRENT, BigDecimal.ZERO);
            }
            BigDecimal demandAmount = demandDetail.getAmount().subtract(demandDetail.getAmtCollected());
            if (installmentYear.equals((Object)licenseDemand.getEgInstallmentMaster())) {
                feeByTypes.put(CURRENT, demandAmount);
            } else {
                feeByTypes.put(ARREAR, ((BigDecimal)feeByTypes.get(ARREAR)).add(demandAmount));
            }
            outstandingFee.put(demandReason, feeByTypes);
        }
        return outstandingFee;
    }

    public Map<String, Map<String, BigDecimal>> getOutstandingFeeForDemandNotice(TradeLicense license, Installment currentInstallment, Installment previousInstallment) {
        HashMap<String, Map<String, BigDecimal>> outstandingFee = new HashMap<String, Map<String, BigDecimal>>();
        LicenseDemand licenseDemand = license.getCurrentDemand();
        Date endDateOfPreviousFinancialYear = new DateTime((Object)previousInstallment.getFromDate()).withMonthOfYear(12).withDayOfMonth(31).toDate();
        for (EgDemandDetails demandDetail : licenseDemand.getEgDemandDetails()) {
            Map<String, BigDecimal> feeByTypes;
            String demandReason = demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster();
            Installment installmentYear = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            if (demandReason.equalsIgnoreCase("Penalty")) continue;
            if (outstandingFee.containsKey(demandReason)) {
                feeByTypes = (Map)outstandingFee.get(demandReason);
            } else {
                feeByTypes = new HashMap();
                feeByTypes.put(ARREAR, BigDecimal.ZERO);
                feeByTypes.put(CURRENT, BigDecimal.ZERO);
                feeByTypes.put(PENALTY, BigDecimal.ZERO);
            }
            BigDecimal demandAmount = demandDetail.getAmount().subtract(demandDetail.getAmtCollected());
            if (demandAmount.compareTo(BigDecimal.valueOf(0L)) > 0) {
                if (installmentYear.equals((Object)currentInstallment)) {
                    feeByTypes.put(CURRENT, ((BigDecimal)feeByTypes.get(CURRENT)).add(demandAmount));
                } else {
                    feeByTypes.put(ARREAR, ((BigDecimal)feeByTypes.get(ARREAR)).add(demandAmount));
                    BigDecimal penaltyAmt = this.penaltyRatesService.calculatePenalty(installmentYear.getFromDate(), endDateOfPreviousFinancialYear, demandAmount, license);
                    feeByTypes.put(PENALTY, ((BigDecimal)feeByTypes.get(PENALTY)).add(penaltyAmt));
                }
            }
            outstandingFee.put(demandReason, feeByTypes);
        }
        return outstandingFee;
    }

    public List<License> getAllLicensesByNatureOfBusiness(String natureOfBusiness) {
        return this.licenseRepository.findByNatureOfBusinessName(natureOfBusiness);
    }

    @Transactional
    public void save(License license) {
        this.licenseRepository.save((Object)license);
    }

    public BigDecimal calculateFeeAmount(License license) {
        Date licenseDate = license.isNewApplication() ? license.getCommencementDate() : license.getLicenseDemand().getEgInstallmentMaster().getFromDate();
        List<FeeMatrixDetail> feeList = this.feeMatrixService.getLicenseFeeDetails(license, licenseDate);
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (FeeMatrixDetail fm : feeList) {
            totalAmount = totalAmount.add(fm.getAmount());
        }
        return totalAmount;
    }

    public BigDecimal recalculateLicenseFee(LicenseDemand licenseDemand) {
        BigDecimal licenseFee = BigDecimal.ZERO;
        for (EgDemandDetails demandDetail : licenseDemand.getEgDemandDetails()) {
            if (!demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().equals("License Fee") || !licenseDemand.getEgInstallmentMaster().equals((Object)demandDetail.getEgDemandReason().getEgInstallmentMaster())) continue;
            licenseFee = licenseFee.add(demandDetail.getAmount());
        }
        return licenseFee;
    }

    @Transactional
    public void cancelLicenseWorkflow(T license, WorkflowBean workflowBean) {
        User currentUser = this.securityUtils.getCurrentUser();
        String natureOfWork = "Closure License";
        Position owner = null;
        if (workflowBean.getApproverPositionId() != null) {
            owner = this.positionMasterService.getPositionById(workflowBean.getApproverPositionId());
        }
        WorkFlowMatrix wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState(), null);
        if (workflowBean.getWorkFlowAction().contains("Reject")) {
            if ("Rejected".equals(license.getState().getValue())) {
                this.licenseUtils.applicationStatusChange((License)((Object)license), "CERTIFICATEGENERATED");
                ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Active"));
                ((License)((Object)license)).setActive(true);
                license.transition(true).end().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(new DateTime().toDate());
            } else {
                this.licenseUtils.applicationStatusChange((License)((Object)license), "CREATED");
                ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Acknowledged"));
                String stateValue = "Rejected";
                license.transition(true).withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask("Closure License").withStateValue("Rejected").withDateInfo(new DateTime().toDate()).withOwner(license.getState().getInitiatorPosition()).withNextAction("SI/SS Approval Pending");
            }
        } else if (license.getState() == null || "END".equals(license.getState().getValue()) || "Closed".equals(license.getState().getValue())) {
            WorkFlowMatrix newwfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), "NEW", null);
            this.licenseUtils.applicationStatusChange((License)((Object)license), "CREATED");
            ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Acknowledged"));
            Assignment wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(this.securityUtils.getCurrentUser().getId());
            license.reinitiateTransition().start().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask("Closure License").withStateValue(newwfmatrix.getNextState()).withDateInfo(new DateTime().toDate()).withOwner(owner).withNextAction(newwfmatrix.getNextAction()).withInitiator(wfInitiator.getPosition());
        } else if ("Revenue Clerk/JA Approved".equals(license.getState().getValue()) || "Rejected".equals(license.getState().getValue())) {
            this.licenseUtils.applicationStatusChange((License)((Object)license), "CREATED");
            ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("UnderWorkflow"));
            license.transition(true).withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask("Closure License").withStateValue(wfmatrix.getNextState()).withDateInfo(new DateTime().toDate()).withOwner(owner).withNextAction(wfmatrix.getNextAction());
        } else if ("SI/SS Approved".equals(license.getState().getValue())) {
            this.licenseUtils.applicationStatusChange((License)((Object)license), "CANCELLED");
            ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Cancelled"));
            ((License)((Object)license)).setActive(false);
            Assignment commissionerUsr = this.assignmentService.getPrimaryAssignmentForUser(currentUser.getId());
            owner = commissionerUsr.getPosition();
            WorkFlowMatrix commWfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), license.getCurrentState().getValue(), null);
            license.transition(false).end().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withNatureOfTask("Closure License").withStateValue(commWfmatrix.getNextState()).withDateInfo(new DateTime().toDate()).withOwner(owner).withNextAction(commWfmatrix.getNextAction());
        }
        this.licenseRepository.save(license);
        this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex((License)((Object)license));
    }

    public boolean checkOldLicenseNumberIsDuplicated(T t) {
        return this.licenseRepository.findByOldLicenseNumberAndIdIsNot(((License)((Object)t)).getOldLicenseNumber(), ((License)((Object)t)).getId()) != null;
    }
}

